/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.screen;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.gui.Sprites;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.serverbound.MailboxMenuInboxActionC2SP;
import io.github.mortuusars.envelope.world.inventory.MailboxMenu;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryLog;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryRecord;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;

public class MailboxScreen
extends class_465<MailboxMenu> {
    public static final class_2960 TEXTURE = Envelope.resource("textures/gui/mailbox.png");
    public static final class_8666 ADDRESS_BUTTON_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/address_button"));
    public static final class_8666 ADDRESS_ATTENTION_BUTTON_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/address_attention_button"), Envelope.resource("mailbox/address_button_highlighted"));
    public static final class_8666 ADDRESS_DEFAULT_BUTTON_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/address_default_button"));
    public static final class_8666 REGULAR_MAIL_BUTTON_SPRITES = Sprites.threeStates(Envelope.resource("mailbox/mail_button"));
    public static final class_8666 ICON_ADDRESS_BLOCK_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_block"));
    public static final class_8666 ICON_ADDRESS_PLAYER_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_player"));
    public static final class_8666 ICON_ADDRESS_ENTITY_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_entity"));
    public static final class_8666 ICON_ADDRESS_MAIL_SERVICE_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_mail_service"));
    public static final class_8666 ICON_ADDRESS_UNKNOWN_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_unknown"));
    public static final class_8666 ICON_RETURNED_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_returned"));
    public static final class_8666 ICON_REJECTED_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_rejected"));
    public static final class_8666 ICON_UNCLAIMED_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_unclaimed"));
    public static final class_8666 NEW_MAIL_INDICATOR_SPRITES = Sprites.normalOnly(Envelope.resource("mailbox/new_mail_indicator"));
    protected static final int SCROLL_THUMB_TOP_HEIGHT = 3;
    protected static final int SCROLL_THUMB_MID_HEIGHT = 2;
    protected static final int SCROLL_THUMB_BOT_HEIGHT = 2;
    protected static final int SCROLL_THUMB_Y_OFFSET = 7;
    protected static final int MAX_INBOX_MAIL_BUTTONS = 8;
    protected class_2561 inboxLabel = class_2561.method_43471((String)"gui.envelope.mailbox.inbox");
    protected class_2561 sendLabel = class_2561.method_43471((String)"gui.envelope.mailbox.send");
    @Nullable
    protected class_1799 hoveredMail;
    protected class_344 addressButton;
    protected class_344 addressAttentionButton;
    protected class_344 addressDefaultButton;
    protected class_344 newMailButton;
    protected class_768 mailArea = new class_768(0, 0, 0, 0);
    protected class_768 scrollBarArea = new class_768(0, 0, 0, 0);
    protected class_768 scrollThumb = new class_768(0, 0, 0, 0);
    protected int scroll = 0;
    protected int scrollAtDragStart = 0;
    protected boolean isDraggingScrollbar = false;
    protected double dragDelta = 0.0;

    public MailboxScreen(MailboxMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
    }

    protected void method_25426() {
        this.field_2792 = 308;
        this.field_2779 = 170;
        this.field_25267 = Math.max(17, this.field_2792 / 2 - this.field_22793.method_27525((class_5348)this.field_22785) / 2 + 5);
        this.field_25268 = -10;
        this.field_25269 = 140;
        this.field_25270 = this.field_2779 - 94;
        super.method_25426();
        this.mailArea = new class_768(this.field_2776 + 8, this.field_2800 + 18, 117, 144);
        this.scrollBarArea = new class_768(this.field_2776 + 128, this.field_2800 + 18, 6, 144);
        this.addressButton = new class_344(this.field_2776 + this.field_25267 - 11, this.field_2800 - 11, 10, 10, ADDRESS_BUTTON_SPRITES, button -> this.setAsDefaultAddress(), (class_2561)class_2561.method_43471((String)"gui.envelope.mailbox.address"));
        this.addressButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.envelope.mailbox.address").method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.envelope.mailbox.address.tooltip"))));
        this.method_37063((class_364)this.addressButton);
        this.addressAttentionButton = new class_344(this.field_2776 + this.field_25267 - 11, this.field_2800 - 11, 10, 10, ADDRESS_ATTENTION_BUTTON_SPRITES, button -> this.setAsDefaultAddress(), (class_2561)class_2561.method_43471((String)"gui.envelope.mailbox.address"));
        this.addressAttentionButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.envelope.mailbox.address").method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.envelope.mailbox.address.tooltip"))));
        this.method_37063((class_364)this.addressAttentionButton);
        this.addressDefaultButton = new class_344(this.field_2776 + this.field_25267 - 11, this.field_2800 - 11, 10, 10, ADDRESS_DEFAULT_BUTTON_SPRITES, btn -> {});
        this.addressDefaultButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.envelope.mailbox.address.default").method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.envelope.mailbox.address.default.tooltip"))));
        this.addressDefaultButton.field_22763 = false;
        this.method_37063((class_364)this.addressDefaultButton);
        this.newMailButton = new class_344(this.field_2776 + 7, this.field_2800 + 6, 8, 8, NEW_MAIL_INDICATOR_SPRITES, button -> {
            this.refreshMail();
            this.scrollTo(0);
        });
        this.newMailButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.envelope.mailbox.mail.tooltip.new_mail").method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.envelope.mailbox.mail.tooltip.new_mail.click_to_refresh"))));
        this.method_37063((class_364)this.newMailButton);
        this.updateButtons();
    }

    protected void setAsDefaultAddress() {
        Minecrft.gameMode().method_2900(((MailboxMenu)this.method_17577()).field_7763, 0);
    }

    protected void refreshMail() {
        Minecrft.gameMode().method_2900(((MailboxMenu)this.method_17577()).field_7763, 1);
    }

    protected void updateScrollThumb() {
        int minSize = 7;
        int totalButtons = ((MailboxMenu)this.method_17577()).getMail().size();
        float ratio = 8.0f / (float)Math.max(totalButtons, 1);
        int size = class_3532.method_15340((int)class_3532.method_15386((float)((float)this.scrollBarArea.method_3320() * ratio)), (int)minSize, (int)this.scrollBarArea.method_3320());
        int midSize = size - 3 - 2;
        int correctedMidSize = Math.max(midSize - midSize % 2, 2);
        size = 3 + correctedMidSize + 2;
        float topRowPos = (float)this.scroll / (float)Math.max(1, totalButtons - 8);
        int pos = (int)class_3532.method_37959((float)topRowPos, (float)0.0f, (float)1.0f, (float)0.0f, (float)(this.scrollBarArea.method_3320() - size));
        this.scrollThumb = new class_768(this.scrollBarArea.method_3321(), this.scrollBarArea.method_3322() + pos, this.scrollBarArea.method_3319(), size);
    }

    protected void updateButtons() {
        this.addressButton.field_22764 = !((MailboxMenu)this.method_17577()).isDefaultAddress() && ((MailboxMenu)this.method_17577()).hasDefaultAddress();
        this.addressAttentionButton.field_22764 = !((MailboxMenu)this.method_17577()).hasDefaultAddress();
        this.addressDefaultButton.field_22764 = ((MailboxMenu)this.method_17577()).isDefaultAddress();
        this.newMailButton.field_22764 = ((MailboxMenu)this.method_17577()).hasNewMail();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateButtons();
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2385(class_332 guiGraphics, class_1735 slot) {
        super.method_2385(guiGraphics, slot);
        int mouseX = (int)(Minecrft.get().field_1729.method_1603() * (double)Minecrft.get().method_22683().method_4486() / (double)Minecrft.get().method_22683().method_4480());
        int mouseY = (int)(Minecrft.get().field_1729.method_1604() * (double)Minecrft.get().method_22683().method_4502() / (double)Minecrft.get().method_22683().method_4507());
        if (slot.method_7682() && slot.method_34266() == 1 && this.method_2378(slot.field_7873, slot.field_7872, 16, 16, mouseX, mouseY)) {
            guiGraphics.method_51740(class_1921.method_51785(), slot.field_7873 - 1, slot.field_7872 - 1, slot.field_7873 + 17, slot.field_7872, -2130706433, -2130706433, 0);
            guiGraphics.method_51740(class_1921.method_51785(), slot.field_7873 - 1, slot.field_7872, slot.field_7873, slot.field_7872 + 16, -2130706433, -2130706433, 0);
            guiGraphics.method_51740(class_1921.method_51785(), slot.field_7873 + 16, slot.field_7872, slot.field_7873 + 17, slot.field_7872 + 16, -2130706433, -2130706433, 0);
            guiGraphics.method_51740(class_1921.method_51785(), slot.field_7873 - 1, slot.field_7872 + 16, slot.field_7873 + 17, slot.field_7872 + 17, -2130706433, -2130706433, 0);
        }
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        class_1735 mailSlot;
        class_1735 foodSlot;
        this.hoveredMail = null;
        guiGraphics.method_25290(TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 512, 256);
        int addressBarX = this.field_25267 - 18;
        int addressBarWidth = this.field_2792 - addressBarX * 2;
        guiGraphics.method_25290(TEXTURE, this.field_2776 + addressBarX, this.field_2800 - 15, 0.0f, (float)this.field_2779, 5, 15, 512, 256);
        guiGraphics.method_25290(TEXTURE, this.field_2776 + addressBarX + 5, this.field_2800 - 15, 5.0f, (float)this.field_2779, addressBarWidth - 10, 15, 512, 256);
        guiGraphics.method_25290(TEXTURE, this.field_2776 + addressBarX + addressBarWidth - 5, this.field_2800 - 15, 303.0f, (float)this.field_2779, 5, 15, 512, 256);
        List<class_1799> mail = ((MailboxMenu)this.method_17577()).getMail();
        if (!mail.isEmpty()) {
            this.scroll = Math.clamp((long)this.scroll, 0, Math.max(0, mail.size() - 8));
            for (int i = 0; i < Math.min(mail.size(), 8); ++i) {
                int index = i + this.scroll;
                class_1799 item = mail.get(index);
                int x = 8;
                int y = 18 + 18 * i;
                boolean isHovering = this.method_2378(x + 1, y + 1, 115, 16, mouseX, mouseY);
                if (isHovering) {
                    this.hoveredMail = item;
                }
                this.renderMailButton(guiGraphics, partialTick, mouseX, mouseY, item, this.field_2776 + x, this.field_2800 + y);
            }
        } else if (((Object)((Object)this)).hashCode() % 20 == 0) {
            guiGraphics.method_25290(TEXTURE, this.field_2776 + 59, this.field_2800 + 92, 348.0f, 0.0f, 17, 9, 512, 256);
        }
        if (!(foodSlot = ((MailboxMenu)this.method_17577()).method_7611(0)).method_7681()) {
            guiGraphics.method_25290(TEXTURE, this.field_2776 + foodSlot.field_7873, this.field_2800 + foodSlot.field_7872, 314.0f, 0.0f, 16, 16, 512, 256);
        }
        if (!(mailSlot = ((MailboxMenu)this.method_17577()).method_7611(1)).method_7681()) {
            guiGraphics.method_25290(TEXTURE, this.field_2776 + mailSlot.field_7873 - 1, this.field_2800 + mailSlot.field_7872 - 1, 330.0f, 0.0f, 18, 18, 512, 256);
        }
        this.renderScrollBar(guiGraphics, partialTick, mouseX, mouseY);
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0x404040, false);
        int inboxLabelX = 68 - this.field_22793.method_27525((class_5348)this.inboxLabel) / 2;
        guiGraphics.method_51439(this.field_22793, this.inboxLabel, inboxLabelX, 6, 0x404040, false);
        if (((MailboxMenu)this.method_17577()).getMail().isEmpty()) {
            class_5250 empty = class_2561.method_43471((String)"gui.envelope.mailbox.empty");
            int emptyLabelX = 68 - this.field_22793.method_27525((class_5348)empty) / 2;
            guiGraphics.method_51439(this.field_22793, (class_2561)empty, emptyLabelX, 80, 0x606060, false);
        }
        int sendLabelX = 220 - this.field_22793.method_27525((class_5348)this.sendLabel) / 2;
        guiGraphics.method_51439(this.field_22793, this.sendLabel, sendLabelX, 6, 0x404040, false);
        guiGraphics.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040, false);
    }

    protected void renderMailButton(class_332 guiGraphics, float partialTick, int mouseX, int mouseY, class_1799 mail, int x, int y) {
        boolean isHovered = this.hoveredMail == mail;
        guiGraphics.method_52707(REGULAR_MAIL_BUTTON_SPRITES.method_52729(true, isHovered), x, y, 0, 117, 18);
        guiGraphics.method_51427(mail, x + 2, y + 1);
        class_8666 iconSprites = this.getDisplayedIcon(mail);
        class_2960 iconSprite = isHovered ? iconSprites.comp_1606() : iconSprites.comp_1604();
        guiGraphics.method_52707(iconSprite, x + 23, y + 4, 0, 10, 10);
        Object sender = this.getDisplayedSender(mail).getName().getString();
        if (this.field_22793.method_1727((String)sender) > 76) {
            sender = this.field_22793.method_27523((String)sender, 72) + "...";
        }
        guiGraphics.method_51433(this.field_22793, (String)sender, x + 36, y + 5, -7838649, false);
    }

    protected void renderScrollBar(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.updateScrollThumb();
        int state = 0;
        if (!this.canScroll()) {
            state = 2;
        } else if (this.isDraggingScrollbar || this.isMouseOver(this.scrollThumb, mouseX, mouseY)) {
            state = 1;
        }
        guiGraphics.method_25290(TEXTURE, this.scrollThumb.method_3321(), this.scrollThumb.method_3322(), 308.0f, (float)(state * 7), this.scrollThumb.method_3319(), 3, 512, 256);
        int middlePartsCount = (this.scrollThumb.method_3320() - 3 - 2) / 2;
        for (int i = 0; i < middlePartsCount; ++i) {
            guiGraphics.method_25290(TEXTURE, this.scrollThumb.method_3321(), this.scrollThumb.method_3322() + 3 + i * 2, 308.0f, (float)(state * 7 + 3), this.scrollThumb.method_3319(), 2, 512, 256);
        }
        guiGraphics.method_25290(TEXTURE, this.scrollThumb.method_3321(), this.scrollThumb.method_3322() + 3 + middlePartsCount * 2, 308.0f, (float)(5 + state * 7), this.scrollThumb.method_3319(), 2, 512, 256);
        if (!this.canScroll()) {
            guiGraphics.method_25290(TEXTURE, this.scrollThumb.method_3321(), this.scrollThumb.method_3322() + 3 + middlePartsCount * 2 + 1, 308.0f, (float)(5 + state * 7), this.scrollThumb.method_3319(), 2, 512, 256);
        }
    }

    protected void method_2380(class_332 guiGraphics, int x, int y) {
        super.method_2380(guiGraphics, x, y);
        if (this.hoveredMail != null) {
            this.renderMailTooltip(guiGraphics, x, y, this.hoveredMail);
        }
    }

    protected void renderMailTooltip(class_332 guiGraphics, int x, int y, class_1799 hoveredMail) {
        DeliveryLog deliveryLog;
        if (x >= this.field_2776 + 8 && x < this.field_2776 + 28) {
            guiGraphics.method_51437(this.field_22793, this.method_51454(hoveredMail), hoveredMail.method_32347(), x, y);
            return;
        }
        if (x >= this.field_2776 + 31 && x < this.field_2776 + 41) {
            guiGraphics.method_51438(this.field_22793, this.getDisplayedIconName(hoveredMail), x, y);
            return;
        }
        ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
        Address sender = this.getDisplayedSender(hoveredMail);
        if (this.field_22793.method_1727(sender.toString()) > 76) {
            tooltip.add(AddressFormatter.of(sender).withIcon().withIconColor(-1651816).withColor(class_124.field_1068).toComponent());
        }
        if (!(deliveryLog = Mail.getLog(hoveredMail)).isEmpty()) {
            tooltip.add(class_2561.method_43471((String)"gui.envelope.delivery_log"));
            for (DeliveryRecord record : deliveryLog.records()) {
                tooltip.add(record.toComponent(Minecrft.level().method_8510()));
            }
        }
        if (!tooltip.isEmpty()) {
            guiGraphics.method_51437(this.field_22793, tooltip, Optional.empty(), x, y);
        }
    }

    public boolean canScroll() {
        return ((MailboxMenu)this.method_17577()).getMail().size() > 8;
    }

    public void scroll(int amount) {
        this.scrollTo(this.scroll + amount);
    }

    public void scrollTo(int buttonIndex) {
        int maxScrollWhenAtEnd = Math.max(0, ((MailboxMenu)this.method_17577()).getMail().size() - 8);
        this.scroll = class_3532.method_15340((int)buttonIndex, (int)0, (int)maxScrollWhenAtEnd);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 268) {
            this.scroll(Integer.MIN_VALUE);
            return true;
        }
        if (keyCode == 269) {
            this.scroll(Integer.MAX_VALUE);
            return true;
        }
        if (keyCode == 265) {
            this.scroll(-1);
            return true;
        }
        if (keyCode == 264) {
            this.scroll(1);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredMail != null) {
            int index = ((MailboxMenu)this.method_17577()).getMail().indexOf(this.hoveredMail);
            if (index == -1) {
                return false;
            }
            MailboxMenu.MailAction action = MailboxMenu.MailAction.PICK_UP;
            if (class_437.method_25442()) {
                action = class_437.method_25441() ? MailboxMenu.MailAction.MOVE_ALL_TO_INVENTORY : MailboxMenu.MailAction.MOVE_TO_INVENTORY;
            }
            if (((MailboxMenu)this.method_17577()).doMailAction((class_1657)Minecrft.player(), index, action)) {
                Minecrft.player().method_5783((class_3414)class_3417.field_14883.comp_349(), 1.0f, 1.0f);
                Packets.sendToServer(new MailboxMenuInboxActionC2SP(index, action));
            }
        }
        if (this.canScroll()) {
            if (this.isMouseOver(this.scrollThumb, mouseX, mouseY)) {
                this.method_25398(true);
                this.isDraggingScrollbar = true;
                this.dragDelta = 0.0;
                this.scrollAtDragStart = this.scroll;
                return true;
            }
            if (this.isMouseOver(this.scrollBarArea, mouseX, mouseY)) {
                int direction = mouseY < (double)this.scrollThumb.method_3322() ? -1 : 1;
                this.scroll(8 * direction);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isDraggingScrollbar || button != 0) {
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        this.dragDelta += dragY;
        double threshold = (double)this.scrollBarArea.method_3320() / (double)Math.max(((MailboxMenu)this.method_17577()).getMail().size(), 1);
        int amount = (int)(this.dragDelta / threshold);
        if (amount != 0 || this.scroll != this.scrollAtDragStart) {
            this.scrollTo(this.scrollAtDragStart + amount);
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isMouseOver(this.mailArea, mouseX, mouseY) || this.isMouseOver(this.scrollBarArea, mouseX, mouseY)) {
            this.scroll((int)(-scrollY));
            return true;
        }
        return false;
    }

    protected class_8666 getDisplayedIcon(class_1799 mail) {
        if (Mail.isReturned(mail)) {
            return ICON_RETURNED_SPRITES;
        }
        Address sender = Mail.getSenderOrUnknown(mail);
        if (sender.equals(Address.UNKNOWN)) {
            return ICON_ADDRESS_UNKNOWN_SPRITES;
        }
        if (sender.equals(Address.MAIL_SERVICE)) {
            return ICON_ADDRESS_MAIL_SERVICE_SPRITES;
        }
        return switch (sender.type()) {
            default -> throw new MatchException(null, null);
            case Address.Type.BLOCK -> ICON_ADDRESS_BLOCK_SPRITES;
            case Address.Type.PLAYER -> ICON_ADDRESS_PLAYER_SPRITES;
            case Address.Type.ENTITY -> ICON_ADDRESS_ENTITY_SPRITES;
        };
    }

    protected class_2561 getDisplayedIconName(class_1799 mail) {
        if (Mail.isReturned(mail)) {
            return class_2561.method_43471((String)"gui.envelope.mail.returned");
        }
        Address sender = Mail.getSenderOrUnknown(mail);
        if (sender.equals(Address.UNKNOWN)) {
            return class_2561.method_43471((String)"address.envelope.unknown");
        }
        if (sender.equals(Address.MAIL_SERVICE)) {
            return class_2561.method_43471((String)"address.envelope.mail_service");
        }
        return switch (sender.type()) {
            default -> throw new MatchException(null, null);
            case Address.Type.BLOCK -> class_2561.method_43471((String)"address.envelope.type.block");
            case Address.Type.PLAYER -> class_2561.method_43471((String)"address.envelope.type.player");
            case Address.Type.ENTITY -> class_2561.method_43471((String)"address.envelope.type.entity");
        };
    }

    protected Address getDisplayedSender(class_1799 mail) {
        return Mail.getSenderOrUnknown(mail);
    }

    protected boolean isMouseOver(class_768 rect, double mouseX, double mouseY) {
        return mouseX >= (double)rect.method_3321() && mouseX < (double)(rect.method_3321() + rect.method_3319()) && mouseY >= (double)rect.method_3322() && mouseY < (double)(rect.method_3322() + rect.method_3320());
    }
}

