/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.widget;

import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressFormatter;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class AddressBoxSuggestions
extends class_339 {
    protected final class_327 font;
    protected final class_342 editBox;
    protected final AllAddresses addresses;
    protected final List<Suggestion> suggestions;
    protected int maxDisplayedLines;
    protected int selectedIndex;
    protected int scroll;
    protected boolean show;

    public AddressBoxSuggestions(class_342 addressBox, AllAddresses addresses, int maxDisplayedLines) {
        super(addressBox.method_46426(), addressBox.method_46427() + addressBox.method_25364() + 3, addressBox.method_25368(), 1, (class_2561)class_2561.method_43473());
        this.font = Minecrft.get().field_1772;
        this.suggestions = new ArrayList<Suggestion>();
        this.selectedIndex = 0;
        this.scroll = 0;
        this.editBox = addressBox;
        this.addresses = addresses;
        this.maxDisplayedLines = maxDisplayedLines;
    }

    public void update() {
        this.suggestions.clear();
        this.selectedIndex = 0;
        this.setScroll(0);
        this.editBox.method_1887(null);
        String text = this.editBox.method_1882();
        if (!this.addresses.isKnown(text)) {
            this.suggestions.addAll(((Suggestions)class_2172.method_9264(this.addresses.stream().map(Address::toString), (SuggestionsBuilder)new SuggestionsBuilder(text, 0)).join()).getList());
            this.show = !text.isEmpty();
        }
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.show) {
            return;
        }
        int lineHeight = 11;
        this.method_53533(lineHeight * Math.min(this.maxDisplayedLines, this.suggestions.size()));
        int y = this.method_46427();
        int hoveredIndex = this.getHoveredSuggestionIndex(mouseX, mouseY);
        for (int i = this.scroll; i < Math.min(this.maxDisplayedLines + this.scroll, this.suggestions.size()); ++i) {
            Object text;
            Suggestion suggestion = this.suggestions.get(i);
            boolean selected = i == this.selectedIndex;
            int textColor = selected ? -1198776 : -1;
            int fillColor = selected ? -805306368 : -804187887;
            guiGraphics.method_25294(this.method_46426() - 13, y, this.method_46426() + this.method_25368(), y + lineHeight, fillColor);
            String icon = this.addresses.byName(suggestion.getText()).map(AddressFormatter::getIcon).orElse("");
            if (!icon.isBlank()) {
                int iconColor = selected ? textColor : -5592406;
                guiGraphics.method_51433(this.font, icon, this.method_46426() - 9, y + 1, iconColor, true);
            }
            if (this.font.method_1727((String)(text = suggestion.getText())) > this.method_25368()) {
                String ellipsis = "...";
                text = this.font.method_27523(suggestion.getText(), this.method_25368() - this.font.method_1727(ellipsis)) + ellipsis;
                if (hoveredIndex == i) {
                    guiGraphics.method_51438(this.font, (class_2561)class_2561.method_43470((String)suggestion.getText()), mouseX, mouseY);
                }
            }
            guiGraphics.method_51433(this.font, (String)text, this.method_46426(), y + 1, textColor, true);
            y += lineHeight;
        }
        this.renderScrollBar(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void renderScrollBar(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.suggestions.isEmpty() && this.suggestions.size() > this.maxDisplayedLines) {
            int trackHeight = this.method_25364() - 2;
            int maxScroll = this.suggestions.size() - this.maxDisplayedLines;
            int thumbHeight = trackHeight * this.maxDisplayedLines / this.suggestions.size();
            float scrollRatio = maxScroll != 0 ? (float)this.scroll / (float)maxScroll : 0.0f;
            int thumbY = (int)((float)(trackHeight - thumbHeight) * scrollRatio);
            guiGraphics.method_25294(this.method_46426() + this.method_25368(), this.method_46427(), this.method_46426() + this.method_25368() + 3, this.method_46427() + this.method_25364(), -804187887);
            guiGraphics.method_25294(this.method_46426() + this.method_25368() + 1, this.method_46427() + thumbY + 1, this.method_46426() + this.method_25368() + 2, this.method_46427() + thumbY + thumbHeight + 1, -5592406);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341) {
            this.show = !this.show;
            return true;
        }
        if (!this.show) {
            return false;
        }
        if (keyCode == 265) {
            this.select(this.selectedIndex - 1);
            return true;
        }
        if (keyCode == 264) {
            this.select(this.selectedIndex + 1);
            return true;
        }
        if (keyCode == 258) {
            this.getSelected().ifPresent(suggestion -> this.editBox.method_1852(suggestion.getText()));
            Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            return true;
        }
        return false;
    }

    public void method_16014(double mouseX, double mouseY) {
        if (!this.show) {
            return;
        }
        int hoveredSuggestion = this.getHoveredSuggestionIndex(mouseX, mouseY);
        if (hoveredSuggestion >= 0 && this.selectedIndex != hoveredSuggestion) {
            this.select(hoveredSuggestion);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.show) {
            return false;
        }
        if (this.method_37303() && this.method_25367()) {
            this.setScroll(this.scroll - class_3532.method_17822((double)scrollY));
            return true;
        }
        return false;
    }

    public void scrollTo(int index) {
        int currentStart = this.scroll;
        int currentEnd = this.scroll + this.maxDisplayedLines - 1;
        if (index < currentStart) {
            this.setScroll(index);
        } else if (index > currentEnd) {
            this.setScroll(index - this.maxDisplayedLines + 1);
        } else {
            this.setScroll(this.scroll);
        }
    }

    public void setScroll(int value) {
        this.scroll = class_3532.method_15340((int)value, (int)0, (int)Math.max(0, this.suggestions.size() - this.maxDisplayedLines));
    }

    public void select(int index) {
        if (index < 0) {
            index = this.suggestions.size() - 1;
        } else if (index >= this.suggestions.size()) {
            index = 0;
        }
        this.selectedIndex = class_3532.method_15340((int)index, (int)0, (int)(this.suggestions.size() - 1));
        this.scrollTo(this.selectedIndex);
        this.getSelected().ifPresent(suggestion -> {
            String suffix = this.calculateSuggestionSuffix(this.editBox.method_1882(), suggestion.getText());
            this.editBox.method_1887(suffix);
        });
    }

    @Nullable
    protected String calculateSuggestionSuffix(String inputText, String suggestionText) {
        return suggestionText.startsWith(inputText) ? suggestionText.substring(inputText.length()) : null;
    }

    public Optional<Suggestion> getSelected() {
        if (this.selectedIndex < 0 || this.selectedIndex >= this.suggestions.size()) {
            return Optional.empty();
        }
        return Optional.of(this.suggestions.get(this.selectedIndex));
    }

    public void method_25348(double mouseX, double mouseY) {
        if (!this.show) {
            return;
        }
        int hoveredSuggestion = this.getHoveredSuggestionIndex(mouseX, mouseY);
        if (hoveredSuggestion >= 0 && hoveredSuggestion < this.suggestions.size()) {
            this.editBox.method_1852(this.suggestions.get(hoveredSuggestion).getText());
        }
    }

    public int getHoveredSuggestionIndex(double mouseX, double mouseY) {
        if (this.suggestions.isEmpty() || mouseX < (double)this.method_46426() || mouseX >= (double)(this.method_46426() + this.method_25368()) || mouseY < (double)this.method_46427() || mouseY >= (double)(this.method_46427() + 11 * Math.min(this.maxDisplayedLines, this.suggestions.size()))) {
            return -1;
        }
        int y = (int)(mouseY - (double)this.method_46427());
        return class_3532.method_15340((int)(y / 11 + this.scroll), (int)this.scroll, (int)(this.suggestions.size() - 1));
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

