/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.model;

import com.google.common.collect.ImmutableList;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.util.EasingFunction;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import net.minecraft.class_3532;
import net.minecraft.class_4592;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PigeonModel
extends class_4592<Pigeon> {
    private final class_630 root;
    private final class_630 head;
    private final class_630 beak;
    private final class_630 hat;
    private final class_630 body;
    private final class_630 backpackStraps;
    private final class_630 backpackBag;
    private final class_630 leftLeg;
    private final class_630 rightLeg;
    private final class_630 tail;
    private final class_630 leftWing;
    private final class_630 rightWing;

    public PigeonModel(class_630 root) {
        super(true, 6.7f, 0.0f, 1.75f, 2.1f, 26.400002f);
        this.root = root;
        this.head = root.method_32086("head");
        this.beak = this.head.method_32086("beak");
        this.hat = this.head.method_32086("hat");
        this.body = root.method_32086("body");
        this.backpackStraps = this.body.method_32086("backpack_straps");
        this.backpackBag = this.body.method_32086("backpack_bag");
        this.leftLeg = root.method_32086("left_leg");
        this.rightLeg = root.method_32086("right_leg");
        this.tail = root.method_32086("tail");
        this.leftWing = root.method_32086("left_wing");
        this.rightWing = root.method_32086("right_wing");
    }

    public static class_5607 createLayerDefinition() {
        class_5609 mesh = new class_5609();
        class_5610 part = mesh.method_32111();
        class_5610 head = part.method_32117("head", class_5606.method_32108().method_32101(0, 14).method_32098(-3.0f, -4.0f, -5.0f, 6.0f, 6.0f, 6.0f, class_5605.field_27715), class_5603.method_32090((float)0.0f, (float)16.0f, (float)-1.0f));
        class_5610 beak = head.method_32117("beak", class_5606.method_32108().method_32101(0, 14).method_32098(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 1.0f, new class_5605(0.01f)).method_32101(0, 16).method_32098(0.0f, 0.0f, -2.0f, 0.0f, 1.0f, 1.0f, class_5605.field_27715), class_5603.method_32090((float)0.0f, (float)-1.0f, (float)-5.0f));
        class_5610 hat = head.method_32117("hat", class_5606.method_32108().method_32101(1, 46).method_32098(-3.5f, -2.0f, -3.5f, 7.0f, 2.0f, 7.0f, class_5605.field_27715).method_32101(0, 55).method_32098(-3.5f, 0.0f, -4.5f, 7.0f, 1.0f, 8.0f, class_5605.field_27715), class_5603.method_32091((float)0.0f, (float)-4.0f, (float)-2.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        class_5610 body = part.method_32117("body", class_5606.method_32108().method_32101(0, 0).method_32098(-4.0f, -8.0f, -4.0f, 8.0f, 6.0f, 8.0f, class_5605.field_27715), class_5603.method_32090((float)0.0f, (float)24.05f, (float)0.0f));
        class_5610 backpackStraps = body.method_32117("backpack_straps", class_5606.method_32108().method_32101(32, 50).method_32098(-4.0f, -3.0f, -4.0f, 8.0f, 6.0f, 8.0f, new class_5605(0.0f, 0.01f, 0.01f)), class_5603.method_32090((float)0.0f, (float)-5.0f, (float)0.0f));
        class_5610 backpackBag = body.method_32117("backpack_bag", class_5606.method_32108().method_32101(32, 38).method_32098(-5.0f, -3.0f, -3.0f, 10.0f, 6.0f, 6.0f, class_5605.field_27715), class_5603.method_32091((float)0.0f, (float)-9.0f, (float)2.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        class_5610 leftLeg = part.method_32117("left_leg", class_5606.method_32108().method_32101(9, 26).method_32098(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, class_5605.field_27715).method_32101(6, 28).method_32098(-1.0f, 2.0f, -3.0f, 3.0f, 0.0f, 3.0f, class_5605.field_27715), class_5603.method_32090((float)1.0f, (float)22.0f, (float)1.0f));
        class_5610 rightLeg = part.method_32117("right_leg", class_5606.method_32108().method_32101(7, 26).method_32098(-1.0f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, class_5605.field_27715).method_32101(0, 28).method_32098(-2.0f, 2.0f, -3.0f, 3.0f, 0.0f, 3.0f, class_5605.field_27715), class_5603.method_32090((float)-1.0f, (float)22.0f, (float)1.0f));
        class_5610 tail = part.method_32117("tail", class_5606.method_32108().method_32101(24, 0).method_32098(-3.0f, 0.0f, -1.0f, 6.0f, 5.0f, 1.0f, class_5605.field_27715), class_5603.method_32091((float)0.0f, (float)19.0f, (float)4.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        class_5610 leftWing = part.method_32117("left_wing", class_5606.method_32108().method_32101(46, 3).method_32096().method_32098(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f, class_5605.field_27715).method_32106(false), class_5603.method_32091((float)4.0f, (float)17.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        class_5610 rightWing = part.method_32117("right_wing", class_5606.method_32108().method_32101(32, 3).method_32098(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f, class_5605.field_27715), class_5603.method_32091((float)-4.0f, (float)17.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        return class_5607.method_32110((class_5609)mesh, (int)64, (int)64);
    }

    public void setupAnim(Pigeon pigeon, float limbSwing, float limbSwingAmount, float bob, float netHeadYaw, float headPitch) {
        this.root.method_32088().forEach(class_630::method_41923);
        this.head.field_3654 = headPitch * ((float)Math.PI / 180);
        this.head.field_3675 = netHeadYaw * ((float)Math.PI / 180);
        switch (this.getState(pigeon).ordinal()) {
            case 0: {
                this.leftWing.field_3674 = -bob;
                this.rightWing.field_3674 = bob;
                this.leftLeg.field_3654 = 0.75f * limbSwingAmount;
                this.leftLeg.field_3675 = -0.15f;
                this.rightLeg.field_3654 = 0.75f * limbSwingAmount;
                this.rightLeg.field_3675 = 0.15f;
                float anim = ((float)pigeon.field_6012 + Minecrft.get().method_60646().method_60637(true)) % 60.0f / 60.0f;
                anim *= 2.0f;
                if (anim > 1.0f) {
                    anim = 2.0f - anim;
                }
                anim = (float)EasingFunction.EASE_IN_OUT_QUAD.ease(anim);
                this.body.field_3654 = anim * 0.1f;
                this.head.field_3654 = -anim * 0.05f;
                this.head.field_3655 -= 0.75f * anim;
                this.leftWing.field_3654 += anim * 0.2f;
                this.leftWing.field_3656 -= 0.35f * anim;
                this.leftWing.field_3655 -= 0.5f * anim;
                this.rightWing.field_3654 += anim * 0.2f;
                this.rightWing.field_3656 -= 0.35f * anim;
                this.rightWing.field_3655 -= 0.5f * anim;
                this.tail.field_3654 += limbSwingAmount * 0.75f + anim * 0.1f;
                this.tail.field_3656 -= 0.35f * anim;
                this.tail.field_3655 -= 0.5f * anim;
                break;
            }
            case 1: {
                this.leftWing.field_3674 = -0.3927f;
                this.rightWing.field_3674 = 0.3927f;
                this.leftLeg.field_3654 = class_3532.method_15362((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
                this.rightLeg.field_3654 = class_3532.method_15362((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
                break;
            }
            case 2: {
                this.body.field_3656 += 1.9f;
                this.head.field_3656 = this.head.field_3656 + (pigeon.method_6109() ? 1.9f : 2.9f);
                this.leftWing.field_3674 = -0.2f;
                this.rightWing.field_3674 = 0.2f;
                this.leftWing.field_3656 += 2.0f;
                this.rightWing.field_3656 += 2.0f;
                this.tail.field_3654 = 0.75f;
            }
        }
    }

    public State getState(@Nullable Pigeon pigeon) {
        if (pigeon == null) {
            return State.STANDING;
        }
        if (pigeon.isSitting()) {
            return State.SITTING;
        }
        return pigeon.method_6581() ? State.FLYING : State.STANDING;
    }

    @NotNull
    protected Iterable<class_630> method_22946() {
        return ImmutableList.of((Object)this.head);
    }

    @NotNull
    protected Iterable<class_630> method_22948() {
        return ImmutableList.of((Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.rightWing, (Object)this.leftWing, (Object)this.tail);
    }

    public static enum State {
        FLYING,
        STANDING,
        SITTING;

    }
}

