/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.state;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.PlatformHelper;
import io.github.mortuusars.envelope.client.state.FillRecipientState;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class ClientStateManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path FILE_PATH = PlatformHelper.getConfigDirectory().resolve("envelope/fill_recipient.json");
    private static FillRecipientState data;

    public static void load() {
        if (Files.exists(FILE_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(FILE_PATH);){
                data = (FillRecipientState)GSON.fromJson((Reader)reader, FillRecipientState.class);
            }
            catch (IOException e) {
                Envelope.LOGGER.error("Cannot load fill recipient state from '{}': {}", (Object)FILE_PATH, (Object)e.toString());
                data = new FillRecipientState();
            }
        } else {
            data = new FillRecipientState();
        }
    }

    public static void save() {
        try {
            Files.createDirectories(FILE_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(FILE_PATH, new OpenOption[0]);){
                GSON.toJson((Object)data, (Appendable)writer);
            }
        }
        catch (IOException e) {
            Envelope.LOGGER.error("Cannot save fill recipient state to '{}': {}", (Object)FILE_PATH, (Object)e.toString());
        }
    }

    public static FillRecipientState getFillRecipientState() {
        if (data == null) {
            ClientStateManager.load();
        }
        return data;
    }
}

