/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.serialization.DynamicOps;
import io.github.mortuusars.envelope.command.EnvelopeDebugCommand;
import io.github.mortuusars.envelope.command.argument.AddressArgument;
import io.github.mortuusars.envelope.command.suggestion.AddressSuggestions;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2287;
import net.minecraft.class_2290;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class EnvelopeCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"envelope").requires(stack -> stack.method_9259(2))).then(class_2170.method_9247((String)"send").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"mail", (ArgumentType)class_2287.method_9776((class_7157)context)).executes(c -> EnvelopeCommand.sendMail((CommandContext<class_2168>)c, class_2287.method_9777((CommandContext)c, (String)"mail"), Address.UNKNOWN))).then(class_2170.method_9244((String)"sender", (ArgumentType)class_2179.method_9284()).executes(c -> EnvelopeCommand.sendMail((CommandContext<class_2168>)c, class_2287.method_9777((CommandContext)c, (String)"mail"), EnvelopeCommand.parseAddress(class_2179.method_9285((CommandContext)c, (String)"sender")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"mailbox").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(EnvelopeCommand::listAllMailboxes)).then(class_2170.method_9247((String)"default").executes(EnvelopeCommand::listDefaultMailboxes)))).then(class_2170.method_9247((String)"position").then(class_2170.method_9244((String)"address", (ArgumentType)AddressArgument.block()).suggests((SuggestionProvider)AddressSuggestions.block()).executes(c -> EnvelopeCommand.mailboxPosition((CommandContext<class_2168>)c, AddressArgument.getBlock((CommandContext<class_2168>)c, "address"))))))).then(EnvelopeDebugCommand.commands()));
    }

    private static int sendMail(CommandContext<class_2168> context, class_2290 item, Address sender) throws CommandSyntaxException {
        class_3218 level = ((class_2168)context.getSource()).method_9225();
        class_1799 mail = item.method_9781(1, false);
        Address recipient = Mail.getRecipientOrUnknown(mail);
        if (recipient.equals(Address.UNKNOWN)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Cannot send: recipient is not defined."));
            return 0;
        }
        MailService.of(level).getDeliveryManager().startService(Delivery.draft().deliver(mail).from(sender).to(recipient)).ifPresentOrElse(delivery -> {
            class_5250 message = class_2561.method_43470((String)"Mail sent to ").method_10852((class_2561)delivery.delivery().getRecipient().format().asRecipient().toComponent());
            ((class_2168)context.getSource()).method_9226(() -> EnvelopeCommand.lambda$sendMail$4((class_2561)message), true);
        }, error -> ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Cannot send: ").method_10852((class_2561)error.getTranslation())));
        return 0;
    }

    private static Address parseAddress(class_2487 tag) {
        return (Address)Address.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag).getOrThrow();
    }

    private static int listAllMailboxes(CommandContext<class_2168> context) {
        class_3218 level = ((class_2168)context.getSource()).method_9225();
        Set<Address.Block> addresses = MailService.of(level).getMailboxes().getAllAddresses();
        if (!addresses.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"All mailboxes:"), true);
            for (Address.Block address : addresses) {
                ((class_2168)context.getSource()).method_9226(() -> EnvelopeCommand.copyableAddressAndPos(address, MailService.of(level).getMailboxes().getPositionOf(address)), true);
            }
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"There are no known mailboxes."), true);
        }
        return 0;
    }

    private static int listDefaultMailboxes(CommandContext<class_2168> context) {
        class_3218 level = ((class_2168)context.getSource()).method_9225();
        Map<Address.Player, Address.Block> defaultAddresses = MailService.of(level).getPlayers().getDefaultAddresses();
        if (!defaultAddresses.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Default addresses:"), true);
            defaultAddresses.forEach((playerAddress, address) -> {
                Optional<class_2338> position = MailService.of(level).getMailboxes().getPositionOf((Address.Block)address);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)playerAddress.toString()).method_27693(" - ").method_10852((class_2561)EnvelopeCommand.copyableAddressAndPos(address, position)), true);
            });
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"There are no default mailboxes."), true);
        }
        return 0;
    }

    private static int mailboxPosition(CommandContext<class_2168> context, Address.Block address) {
        class_3218 level = ((class_2168)context.getSource()).method_9225();
        if (!MailService.of(level).getMailboxes().exists(address)) {
            ((class_2168)context.getSource()).method_9213((class_2561)address.getName().method_27693(" does not exist."));
            return 1;
        }
        MailService.of(level).getMailboxes().getPositionOf(address).ifPresentOrElse(pos -> ((class_2168)context.getSource()).method_9226(() -> EnvelopeCommand.copyableAddressAndPos(address, Optional.of(pos)), true), () -> ((class_2168)context.getSource()).method_9213((class_2561)address.getName().method_27693(" does not have a position associated with it.")));
        return 0;
    }

    private static class_5250 copyableAddressAndPos(Address address, Optional<class_2338> pos) {
        String addressId = address.getName().getString();
        String posStr = pos.map(class_2382::method_23854).orElse("");
        String posToCopy = posStr.replace(",", "");
        return address.getName().method_27696(class_2583.field_24360.method_36139(-1651816).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Copy Address").method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)addressId).method_27692(class_124.field_1080)))).method_10958(new class_2558(class_2558.class_2559.field_21462, addressId))).method_10852((class_2561)class_2561.method_43470((String)("@[" + posStr + "]")).method_27696(class_2583.field_24360.method_10977(class_124.field_1068).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Copy Position").method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)posToCopy).method_27692(class_124.field_1080)))).method_10958(new class_2558(class_2558.class_2559.field_21462, posToCopy))));
    }

    private static /* synthetic */ class_2561 lambda$sendMail$4(class_2561 message) {
        return message;
    }
}

