/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.command.argument;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.github.mortuusars.envelope.util.result.Error;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressValidation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class AddressArgument
implements ArgumentType<Address> {
    @Nullable
    private final Address.Type type;

    protected AddressArgument(@Nullable Address.Type type) {
        this.type = type;
    }

    public static AddressArgument all() {
        return new AddressArgument(null);
    }

    public static AddressArgument block() {
        return new AddressArgument(Address.Type.BLOCK);
    }

    public static AddressArgument player() {
        return new AddressArgument(Address.Type.PLAYER);
    }

    public static AddressArgument entity() {
        return new AddressArgument(Address.Type.ENTITY);
    }

    public static Address.Block getBlock(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        Address address = (Address)context.getArgument(name, Address.class);
        if (address instanceof Address.Block) {
            Address.Block block = (Address.Block)address;
            return block;
        }
        class_5250 message = class_2561.method_43470((String)("Address has wrong type: Expected: " + Address.Type.BLOCK.method_15434() + ", Got: " + address.type().method_15434()));
        throw new SimpleCommandExceptionType((Message)message).create();
    }

    public Address parse(StringReader reader) throws CommandSyntaxException {
        String id = reader.readString();
        Optional<Error> error = AddressValidation.id().test(id).getError();
        if (error.isPresent()) {
            class_5250 message = class_2561.method_43470((String)"Invalid address: ").method_10852((class_2561)error.get().getTranslation());
            throw new SimpleCommandExceptionType((Message)message).create();
        }
        Address.Type type = this.type;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"BLOCK", "PLAYER", "ENTITY"}, (Address.Type)type, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> new Address.Block(id);
            case 1 -> new Address.Player(id);
            case 2 -> new Address.Entity(id);
            case -1 -> new Address.Block(id);
        };
    }
}

