/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.command.suggestion;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import org.jetbrains.annotations.Nullable;

public class AddressSuggestions
implements SuggestionProvider<class_2168> {
    @Nullable
    private final Address.Type type;

    protected AddressSuggestions(@Nullable Address.Type type) {
        this.type = type;
    }

    public static AddressSuggestions all() {
        return new AddressSuggestions(null);
    }

    public static AddressSuggestions block() {
        return new AddressSuggestions(Address.Type.BLOCK);
    }

    public static AddressSuggestions player() {
        return new AddressSuggestions(Address.Type.PLAYER);
    }

    public static AddressSuggestions entity() {
        return new AddressSuggestions(Address.Type.ENTITY);
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        MailService mailService = ((class_2168)context.getSource()).method_9225().getEnvelopeMailService();
        Stream<String> addresses = mailService.getKnownAddressesOfType(this.type).stream().map(address -> address.id().indexOf(" ") > 0 ? "\"" + address.id() + "\"" : address.id());
        return class_2172.method_9264(addresses, (SuggestionsBuilder)builder);
    }
}

