/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import io.github.mortuusars.envelope.PlatformHelper;
import io.github.mortuusars.envelope.network.fabric.PacketsImpl;
import io.github.mortuusars.envelope.network.packet.Packet;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Packets {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToServer(Packet packet) {
        PacketsImpl.sendToServer(packet);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToClient(Packet packet, class_3222 player) {
        void var1_1;
        PacketsImpl.sendToClient(packet, (class_3222)var1_1);
    }

    public static void sendToAllClients(Packet packet) {
        MinecraftServer server = Objects.requireNonNull(PlatformHelper.getCurrentServer(), "Cannot send clientbound payloads on the client");
        for (class_3222 player : server.method_3760().method_14571()) {
            Packets.sendToClient(packet, player);
        }
    }

    public static void sendToAllClients(Function<class_5455, Packet> packet) {
        MinecraftServer server = Objects.requireNonNull(PlatformHelper.getCurrentServer(), "Cannot send clientbound payloads on the client");
        for (class_3222 player : server.method_3760().method_14571()) {
            Packets.sendToClient(packet.apply((class_5455)server.method_30611()), player);
        }
    }

    public static void sendToOtherClients(@NotNull class_3222 except, Packet packet) {
        except.field_13995.method_3760().method_14571().forEach(player -> {
            if (!player.equals((Object)except)) {
                Packets.sendToClient(packet, player);
            }
        });
    }

    public static void sendToClients(Packet packet, Predicate<class_3222> filter) {
        MinecraftServer server = Objects.requireNonNull(PlatformHelper.getCurrentServer(), "Cannot send clientbound payloads on the client");
        for (class_3222 player : server.method_3760().method_14571()) {
            if (!filter.test(player)) continue;
            Packets.sendToClient(packet, player);
        }
    }

    public static void sendToPlayersNear(Packet packet, class_3218 level, @Nullable class_3222 excluded, class_1297 entity, double radius) {
        Packets.sendToPlayersNear(packet, level, excluded, entity.method_23317(), entity.method_23318(), entity.method_23321(), radius);
    }

    public static void sendToPlayersNear(Packet packet, @NotNull class_3218 level, @Nullable class_3222 excludedPlayer, double x, double y, double z, double radius) {
        Packets.sendToClients(packet, player -> {
            if (player != excludedPlayer && player.method_37908().method_27983() == level.method_27983()) {
                double d2;
                double d1;
                double d0 = x - player.method_23317();
                return d0 * d0 + (d1 = y - player.method_23318()) * d1 + (d2 = z - player.method_23321()) * d2 < radius * radius;
            }
            return false;
        });
    }
}

