/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.bugger;

import com.google.common.base.Strings;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.util.bugger.page.BuggerPage;
import io.github.mortuusars.envelope.util.bugger.page.DataPage;
import io.github.mortuusars.envelope.util.bugger.page.LogPage;
import io.github.mortuusars.envelope.util.bugger.page.VanillaDebugPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class BuggerDebugScreen {
    private static final List<BuggerPage> pages = new ArrayList<BuggerPage>();
    private static int currentPageIndex;
    private static BuggerPage currentPage;
    private static int zoom;
    private static int scroll;

    public static boolean active() {
        return Bugger.isEnabled() && Minecrft.get().field_1705.method_53531().method_53536();
    }

    public static boolean isOnVanillaDebugPage() {
        return currentPage instanceof VanillaDebugPage;
    }

    public static void addPage(BuggerPage page) {
        pages.add(page);
    }

    public static void prevPage() {
        BuggerDebugScreen.setPage(currentPageIndex - 1);
    }

    public static void nextPage() {
        BuggerDebugScreen.setPage(currentPageIndex + 1);
    }

    public static void setPage(int index) {
        int newPage = class_3532.method_15340((int)index, (int)0, (int)(pages.size() - 1));
        if (currentPageIndex != newPage) {
            currentPage.deactivated();
            currentPageIndex = newPage;
            currentPage = pages.get(currentPageIndex);
            currentPage.activated();
            scroll = 0;
        }
    }

    public static Optional<BuggerPage> getPreviousPage() {
        int page = currentPageIndex - 1;
        return page >= 0 && page < pages.size() ? Optional.of(pages.get(page)) : Optional.empty();
    }

    public static Optional<BuggerPage> getNextPage() {
        int page = currentPageIndex + 1;
        return page >= 0 && page < pages.size() ? Optional.of(pages.get(page)) : Optional.empty();
    }

    public static boolean render(class_332 guiGraphics) {
        if (!BuggerDebugScreen.active()) {
            return false;
        }
        class_310.method_1551().method_16011().method_15396("bugger");
        if (zoom == 0) {
            zoom = (int)Minecrft.get().method_22683().method_4495();
        }
        guiGraphics.method_51741(() -> {
            BuggerDebugScreen.drawPageTabs(guiGraphics);
            float scale = (float)((double)zoom / Minecrft.get().method_22683().method_4495());
            if (!BuggerDebugScreen.isOnVanillaDebugPage()) {
                List<String> leftLines = currentPage.getLeftLines();
                List<String> rightLines = currentPage.getRightLines();
                int correctedScroll = scroll;
                int maxScroll = Math.max(leftLines.size() - 8, 0);
                int effectiveScroll = class_3532.method_15340((int)scroll, (int)0, (int)maxScroll);
                if (!leftLines.isEmpty()) {
                    guiGraphics.method_51448().method_22903();
                    guiGraphics.method_51448().method_22905(scale, scale, scale);
                    correctedScroll = Math.min(scroll, effectiveScroll);
                    leftLines = leftLines.stream().skip(effectiveScroll).toList();
                    BuggerDebugScreen.drawLines(guiGraphics, leftLines, true);
                    guiGraphics.method_51448().method_22909();
                }
                if (!rightLines.isEmpty()) {
                    guiGraphics.method_51448().method_22903();
                    guiGraphics.method_51448().method_46416((float)Minecrft.get().method_22683().method_4486(), 0.0f, 0.0f);
                    guiGraphics.method_51448().method_22905(scale, scale, scale);
                    guiGraphics.method_51448().method_46416((float)(-Minecrft.get().method_22683().method_4486()), 0.0f, 0.0f);
                    maxScroll = Math.max(rightLines.size() - 8, 0);
                    effectiveScroll = class_3532.method_15340((int)scroll, (int)0, (int)maxScroll);
                    correctedScroll = Math.max(correctedScroll, effectiveScroll);
                    rightLines = rightLines.stream().skip(effectiveScroll).toList();
                    BuggerDebugScreen.drawLines(guiGraphics, rightLines, false);
                    guiGraphics.method_51448().method_22909();
                }
                scroll = correctedScroll;
            }
            currentPage.render(guiGraphics, Minecrft.get().method_60646().method_60637(true), scale);
        });
        class_310.method_1551().method_16011().method_15407();
        return !BuggerDebugScreen.isOnVanillaDebugPage();
    }

    private static void drawPageTabs(class_332 guiGraphics) {
        int titleBgColor = -1873784752;
        int sideBgColor = 0x50505050;
        int titleFontColor = -1;
        int sideFontColor = -1118482;
        String prevTitle = BuggerDebugScreen.getPreviousPage().map(buggerPage -> "\u2039 " + buggerPage.getTitle()).orElse("");
        String title = currentPage.getTitle();
        String nextTitle = BuggerDebugScreen.getNextPage().map(buggerPage -> buggerPage.getTitle() + " \u203a").orElse("");
        int titleWidth = class_310.method_1551().field_1772.method_1727(title);
        int titleX = guiGraphics.method_51421() / 2 - titleWidth / 2;
        guiGraphics.method_25294(titleX - 4, 1, titleX + titleWidth + 4, 10, titleBgColor);
        guiGraphics.method_51433(class_310.method_1551().field_1772, title, titleX, 2, titleFontColor, false);
        if (!prevTitle.isEmpty()) {
            int prevWidth = class_310.method_1551().field_1772.method_1727(prevTitle);
            int prevX = titleX - prevWidth - 7;
            guiGraphics.method_25294(prevX - 1, 1, prevX + prevWidth + 1, 10, sideBgColor);
            guiGraphics.method_51433(class_310.method_1551().field_1772, prevTitle, prevX, 2, sideFontColor, false);
        }
        if (!nextTitle.isEmpty()) {
            int nextWidth = class_310.method_1551().field_1772.method_1727(nextTitle);
            int nextX = titleX + titleWidth + 7;
            guiGraphics.method_25294(nextX - 1, 1, nextX + nextWidth + 1, 10, sideBgColor);
            guiGraphics.method_51433(class_310.method_1551().field_1772, nextTitle, nextX, 2, sideFontColor, false);
        }
    }

    private static void drawLines(class_332 guiGraphics, List<String> lines, boolean leftSide) {
        class_327 font = Minecrft.get().field_1772;
        int y = 2;
        for (String line : lines) {
            if (Strings.isNullOrEmpty((String)line)) {
                Objects.requireNonNull(font);
                y += 9;
                continue;
            }
            boolean splitted = false;
            for (class_5481 chars : font.method_1728(class_5348.method_29430((String)line), Minecrft.get().method_22683().method_4489() / zoom - 4)) {
                int x;
                int lineWidth = font.method_30880(chars);
                int n = x = leftSide ? 2 : guiGraphics.method_51421() - 2 - lineWidth;
                if (splitted) {
                    x += 4;
                }
                Objects.requireNonNull(font);
                guiGraphics.method_25294(x - 1, y - 1, x + lineWidth + 1, y + 9 - 1, -1873784752);
                guiGraphics.method_51430(font, chars, x, y, -2039584, false);
                Objects.requireNonNull(font);
                y += 9;
                splitted = true;
            }
        }
    }

    public static boolean onMousePress(int button, int action, int modifiers) {
        if (!BuggerDebugScreen.active()) {
            return false;
        }
        if (class_310.method_1551().field_1755 != null) {
            return false;
        }
        if (button == 2 && class_437.method_25442()) {
            scroll = 0;
            return true;
        }
        if (button == 2 && class_437.method_25441()) {
            zoom = (int)Minecrft.get().method_22683().method_4495();
            return true;
        }
        return currentPage.onMousePress(button, action, modifiers);
    }

    public static boolean onMouseScroll(double amount) {
        if (!BuggerDebugScreen.active()) {
            return false;
        }
        if (class_310.method_1551().field_1755 != null) {
            return false;
        }
        if (class_437.method_25442()) {
            scroll = Math.max(scroll - (int)amount * 3, 0);
            return true;
        }
        if (class_437.method_25441()) {
            if (amount > 0.0) {
                BuggerDebugScreen.zoomIn();
            } else {
                BuggerDebugScreen.zoomOut();
            }
            return true;
        }
        return currentPage.onMouseScroll(amount);
    }

    private static void zoomIn() {
        zoom = class_3532.method_15340((int)(zoom + 1), (int)1, (int)8);
    }

    private static void zoomOut() {
        zoom = class_3532.method_15340((int)(zoom - 1), (int)1, (int)8);
    }

    public static boolean onKeyAction(int action, int key, int scanCode, int modifiers) {
        if (!BuggerDebugScreen.active()) {
            return false;
        }
        if (class_310.method_1551().field_1755 != null) {
            return false;
        }
        return action == 1 && BuggerDebugScreen.onKeyPress(key, scanCode, modifiers) || action == 2 && BuggerDebugScreen.onKeyRepeat(key, scanCode, modifiers) || action == 0 && BuggerDebugScreen.onKeyRelease(key, scanCode, modifiers);
    }

    public static boolean onKeyPress(int key, int scanCode, int modifiers) {
        if (currentPage.onKeyPress(key, scanCode, modifiers)) {
            return true;
        }
        if (key == 263) {
            BuggerDebugScreen.prevPage();
            return true;
        }
        if (key == 262) {
            BuggerDebugScreen.nextPage();
            return true;
        }
        if (key == 264) {
            scroll = Math.max(scroll + 3, 0);
            return true;
        }
        if (key == 265) {
            scroll = Math.max(scroll - 3, 0);
            return true;
        }
        if (key == 268) {
            scroll = 0;
            return true;
        }
        if (key == 269) {
            scroll = Integer.MAX_VALUE;
            return true;
        }
        if (key == 260 && class_437.method_25441()) {
            BuggerDebugScreen.test();
            return true;
        }
        if ((key == 334 || key == 61) && class_437.method_25441()) {
            BuggerDebugScreen.zoomIn();
            return true;
        }
        if ((key == 333 || key == 45) && class_437.method_25441()) {
            BuggerDebugScreen.zoomOut();
            return true;
        }
        return false;
    }

    public static boolean onKeyRepeat(int key, int scanCode, int modifiers) {
        if (currentPage.onKeyRepeat(key, scanCode, modifiers)) {
            return true;
        }
        if (key == 263) {
            BuggerDebugScreen.prevPage();
            return true;
        }
        if (key == 262) {
            BuggerDebugScreen.nextPage();
            return true;
        }
        if (key == 264) {
            scroll = Math.max(scroll + 3, 0);
            return true;
        }
        if (key == 265) {
            scroll = Math.max(scroll - 3, 0);
            return true;
        }
        if ((key == 334 || key == 61) && class_437.method_25441()) {
            BuggerDebugScreen.zoomIn();
            return true;
        }
        if ((key == 333 || key == 45) && class_437.method_25441()) {
            BuggerDebugScreen.zoomOut();
            return true;
        }
        return false;
    }

    public static boolean onKeyRelease(int key, int scanCode, int modifiers) {
        return currentPage.onKeyRelease(key, scanCode, modifiers);
    }

    private static void test() {
        boolean a = true;
    }

    static {
        zoom = 0;
        pages.add(new LogPage());
        pages.add(new VanillaDebugPage());
        pages.add(new DataPage());
        currentPageIndex = 1;
        currentPage = pages.get(1);
        currentPage.activated();
    }
}

