/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.bugger.data;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.util.bugger.BuggerData;
import java.util.Optional;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Data<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_2960 id;
    private final Codec<T> codec;

    public Data(class_2960 id, Codec<T> codec) {
        @Nullable Data<?> definition = BuggerData.DEFINITIONS.get(id);
        Preconditions.checkArgument((definition == null || definition.codec().equals(codec) ? 1 : 0) != 0, (Object)("Duplicate definition detected: '" + String.valueOf(id) + "'."));
        BuggerData.DEFINITIONS.put(id, this);
        this.id = id;
        this.codec = codec;
    }

    public class_2960 id() {
        return this.id;
    }

    public Codec<T> codec() {
        return this.codec;
    }

    public Optional<T> get() {
        return BuggerData.get(this.id);
    }

    public void send(@Nullable T value) {
        if (!Bugger.isEnabled()) {
            return;
        }
        BuggerData.send(this.id, registryAccess -> this.encode(value, (class_5455)registryAccess));
    }

    public T apply(T oldValue, T newValue) {
        return newValue;
    }

    public void handle(T value) {
    }

    @Nullable
    public class_2520 encode(@Nullable T value, class_5455 registryAccess) {
        if (value == null) {
            return null;
        }
        return this.codec().encodeStart((DynamicOps)registryAccess.method_57093((DynamicOps)class_2509.field_11560), value).ifError(e -> LOGGER.error("Cannot encode '{}' bugger data: '{}'. Value: '{}'", new Object[]{this.id, e.message(), value})).result().orElse(null);
    }

    @Nullable
    public T decode(class_2520 tag, class_5455 registryAccess) {
        return this.codec().decode((DynamicOps)registryAccess.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).ifError(e -> LOGGER.error("Cannot decode '{}' bugger data: '{}'. Tag: '{}'", new Object[]{this.id, e.message(), tag})).result().map(Pair::getFirst).orElse(null);
    }
}

