/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.bugger.test.cases;

import com.mojang.serialization.DataResult;
import io.github.mortuusars.envelope.util.bugger.test.BuggerTests;
import io.github.mortuusars.envelope.util.bugger.test.Test;
import io.github.mortuusars.envelope.world.delivery.CourierOrigin;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.DeliveryHandler;
import io.github.mortuusars.envelope.world.delivery.phase.DeliveryPhase;
import io.github.mortuusars.envelope.world.delivery.route.DeliveryRoute;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class DeliveryHandlerTests
extends BuggerTests {
    private final MinecraftServer server;

    public DeliveryHandlerTests(MinecraftServer server) {
        this.server = server;
        this.add(new Test("tickDelivery_callsCallbacksProperly", this::testCallbacks));
    }

    private DataResult<Boolean> testCallbacks() {
        TestDeliveryHandler handler = new TestDeliveryHandler();
        Delivery delivery = new Delivery(Id.createUnsafe(0L), Optional.empty(), Address.UNKNOWN, Address.UNKNOWN, class_1799.field_8037, DeliveryRoute.EMPTY, DeliveryPhase.STARTED, 0, false);
        while (!delivery.isEnded()) {
            handler.tickDelivery(this.server.method_30002(), delivery);
        }
        for (Map.Entry<DeliveryPhase, BitSet> check : handler.checks.entrySet()) {
            BitSet set = check.getValue();
            if (!set.get(0)) {
                return DataResult.error(() -> String.valueOf(check.getKey()) + " - not called phaseStarted");
            }
            if (!set.get(1)) {
                return DataResult.error(() -> String.valueOf(check.getKey()) + " - not called phaseTicked");
            }
            if (set.get(2)) continue;
            return DataResult.error(() -> String.valueOf(check.getKey()) + " - not called phaseCompleted");
        }
        if (!handler.endedCorrectly) {
            return DataResult.error(() -> "endDelivery was not called properly.");
        }
        return DataResult.success((Object)true);
    }

    private static class TestDeliveryHandler
    implements DeliveryHandler {
        public final Map<DeliveryPhase, BitSet> checks = (Map)class_156.method_654(new HashMap(), map -> {
            for (DeliveryPhase phase : DeliveryPhase.values()) {
                map.put(phase, new BitSet());
            }
        });
        public boolean endedCorrectly;

        private TestDeliveryHandler() {
        }

        @Override
        public void endDelivery(class_3218 level, Delivery delivery) {
            if (delivery.getPhase() == DeliveryPhase.FINISHED) {
                this.endedCorrectly = true;
            }
        }

        @Override
        public CourierOrigin getOrigin() {
            return CourierOrigin.service();
        }

        @Override
        public boolean handlePhaseTransition(class_3218 level, Delivery delivery) {
            delivery.setPhaseAndResetProgress(delivery.getPhase().next());
            return true;
        }

        @Override
        public int getPhaseDuration(class_3218 level, Delivery delivery, DeliveryPhase phase) {
            return DeliveryHandler.super.getPhaseDuration(level, delivery, phase) - 1;
        }

        @Override
        public void phaseStarted(class_3218 level, Delivery delivery) {
            this.checks.get((Object)delivery.getPhase()).set(0);
        }

        @Override
        public void phaseTicked(class_3218 level, Delivery delivery) {
            this.checks.get((Object)delivery.getPhase()).set(1);
        }

        @Override
        public void phaseCompleted(class_3218 level, Delivery delivery) {
            this.checks.get((Object)delivery.getPhase()).set(2);
        }
    }
}

