/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.bugger.test.cases;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.util.bugger.test.BuggerTests;
import io.github.mortuusars.envelope.util.bugger.test.Test;
import io.github.mortuusars.envelope.world.inventory.RequestedItem;
import io.github.mortuusars.envelope.world.mail.address.Address;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3489;
import net.minecraft.class_3518;
import net.minecraft.class_3902;
import net.minecraft.class_6862;
import net.minecraft.class_9329;
import net.minecraft.server.MinecraftServer;

public class RequestedItemTests
extends BuggerTests {
    private final MinecraftServer server;

    public RequestedItemTests(MinecraftServer server) {
        this.server = server;
        this.itemMatching();
        this.tagMatching();
        this.componentMatching();
        this.matchingItemFromJson();
        this.matchingTagFromJson();
        this.matchingItemWithComponentsFromJson();
    }

    private void itemMatching() {
        RequestedItem requestedItem = new RequestedItem((class_1935)class_1802.field_8153, 3);
        this.add("RequestedItem_simpleMatching", Test.isTrue(() -> requestedItem.matches(new class_1799((class_1935)class_1802.field_8153, 3))));
        this.add("RequestedItem_simpleMatching_failsWhenItemIsDifferent", Test.isFalse(() -> requestedItem.matches(new class_1799((class_1935)class_1802.field_8360, 3))));
        this.add("RequestedItem_simpleMatching_failsWhenCountIsLesser", Test.isFalse(() -> requestedItem.matches(new class_1799((class_1935)class_1802.field_8153, 1))));
        this.add("RequestedItem_simpleMatching_failsWhenMoreThanCount", Test.isFalse(() -> requestedItem.matches(new class_1799((class_1935)class_1802.field_8153, 5))));
        class_1799 stack = new class_1799((class_1935)class_1802.field_8153, 3);
        stack.method_57379(Envelope.DataComponents.LETTER_TATTERED, (Object)class_3902.field_17274);
        stack.method_57379(Envelope.DataComponents.PACKAGE_TIMES_PACKED, (Object)5);
        this.add("RequestedItem_simpleMatching_withRandomComponents", Test.isTrue(() -> requestedItem.matches(stack)));
    }

    private void tagMatching() {
        RequestedItem requestedItem = new RequestedItem((class_6862<class_1792>)class_3489.field_15539, 12);
        this.add("RequestedItem_simpleMatching", Test.isTrue(() -> requestedItem.matches(new class_1799((class_1935)class_1802.field_8583, 12))));
        this.add("RequestedItem_simpleMatching_failsWhenItemIsDifferent", Test.isFalse(() -> requestedItem.matches(new class_1799((class_1935)class_1802.field_8360, 20))));
        this.add("RequestedItem_simpleMatching_failsWhenCountIsLesser", Test.isFalse(() -> requestedItem.matches(new class_1799((class_1935)class_1802.field_8583, 5))));
        this.add("RequestedItem_simpleMatching_failsWhenMoreThanCount", Test.isFalse(() -> requestedItem.matches(new class_1799((class_1935)class_1802.field_8583, 30))));
        class_1799 stack = new class_1799((class_1935)class_1802.field_8583, 12);
        stack.method_57379(Envelope.DataComponents.LETTER_TATTERED, (Object)class_3902.field_17274);
        stack.method_57379(Envelope.DataComponents.PACKAGE_TIMES_PACKED, (Object)5);
        this.add("RequestedItem_simpleMatching_withRandomComponents", Test.isTrue(() -> requestedItem.matches(stack)));
    }

    private void componentMatching() {
        RequestedItem requestedItem = new RequestedItem((class_1935)class_1802.field_8153, 3, class_9329.method_57862().method_57872(Envelope.DataComponents.MAIL_SENDER, (Object)Address.MAIL_SERVICE).method_57872(Envelope.DataComponents.LETTER_TATTERED, (Object)class_3902.field_17274).method_57872(Envelope.DataComponents.PACKAGE_TIMES_PACKED, (Object)5).method_57871());
        class_1799 stack = new class_1799((class_1935)class_1802.field_8153, 3);
        stack.method_57379(Envelope.DataComponents.MAIL_SENDER, (Object)Address.MAIL_SERVICE);
        stack.method_57379(Envelope.DataComponents.LETTER_TATTERED, (Object)class_3902.field_17274);
        stack.method_57379(Envelope.DataComponents.PACKAGE_TIMES_PACKED, (Object)5);
        this.add("RequestedItem_componentMatching", Test.isTrue(() -> requestedItem.matches(stack)));
        class_1799 stack2 = stack.method_7972();
        stack2.method_57381(Envelope.DataComponents.MAIL_SENDER);
        this.add("RequestedItem_componentMatching_failsWhenMissing", Test.isFalse(() -> requestedItem.matches(stack2)));
    }

    private void matchingItemFromJson() {
        this.add("RequestedItem_matchingItemFromJson_simple", Test.isTrue(() -> RequestedItemTests.decodeFromJson("{\"item\":\"minecraft:emerald\"}").matches(new class_1799((class_1935)class_1802.field_8687))));
        this.add("RequestedItem_matchingItemFromJson_failsWhenCountIsLesser", Test.isFalse(() -> RequestedItemTests.decodeFromJson("{\"item\":\"minecraft:emerald\",\"count\":5}").matches(new class_1799((class_1935)class_1802.field_8687))));
    }

    private void matchingItemWithComponentsFromJson() {
        String json = "{\n  \"item\": \"minecraft:emerald\",\n  \"count\": 3,\n  \"components\": {\n    \"envelope:letter_tattered\": {},\n    \"envelope:mail_sender\": {\n        \"type\": \"entity\",\n        \"id\": \"Mail Service\"\n    },\n    \"envelope:mail_recipient\": {\n        \"type\": \"block\",\n        \"id\": \"Mortuusars Laboratory\"\n    }\n  }\n}\n";
        this.add("RequestedItem_matchingItemWithComponentsFromJson_simple", Test.isTrue(() -> {
            class_1799 stack = new class_1799((class_1935)class_1802.field_8687, 3);
            stack.method_57379(Envelope.DataComponents.LETTER_TATTERED, (Object)class_3902.field_17274);
            stack.method_57379(Envelope.DataComponents.MAIL_SENDER, (Object)Address.MAIL_SERVICE);
            stack.method_57379(Envelope.DataComponents.MAIL_RECIPIENT, (Object)new Address.Block("Mortuusars Laboratory"));
            return RequestedItemTests.decodeFromJson(json).matches(stack);
        }));
    }

    private void matchingTagFromJson() {
        this.add("RequestedItem_matchingTagFromJson_simple", Test.isTrue(() -> RequestedItemTests.decodeFromJson("{\"item\":\"#minecraft:planks\"}").matches(new class_1799((class_1935)class_1802.field_8191))));
        this.add("RequestedItem_matchingTagFromJson_failsWhenCountIsLesser", Test.isFalse(() -> RequestedItemTests.decodeFromJson("{\"item\":\"#minecraft:planks\",\"count\":5}").matches(new class_1799((class_1935)class_1802.field_8191))));
    }

    private static RequestedItem decodeFromJson(String json) {
        JsonObject obj = class_3518.method_15285((String)json);
        return (RequestedItem)RequestedItem.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow();
    }
}

