/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.bugger_data;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.util.bugger.data.NbtData;
import io.github.mortuusars.envelope.world.delivery.Courier;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.background.BackgroundCourier;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_5575;
import org.jetbrains.annotations.NotNull;

public class MailServiceBuggerData
extends NbtData {
    public MailServiceBuggerData() {
        super(Envelope.resource("mail_service"));
    }

    public void collectAndSendData(MailService mailService) {
        this.sendValues(tag -> this.writeDebugInfo(mailService, (class_2487)tag));
    }

    private void writeDebugInfo(MailService mailService, class_2487 tag) {
        List pigeons = mailService.getLevel().method_18198(class_5575.method_31795(Pigeon.class), Pigeon::isDelivering);
        List<BackgroundCourier> backgroundCouriers = mailService.getBackgroundDelivery().getCouriers();
        tag.method_10569("mailboxes", mailService.getMailboxes().getAllAddresses().size());
        tag.method_10569("payback_pending_mail", mailService.getPaybackDepartment().getPendingPaybackSubjectCount());
        tag.method_10569("delivering_pigeons", pigeons.size());
        tag.method_10569("background_delivering_pigeons", backgroundCouriers.size());
        tag.method_10569("background_finished_pigeons", mailService.getBackgroundDelivery().getFinishedCouriers().size());
        class_2499 deliveries = Stream.concat(pigeons.stream(), backgroundCouriers.stream()).sorted(Comparator.comparingLong(courier -> courier.getCurrentDelivery().orElseThrow().getId().getTick())).map(courier -> this.formDeliveryString(mailService, (Courier)courier)).map(class_2519::method_23256).collect(Collectors.toCollection(class_2499::new));
        tag.method_10566("deliveries", (class_2520)deliveries);
    }

    @NotNull
    private String formDeliveryString(MailService mailService, Courier courier) {
        Delivery delivery = courier.getCurrentDelivery().orElseThrow();
        int phaseDuration = courier.getDeliveryHandler().getPhaseDuration(mailService.getLevel(), delivery, delivery.getPhase());
        return String.valueOf(class_124.field_1075) + delivery.getSender().format().withIcon().toString() + String.valueOf(class_124.field_1070) + " \uee21 " + String.valueOf(class_124.field_1060) + delivery.getRecipient().format().withIcon().toString() + String.valueOf(class_124.field_1070) + String.valueOf(class_124.field_1080) + " | " + (courier.getOrigin().isService() ? "Service" : "Regular") + " | \u2709 " + (!delivery.getMail().method_7960() ? delivery.getMail().method_7964().getString() : "Empty") + " | \u2194 " + delivery.getRoute().getDistance().map(i -> Integer.toString(i)).orElse("?") + " | \u231a" + delivery.getRoute().getFullTravelDuration().seconds() + "s" + String.valueOf(class_124.field_1070) + " // " + delivery.getPhase().toPrettyString() + String.valueOf(class_124.field_1080) + " \u231b" + (phaseDuration - delivery.getPhaseProgress()) / 20 + String.valueOf(class_124.field_1070);
    }
}

