/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.util.validation;

import io.github.mortuusars.envelope.util.result.Error;
import io.github.mortuusars.envelope.util.result.Result;
import io.github.mortuusars.envelope.util.validation.CachedValidator;
import io.github.mortuusars.envelope.util.validation.Rule;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Validator<T> {
    List<Rule<T>> rules;

    public Validator(List<Rule<T>> rules) {
        this.rules = rules;
    }

    @SafeVarargs
    public static <T> Validator<T> of(Rule<T> ... rules) {
        return new Validator<T>(List.of(rules));
    }

    public Validator<T> and(Rule<T> rule) {
        ArrayList<Rule<T>> rules = new ArrayList<Rule<T>>(this.rules);
        rules.add(rule);
        return new Validator<T>(rules);
    }

    public Validator<T> and(Validator<T> another) {
        ArrayList<Rule<T>> rules = new ArrayList<Rule<T>>(this.rules);
        rules.addAll(another.rules);
        return new Validator<T>(rules);
    }

    public List<Error> testAll(T value) {
        ArrayList<Error> errors = new ArrayList<Error>();
        for (Rule<T> rule : this.rules) {
            rule.test(value).ifPresent(errors::add);
        }
        return errors;
    }

    public Result<T> test(T value) {
        for (Rule<T> rule : this.rules) {
            Optional<Error> test = rule.test(value);
            if (!test.isPresent()) continue;
            return Result.error(test.get());
        }
        return Result.success(value);
    }

    public CachedValidator<T> cached() {
        return new CachedValidator<T>(this.rules);
    }
}

