/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world;

import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2358;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class Position {
    public static class_243 lerp(class_2338 origin, class_2338 target, double delta) {
        double x = (double)origin.method_10263() + (double)(target.method_10263() - origin.method_10263()) * delta;
        double y = (double)origin.method_10264() + (double)(target.method_10264() - origin.method_10264()) * delta;
        double z = (double)origin.method_10260() + (double)(target.method_10260() - origin.method_10260()) * delta;
        return new class_243(x, y, z);
    }

    public static class_2338 snapToGrid(class_2338 pos, int size) {
        int x = Math.round((float)pos.method_10263() / (float)size) * size;
        int z = Math.round((float)pos.method_10260() / (float)size) * size;
        return new class_2338(x, pos.method_10264(), z);
    }

    public static class_2338 nearestHub(class_2338 pos) {
        return Position.snapToGrid(pos, 1024).method_33096(500);
    }

    public static class_2338 towardsDirection(class_2338 origin, class_2338 target, double distance) {
        class_243 originVec = class_243.method_24953((class_2382)origin);
        class_243 targetVec = class_243.method_24953((class_2382)target);
        class_243 direction = targetVec.method_1020(originVec).method_1029();
        return class_2338.method_49638((class_2374)originVec.method_1019(direction.method_1021(distance)));
    }

    public static class_2338 towardsHorizontalDirection(class_2338 origin, class_2338 target, double distance) {
        return Position.towardsDirection(origin, target.method_33096(origin.method_10264()), distance);
    }

    public static class_2338 towardsRandomHorizontalDirection(class_2338 origin, int distance, int seed) {
        Random random = new Random(seed);
        random.nextLong();
        double angle = random.nextDouble() * 2.0 * Math.PI;
        return origin.method_10069((int)(Math.cos(angle) * (double)distance), 0, (int)(Math.sin(angle) * (double)distance));
    }

    public static class_2338 ascendTowards(class_2338 origin, class_2338 target, int distance) {
        return Position.towardsHorizontalDirection(origin, target, distance).method_10086(distance);
    }

    public static class_2338 ascendTowards(class_1937 level, class_2338 origin, Optional<class_2338> target, int distance, int seed) {
        class_2338 pos = target.map(recipientPos -> Position.towardsHorizontalDirection(origin, recipientPos, distance)).orElseGet(() -> Position.towardsRandomHorizontalDirection(origin, distance, seed)).method_10086(distance);
        return Position.aboveGround(level, pos, 5);
    }

    public static Optional<class_2338> ascendTowards(class_1937 level, Optional<class_2338> origin, Optional<class_2338> target, int distance, int seed) {
        return origin.map(pos -> Position.ascendTowards(level, pos, target, distance, seed));
    }

    @Deprecated
    public static boolean isInSafeSimulationDistance(class_3218 level, class_2338 pos) {
        if (!level.method_8477(pos)) {
            return false;
        }
        int simDistance = level.method_8503().method_3760().method_38651();
        int range = simDistance - 1;
        return level.method_18456().stream().anyMatch(player -> {
            double dz;
            double dx = Math.abs((double)pos.method_10263() - player.method_23317()) / 16.0;
            return Math.max(dx, dz = Math.abs((double)pos.method_10260() - player.method_23321()) / 16.0) <= (double)range;
        });
    }

    public static boolean isInSimulationDistance(class_3218 level, class_1923 chunkPos) {
        return level.method_14178().field_17254.method_17263().method_38630(chunkPos.method_8324());
    }

    public static boolean isInSimulationDistance(class_3218 level, class_2338 pos) {
        return Position.isInSimulationDistance(level, new class_1923(pos));
    }

    public static boolean isInSimulationDistance(class_3218 level, class_1297 entity) {
        return Position.isInSimulationDistance(level, entity.method_31476());
    }

    @Nullable
    public static class_2338 findNearbyHeightmapSpawnPosition(class_3218 level, class_2338 pos, int altitude) {
        double lowestDistance = Double.MAX_VALUE;
        class_2338 closestRandomPos = null;
        for (int i = 0; i < 5; ++i) {
            double distance;
            class_2338 randomPos = Position.aboveGround((class_1937)level, level.method_8536(pos.method_10263(), pos.method_10264(), pos.method_10260(), 15), altitude);
            if (!Position.isInSimulationDistance(level, randomPos) || !((distance = randomPos.method_10262((class_2382)pos)) < lowestDistance)) continue;
            lowestDistance = distance;
            closestRandomPos = randomPos;
        }
        if (closestRandomPos != null) {
            return closestRandomPos;
        }
        class_2338 blockPos = Position.aboveGround((class_1937)level, pos, altitude);
        if (Position.isInSimulationDistance(level, blockPos)) {
            return blockPos;
        }
        return null;
    }

    public static class_2338 aboveGround(class_1937 level, class_2338 pos, int altitude) {
        int heightmapY = level.method_8598(class_2902.class_2903.field_13197, pos).method_10264();
        int y = Math.max(pos.method_10264(), heightmapY + altitude);
        return pos.method_10264() == y ? pos : pos.method_33096(y);
    }

    public static int getDistanceBetween(class_2338 a, class_2338 b) {
        return (int)Math.sqrt(a.method_10262((class_2382)b));
    }

    public static Optional<Integer> getDistanceBetween(Optional<class_2338> a, Optional<class_2338> b) {
        if (a.isEmpty() || b.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Position.getDistanceBetween(a.get(), b.get()));
    }

    public static boolean isFireNearby(class_1937 level, class_2338 pos) {
        if (level == null) {
            return false;
        }
        for (class_2338 blockPos : class_2338.method_10097((class_2338)pos.method_10069(-1, -1, -1), (class_2338)pos.method_10069(1, 1, 1))) {
            if (!(level.method_8320(blockPos).method_26204() instanceof class_2358)) continue;
            return true;
        }
        return false;
    }
}

