/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.Position;
import io.github.mortuusars.envelope.world.block.PigeonholeBlock;
import io.github.mortuusars.envelope.world.block.occupiable.Occupant;
import io.github.mortuusars.envelope.world.block.occupiable.Occupiable;
import io.github.mortuusars.envelope.world.block.occupiable.PigeonOccupiable;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import org.jetbrains.annotations.NotNull;

public class PigeonholeBlockEntity
extends class_2586
implements PigeonOccupiable {
    protected List<Occupant.Mutable> occupants = new ArrayList<Occupant.Mutable>();

    protected PigeonholeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    public PigeonholeBlockEntity(class_2338 pos, class_2680 blockState) {
        this(Envelope.BlockEntityTypes.PIGEONHOLE.get(), pos, blockState);
    }

    public void serverTick(class_3218 level, class_2338 pos, class_2680 state) {
        this.tickOccupants((class_1937)level, pos, state);
    }

    public void method_5431() {
        if (Position.isFireNearby(this.field_11863, this.method_11016())) {
            this.releaseAllOccupants(this.method_10997(), this.method_11016(), this.method_11010(), Occupiable.ReleaseReason.EMERGENCY);
        }
        super.method_5431();
    }

    @Override
    public List<Occupant.Mutable> getOccupants() {
        return this.occupants;
    }

    @Override
    public void onOccupantReleased(class_1937 level, class_1297 entity, Occupiable.ReleaseReason reason) {
        if (reason == Occupiable.ReleaseReason.EMERGENCY) {
            return;
        }
        double wasteChance = this.getWasteIncreaseChanceOnRelease(entity);
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof PigeonholeBlock) {
            PigeonholeBlock block = (PigeonholeBlock)class_22482;
            if (level.field_9229.method_43058() < wasteChance) {
                block.addWaste(level, this.method_11016(), this.method_11010());
                this.method_5431();
            }
        }
        if (entity instanceof Pigeon) {
            Pigeon pigeon = (Pigeon)entity;
            pigeon.releasedFromPigeonhole(this.method_11016(), this.method_11010(), reason);
        }
    }

    protected double getWasteIncreaseChanceOnRelease(class_1297 releasedEntity) {
        Pigeon pigeon;
        return releasedEntity instanceof Pigeon && (pigeon = (Pigeon)releasedEntity).isTired() ? (Double)Config.Server.PIGEONHOLE_WASTE_INCREASE_CHANCE_AFTER_DELIVERY.get() : (Double)Config.Server.PIGEONHOLE_WASTE_INCREASE_CHANCE.get();
    }

    @Override
    public void onOccupantsChanged() {
        this.method_5431();
    }

    protected void method_57568(class_2586.class_9473 componentInput) {
        super.method_57568(componentInput);
        this.occupants.clear();
        List occupants = (List)componentInput.method_58695(Envelope.DataComponents.PIGEONS, List.of());
        occupants.forEach(o -> this.getOccupants().add(o.toMutable()));
    }

    protected void method_57567(class_9323.class_9324 components) {
        super.method_57567(components);
        components.method_57840(Envelope.DataComponents.PIGEONS, (Object)this.getImmutableOccupants());
    }

    public void method_57569(class_2487 tag) {
        super.method_57569(tag);
        tag.method_10551(this.getSerializedOccupantsName());
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        this.loadOccupiable(tag, registries);
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        this.saveOccupiable(tag, registries);
    }

    @NotNull
    public class_1937 getLevelOrThrow() {
        return Objects.requireNonNull(this.field_11863);
    }

    @Override
    public void playSound(class_3414 soundEvent, float volume, float pitch) {
        if (this.field_11863 != null) {
            this.field_11863.method_8396(null, this.method_11016(), soundEvent, class_3419.field_15245, volume, pitch);
        }
    }
}

