/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.mailbox;

import com.google.common.base.Preconditions;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.List;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public interface Inbox {
    public Address getAddress();

    public int getInboxCapacity();

    @NotNull
    public List<class_1799> getAllMail();

    public void onInboxChanged();

    default public boolean isInboxFull() {
        return this.getAllMail().size() >= this.getInboxCapacity();
    }

    default public boolean isInboxEmpty() {
        return this.getAllMail().isEmpty();
    }

    default public class_1799 getMail(int slot) {
        if (slot >= 0 && slot < this.getAllMail().size()) {
            return this.getAllMail().get(slot);
        }
        return class_1799.field_8037;
    }

    default public boolean addMailNoUpdate(int slot, class_1799 mail) {
        Preconditions.checkArgument((!mail.method_7960() ? 1 : 0) != 0, (Object)"Inbox can only store non-empty mail.");
        Preconditions.checkArgument((mail.method_7947() == 1 ? 1 : 0) != 0, (Object)("Inbox can only store mail with stack size of 1. Got: " + mail.method_7947()));
        Preconditions.checkArgument((boolean)Mail.hasId(mail), (Object)"Inbox can only store mail with 'envelope:mail_id' component.");
        Preconditions.checkArgument((slot >= 0 ? 1 : 0) != 0, (Object)("Slot index should be larger or equal to 0. Got: " + slot));
        int size = this.getAllMail().size();
        if (size < this.getInboxCapacity()) {
            if (slot > size) {
                this.getAllMail().add(mail);
            } else {
                this.getAllMail().add(slot, mail);
            }
            return true;
        }
        return false;
    }

    default public boolean addMailNoUpdate(class_1799 mail) {
        return this.addMailNoUpdate(Integer.MAX_VALUE, mail);
    }

    default public boolean addMail(int slot, class_1799 mail) {
        if (this.addMailNoUpdate(slot, mail)) {
            this.onInboxChanged();
            this.onMailAdded(mail);
            return true;
        }
        return false;
    }

    default public boolean addMail(class_1799 mail) {
        if (this.addMailNoUpdate(mail)) {
            this.onInboxChanged();
            this.onMailAdded(mail);
            return true;
        }
        return false;
    }

    default public class_1799 removeMailNoUpdate(int slot) {
        if (slot >= 0 && slot < this.getAllMail().size()) {
            return this.getAllMail().remove(slot);
        }
        return class_1799.field_8037;
    }

    default public class_1799 removeMailNoUpdate() {
        return this.removeMailNoUpdate(0);
    }

    default public class_1799 removeMail(Id id) {
        for (int i = 0; i < this.getAllMail().size(); ++i) {
            class_1799 mail = this.getAllMail().get(i);
            if (!id.equals(Mail.getId(mail))) continue;
            return this.removeMail(i);
        }
        return class_1799.field_8037;
    }

    default public class_1799 removeMail(int slot) {
        class_1799 mail = this.removeMailNoUpdate(slot);
        if (!mail.method_7960()) {
            this.onInboxChanged();
            this.onMailRemoved(slot, mail);
        }
        return mail;
    }

    default public class_1799 removeMail() {
        return this.removeMail(0);
    }

    default public boolean clearMail() {
        if (this.getAllMail().isEmpty()) {
            return false;
        }
        this.getAllMail().clear();
        this.onInboxChanged();
        this.onMailCleared();
        return true;
    }

    default public void onMailInserted(class_1799 mail) {
    }

    default public void onMailAdded(class_1799 mail) {
    }

    default public void onMailRemoved(int slot, class_1799 mail) {
    }

    default public void onMailCleared() {
    }
}

