/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.mailbox;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.world.block.mailbox.Inbox;
import io.github.mortuusars.envelope.world.block.mailbox.UnloadedInbox;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class InboxStorage
extends class_18 {
    public static final Codec<InboxStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_4844.field_41525, UnloadedInbox.CODEC).optionalFieldOf("inboxes", Collections.emptyMap()).forGetter(InboxStorage::getInboxes)).apply((Applicative)instance, InboxStorage::new));
    public static final Logger LOGGER = LogUtils.getLogger();
    private final Map<UUID, UnloadedInbox> inboxes;

    public InboxStorage(Map<UUID, UnloadedInbox> inboxes) {
        this.inboxes = new HashMap<UUID, UnloadedInbox>(inboxes);
    }

    public InboxStorage() {
        this.inboxes = new HashMap<UUID, UnloadedInbox>();
    }

    protected Map<UUID, UnloadedInbox> getInboxes() {
        return this.inboxes;
    }

    public void put(UUID id, Inbox inbox) {
        UnloadedInbox unloadedInbox = new UnloadedInbox(id, inbox.getAddress(), inbox.getInboxCapacity(), inbox.getAllMail());
        unloadedInbox.getAllMail().removeIf(class_1799::method_7960);
        this.inboxes.put(unloadedInbox.getId(), unloadedInbox);
        this.method_80();
        if (Bugger.isEnabled() && !unloadedInbox.isInboxEmpty()) {
            LOGGER.info("Stored inbox with size [{}] of mailbox {}", (Object)unloadedInbox.getAllMail().size(), (Object)unloadedInbox.getAddress());
        }
    }

    public Optional<Inbox> remove(UUID id) {
        return Optional.ofNullable(this.inboxes.remove(id)).map(inbox -> {
            this.method_80();
            if (Bugger.isEnabled() && !inbox.getAllMail().isEmpty()) {
                LOGGER.info("Loaded inbox with size [{}] of mailbox {}", (Object)inbox.getAllMail().size(), (Object)inbox.getAddress());
            }
            return inbox;
        });
    }

    @NotNull
    public Optional<Inbox> getForDelivery(Address.Block address) {
        for (UnloadedInbox inbox : this.getInboxes().values()) {
            if (!inbox.getAddress().equals(address)) continue;
            inbox.onChanged(() -> ((InboxStorage)this).method_80());
            return Optional.of(inbox);
        }
        return Optional.empty();
    }

    public static InboxStorage get(class_3218 level) {
        return (InboxStorage)level.method_8503().method_30002().method_17983().method_17924(InboxStorage.factory(), "envelope_inboxes");
    }

    @NotNull
    public static class_18.class_8645<InboxStorage> factory() {
        return new class_18.class_8645(InboxStorage::new, (tag, provider) -> CODEC.parse((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), tag).resultOrPartial(e -> Envelope.LOGGER.error("Cannot load InboxStorage: {}", e)).orElse(null), null);
    }

    @NotNull
    public class_2487 method_75(class_2487 tag, class_7225.class_7874 registries) {
        return CODEC.encode((Object)this, (DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).resultOrPartial(e -> Envelope.LOGGER.error("Cannot save InboxStorage: {}", e)).orElse(tag);
    }
}

