/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.mailbox;

import com.mojang.serialization.MapCodec;
import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.clientbound.OpenMailboxAddressTagScreenS2CP;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlockEntity;
import io.github.mortuusars.envelope.world.delivery.CourierOrigin;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.item.AddressTagItem;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressValidation;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import io.github.mortuusars.envelope.world.service.MailService;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9062;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MailboxBlock
extends class_2237 {
    public static final MapCodec<MailboxBlock> CODEC = MailboxBlock.method_54094(MailboxBlock::new);
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 OPEN = class_2741.field_12537;
    public static final class_265 SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public MailboxBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @NotNull
    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @NotNull
    protected class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, OPEN});
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
    }

    @NotNull
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    @NotNull
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        MailboxBlockEntity blockEntity;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof MailboxBlockEntity && !(blockEntity = (MailboxBlockEntity)class_25862).getAllMail().isEmpty()) {
            return 15;
        }
        return 0;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2586 class_25862;
        super.method_9567(level, pos, state, placer, stack);
        if (placer != null && (class_25862 = level.method_8321(pos)) instanceof MailboxBlockEntity) {
            MailboxBlockEntity blockEntity = (MailboxBlockEntity)class_25862;
            blockEntity.setOwner(placer.method_5667());
        }
    }

    protected void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean movedByPiston) {
        if (!state.method_26204().equals(newState.method_26204()) && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            MailService.of(serverLevel).getMailboxes().remove(pos);
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof MailboxBlockEntity) {
                MailboxBlockEntity blockEntity = (MailboxBlockEntity)class_25862;
                blockEntity.onBlockRemoved(level, pos, state, newState);
            }
        }
        super.method_9536(state, level, pos, newState, movedByPiston);
    }

    @NotNull
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        MailboxBlockEntity blockEntity;
        Object knownAddresses2;
        if (!MailService.operatesIn(level)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Mail Service does not operate in this dimension.").method_27692(class_124.field_1061), true);
            return class_9062.field_47728;
        }
        if (stack.method_7909() instanceof AddressTagItem) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_2586 class_25862 = level.method_8321(pos);
                if (class_25862 instanceof MailboxBlockEntity) {
                    MailboxBlockEntity blockEntity2 = (MailboxBlockEntity)class_25862;
                    AllAddresses knownAddresses2 = serverPlayer.method_51469().getEnvelopeMailService().getKnownAddresses();
                    Packets.sendToClient(new OpenMailboxAddressTagScreenS2CP(hand, knownAddresses2, pos, blockEntity2.getAddress()), serverPlayer);
                }
            }
            return class_9062.field_47728;
        }
        if (player.method_7337() && stack.method_31573(Envelope.Tags.Items.MAILABLE) && (knownAddresses2 = stack.method_57824(Envelope.DataComponents.MAIL_RECIPIENT)) instanceof Address.Block) {
            Address.Block recipientAddress = (Address.Block)knownAddresses2;
            knownAddresses2 = level.method_8321(pos);
            if (knownAddresses2 instanceof MailboxBlockEntity && (blockEntity = (MailboxBlockEntity)knownAddresses2).getAddress().equals(recipientAddress)) {
                if (level instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)level;
                    class_1799 result = MailService.of(serverLevel).deliverMail(recipientAddress, stack.method_7971(1));
                    if (player.method_5998(hand).method_7960()) {
                        player.method_6122(hand, result.method_7972());
                    } else if (!player.method_7270(result)) {
                        player.method_7328(result, false);
                    }
                }
                return class_9062.field_47728;
            }
        }
        if (stack.method_31574((class_1792)Envelope.Items.PIGEON_SPAWN_EGG.get())) {
            if (level instanceof class_3218) {
                Pigeon pigeon;
                class_3218 serverLevel = (class_3218)level;
                class_2586 class_25863 = level.method_8321(pos);
                if (class_25863 instanceof MailboxBlockEntity && (blockEntity = (MailboxBlockEntity)class_25863).isAvailableForPickup() && (class_25863 = Envelope.EntityTypes.PIGEON.get().method_47821(serverLevel, pos.method_10093((class_2350)state.method_11654((class_2769)FACING)), class_3730.field_16465)) instanceof Pigeon && blockEntity.tryStartDelivery(pigeon = (Pigeon)class_25863)) {
                    pigeon.setOrigin(CourierOrigin.service());
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                } else {
                    serverLevel.method_8396(null, pos, (class_3414)class_3417.field_14624.comp_349(), class_3419.field_15245, 1.0f, 1.0f);
                }
            }
            return class_9062.field_47728;
        }
        return super.method_55765(stack, state, level, pos, player, hand, hitResult);
    }

    @NotNull
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        if (!MailService.operatesIn(level)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Mail Service does not operate in this dimension.").method_27692(class_124.field_1061), true);
            return class_1269.field_51370;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof MailboxBlockEntity) {
            MailboxBlockEntity blockEntity = (MailboxBlockEntity)class_25862;
            blockEntity.openMenu(player);
        }
        return class_1269.field_51370;
    }

    public void changeAddress(class_1657 player, class_2338 pos, class_1268 hand, String addressId) {
        class_1937 class_19372 = player.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)class_19372;
        class_1799 stack = player.method_5998(hand);
        if (!(stack.method_7909() instanceof AddressTagItem)) {
            Envelope.LOGGER.error("Failed change address: item in hand is not AddressTagItem, but {}", (Object)stack);
            return;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof MailboxBlockEntity)) {
            Envelope.LOGGER.error("Failed change address: block entity at pos is not a MailboxBlockEntity.");
            return;
        }
        MailboxBlockEntity blockEntity = (MailboxBlockEntity)class_25862;
        AddressValidation.forMailbox(MailService.of(level).getKnownAddresses(), player).test(addressId).ifPresentOrElse(id -> {
            MailboxBlock.applyAddress(player, blockEntity, new Address.Block((String)id), stack);
            player.method_23667(hand, true);
            if (!player.method_7337()) {
                stack.method_7934(1);
            }
        }, error -> {
            player.method_7353((class_2561)error.getTranslation(), true);
            player.method_5783((class_3414)class_3417.field_14624.comp_349(), 0.75f, 1.0f);
        });
    }

    public static void placeBlockWithAddress(class_1657 player, class_1268 hand, class_1750 context, String addressId) {
        class_1937 class_19372 = player.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)class_19372;
        class_2338 pos = context.method_8037();
        class_1799 stack = player.method_5998(hand);
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            player.method_5783((class_3414)class_3417.field_14624.comp_349(), 0.75f, 1.0f);
            Envelope.LOGGER.error("Failed to place mailbox: item in hand is not a BlockItem, but {}", (Object)stack);
            return;
        }
        class_1747 blockItem = (class_1747)class_17922;
        AddressValidation.forMailbox(MailService.of(level).getKnownAddresses(), player).test(addressId).ifPresentOrElse(id -> {
            blockItem.method_7712(context);
            class_2586 patt0$temp = level.method_8321(pos);
            if (!(patt0$temp instanceof MailboxBlockEntity)) {
                player.method_5783((class_3414)class_3417.field_14624.comp_349(), 0.75f, 1.0f);
                Envelope.LOGGER.error("Failed to place mailbox: be at pos [{}] is not MailboxBlockEntity", (Object)pos.method_23854());
                return;
            }
            MailboxBlockEntity blockEntity = (MailboxBlockEntity)patt0$temp;
            blockEntity.method_11010().method_26204().method_9567((class_1937)level, pos, blockEntity.method_11010(), (class_1309)player, stack);
            MailboxBlock.applyAddress(player, blockEntity, new Address.Block((String)id), stack);
            player.method_23667(hand, true);
        }, error -> {
            player.method_7353((class_2561)error.getTranslation(), true);
            player.method_5783((class_3414)class_3417.field_14624.comp_349(), 0.75f, 1.0f);
        });
    }

    private static void applyAddress(class_1657 player, MailboxBlockEntity blockEntity, Address.Block address, class_1799 stack) {
        blockEntity.setAddress(address);
        if ((Integer)Config.Server.MAILBOX_ADDRESS_EXPERIENCE_LEVELS_COST.get() > 0) {
            player.method_37908().method_45447(player, blockEntity.method_11016(), class_3417.field_15119, class_3419.field_15245);
        }
        if (!player.method_7337()) {
            player.method_7316(-((Integer)Config.Server.MAILBOX_ADDRESS_EXPERIENCE_LEVELS_COST.get()).intValue());
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MailboxBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return level.field_9236 ? null : MailboxBlock.method_31618(blockEntityType, Envelope.BlockEntityTypes.MAILBOX.get(), (lvl, blockPos, blockState, blockEntity) -> blockEntity.serverTick((class_3218)lvl, blockPos, state));
    }
}

