/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.mailbox;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.PlatformHelper;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.clientbound.MailboxHasNewMailS2CP;
import io.github.mortuusars.envelope.world.block.mailbox.Inbox;
import io.github.mortuusars.envelope.world.block.mailbox.InboxStorage;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlock;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.inventory.MailboxMenu;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.SimpleBlockAddressGenerator;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MailboxBlockEntity
extends class_2624
implements Inbox {
    public static final int REGULAR_SLOTS = 2;
    public static final int SLOT_FOOD = 0;
    public static final int SLOT_MAIL = 1;
    public static final int INBOX_SLOT = 2;
    private static final Logger LOGGER = LogUtils.getLogger();
    private class_2371<class_1799> items = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    @NotNull
    private UUID inboxId = UUID.randomUUID();
    @Nullable
    private Address.Block address;
    @Nullable
    private UUID owner;
    @NotNull
    private List<class_1799> mail = new ArrayList<class_1799>();
    private boolean loaded = false;
    private boolean blockRemoved = false;

    protected MailboxBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    public MailboxBlockEntity(class_2338 pos, class_2680 blockState) {
        this(Envelope.BlockEntityTypes.MAILBOX.get(), pos, blockState);
    }

    @NotNull
    protected class_2561 method_17823() {
        return this.address != null ? this.address.getName() : class_2561.method_43471((String)"container.envelope.mailbox");
    }

    @Override
    @NotNull
    public Address.Block getAddress() {
        return (Address.Block)Preconditions.checkNotNull((Object)this.address, (Object)("Address of mailbox at [" + this.method_11016().method_23854() + "] was not set."));
    }

    public void setAddress(@Nullable Address.Block address) {
        class_3218 serverLevel;
         @Nullable Address.Block currentAddress = this.address;
        this.address = address;
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218 && MailService.operatesIn((class_1937)(serverLevel = (class_3218)class_19372))) {
            address = Objects.requireNonNullElseGet(address, () -> this.generateRandomAddress(serverLevel));
            address = MailService.of(serverLevel).getMailboxes().correctOrRegisterIfNeeded(address, this.method_11016());
            if (!address.equals(currentAddress)) {
                this.address = address;
                this.method_5431();
                serverLevel.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
            }
        }
    }

    protected void applyAddress() {
        this.setAddress(this.address);
    }

    @NotNull
    protected Address.Block generateRandomAddress(class_3218 level) {
        return new SimpleBlockAddressGenerator(MailService.of(level).getKnownAddresses(), 50).generate(level.method_8409());
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
        this.method_5431();
    }

    public Optional<class_1657> getOwnerPlayer() {
        if (this.owner == null || this.field_11863 == null) {
            return Optional.empty();
        }
        for (class_1657 player : this.field_11863.method_18456()) {
            if (!player.method_5667().equals(this.owner)) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    @NotNull
    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> items) {
        this.items = items;
    }

    public int method_5439() {
        return 2 + this.getAllMail().size();
    }

    @NotNull
    public class_1799 method_5438(int slot) {
        if (slot >= 2) {
            return this.getMail(slot - 2);
        }
        return super.method_5438(slot);
    }

    @NotNull
    public class_1799 method_5434(int slot, int amount) {
        if (slot >= 2) {
            return this.removeMail(slot - 2);
        }
        return super.method_5434(slot, amount);
    }

    @NotNull
    public class_1799 method_5441(int slot) {
        if (slot >= 2) {
            return this.removeMailNoUpdate(slot - 2);
        }
        return super.method_5441(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot >= 2) {
            this.addMail(slot - 2, stack);
            return;
        }
        super.method_5447(slot, stack);
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot == 0) {
            return stack.method_31573(Envelope.Tags.Items.PIGEON_FOOD);
        }
        if (slot == 1) {
            return this.isSendable(stack);
        }
        return false;
    }

    public boolean method_49104(class_1263 target, int slot, class_1799 stack) {
        return slot >= 2 && target.method_43256(class_1799::method_7960);
    }

    public boolean isSendable(class_1799 stack) {
        return !stack.method_7960() && stack.method_31573(Envelope.Tags.Items.MAILABLE) && stack.method_57826(Envelope.DataComponents.MAIL_RECIPIENT);
    }

    public boolean isAvailableForPickup() {
        if (this.field_11863 == null) {
            return false;
        }
        return !this.method_5438(0).method_7960() && this.isSendable(this.method_5438(1));
    }

    @NotNull
    protected class_1703 method_5465(int containerId, class_1661 inventory) {
        this.applyAddress();
        return new MailboxMenu(containerId, inventory, this.method_11016(), this.getAddress(), this.getAllMail());
    }

    public void openMenu(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (this.getOwner() == null) {
                this.setOwner(player.method_5667());
            }
            PlatformHelper.openMenu(serverPlayer, (class_3908)this, buffer -> {
                buffer.method_10807(this.method_11016());
                Address.Block.STREAM_CODEC.encode(buffer, (Object)this.getAddress());
                class_1799.field_48350.encode(buffer, this.getAllMail());
            });
            this.playSound(class_3417.field_17604, 0.6f, 1.1f);
        }
    }

    public boolean tryStartDelivery(Pigeon pigeon) {
        if (!MailService.operatesIn(pigeon.method_37908())) {
            return false;
        }
        class_3218 level = (class_3218)pigeon.method_37908();
        if (pigeon.isDelivering()) {
            return false;
        }
        class_1799 mailStack = this.method_5438(1);
        if (!this.isSendable(mailStack)) {
            return false;
        }
        this.applyAddress();
        class_1799 mail = Mail.removePreviousDeliveryData(mailStack.method_46651(1));
        return MailService.of(level).getDeliveryManager().start(pigeon, Delivery.draft().deliver(mail).from(this.getAddress()).to(Mail.getRecipientOrUnknown(mail)).owner(this.getOwner())).getValue().map(delivery -> {
            this.method_5434(1, 1);
            this.method_5434(0, 1);
            class_243 pos = pigeon.method_19538();
            level.method_14199((class_2394)class_2398.field_11204, pos.field_1352, pos.field_1351, pos.field_1350, 10, 0.3, 0.3, 0.3, 0.02);
            level.method_60511(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_14581, class_3419.field_15254, 1.0f, 1.3f);
            return true;
        }).orElse(false);
    }

    @Override
    public int getInboxCapacity() {
        return 512;
    }

    @Override
    @NotNull
    public List<class_1799> getAllMail() {
        return this.mail;
    }

    @Override
    public void onMailInserted(class_1799 mail) {
        this.playSound((class_3414)class_3417.field_14725.comp_349(), 1.0f, 1.0f);
    }

    @Override
    public void onMailAdded(class_1799 mail) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            MailboxMenu.playersWithMenu(serverLevel, this.getAddress()).forEach(player -> Packets.sendToClient(MailboxHasNewMailS2CP.INSTANCE, player));
        }
    }

    @Override
    public void onMailRemoved(int slot, class_1799 mail) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            Optional.ofNullable(Mail.getId(mail)).ifPresent(id -> MailboxMenu.executeForPlayersWithMenu(serverLevel, this.getAddress(), (player, menu) -> menu.onMailRemoved((Id)id)));
        }
    }

    @Override
    public void onInboxChanged() {
        if (this.field_11863 != null) {
            this.field_11863.method_8455(this.method_11016(), this.method_11010().method_26204());
        }
    }

    protected void loadInbox() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.mail = InboxStorage.get(serverLevel).remove(this.inboxId).map(Inbox::getAllMail).orElseGet(ArrayList::new);
        } else {
            this.mail = new ArrayList<class_1799>();
        }
    }

    protected void unloadInbox() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.address != null) {
                InboxStorage.get(serverLevel).put(this.inboxId, this);
            }
        }
        this.mail.clear();
    }

    public void serverTick(class_3218 level, class_2338 blockPos, class_2680 blockState) {
        if (!this.loaded) {
            this.onLoaded();
            this.loaded = true;
        }
    }

    protected void onLoaded() {
        this.applyAddress();
        if (this.field_11863 != null) {
            this.field_11863.method_8455(this.method_11016(), this.method_11010().method_26204());
        }
    }

    public void onBlockRemoved(class_1937 level, class_2338 pos, class_2680 state, class_2680 newState) {
        class_1264.method_54291((class_2680)state, (class_2680)newState, (class_1937)level, (class_2338)pos);
        this.clearMail();
        this.blockRemoved = true;
    }

    public void method_10996() {
        super.method_10996();
        this.loadInbox();
        this.blockRemoved = false;
    }

    public void method_11012() {
        super.method_11012();
        if (!this.blockRemoved) {
            this.unloadInbox();
        }
    }

    public void method_5431() {
        super.method_5431();
        this.updateBlockStateIfNeeded();
    }

    private void updateBlockStateIfNeeded() {
        class_1937 class_19372;
        if (!this.method_11015() && (class_19372 = this.field_11863) instanceof class_3218) {
            boolean shouldBeOpen;
            class_3218 serverLevel = (class_3218)class_19372;
            class_2680 state = this.method_11010();
            boolean isOpen = (Boolean)state.method_11654((class_2769)MailboxBlock.OPEN);
            if (isOpen != (shouldBeOpen = this.isAvailableForPickup())) {
                serverLevel.method_8501(this.method_11016(), (class_2680)state.method_11657((class_2769)MailboxBlock.OPEN, (Comparable)Boolean.valueOf(shouldBeOpen)));
                this.playSound(shouldBeOpen ? class_3417.field_42569 : class_3417.field_42568, 0.75f, shouldBeOpen ? 1.0f : 0.75f);
            }
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_58692(registries);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        class_1262.method_5429((class_2487)tag, this.items, (class_7225.class_7874)registries);
        this.setAddress(tag.method_10573("address", 8) ? new Address.Block(tag.method_10558("address")) : null);
        this.owner = tag.method_25928("owner") ? tag.method_25926("owner") : null;
        this.inboxId = tag.method_25928("inbox_id") ? tag.method_25926("inbox_id") : UUID.randomUUID();
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        class_1262.method_5426((class_2487)tag, this.items, (class_7225.class_7874)registries);
        if (this.address != null) {
            tag.method_10582("address", this.address.id());
        }
        if (this.owner != null) {
            tag.method_25927("owner", this.owner);
        }
        tag.method_25927("inbox_id", this.inboxId);
    }

    public void playSound(class_3414 soundEvent, float volume, float pitch) {
        if (this.field_11863 != null) {
            this.field_11863.method_8396(null, this.method_11016(), soundEvent, class_3419.field_15245, volume, pitch);
        }
    }
}

