/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.mailbox;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlockEntity;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxesSavedData;
import io.github.mortuusars.envelope.world.block.mailbox.RegisteredMailbox;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressUniquifier;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Mailboxes {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private final class_3218 level;
    @Nullable
    private MailboxesSavedData data;

    public Mailboxes(class_3218 level) {
        this.level = level;
    }

    @NotNull
    protected MailboxesSavedData data() {
        if (this.data == null) {
            this.data = MailboxesSavedData.get(this.level);
        }
        return this.data;
    }

    protected Map<Address.Block, RegisteredMailbox> getMailboxes() {
        return this.data().getMailboxes();
    }

    protected void setDirty() {
        this.data().method_80();
    }

    public Set<Address.Block> getAllAddresses() {
        return this.getMailboxes().keySet();
    }

    @NotNull
    public Address.Block correctOrRegisterIfNeeded(Address.Block suggestedAddress, class_2338 pos) {
        @Nullable RegisteredMailbox registeredAtPos = this.getAtPosition(pos);
        if (registeredAtPos != null) {
            if (registeredAtPos.getAddress().equals(suggestedAddress) && !this.inUseAsPlayerOrEntity(registeredAtPos.getAddress())) {
                return suggestedAddress;
            }
            return this.rename(registeredAtPos, suggestedAddress).getAddress();
        }
        Address.Block address = this.uniquifyIfKnown(suggestedAddress);
        this.getMailboxes().entrySet().removeIf(entry -> {
            if (((RegisteredMailbox)entry.getValue()).getPos().equals((Object)pos)) {
                LOGGER.info("Removing mailbox '{}'@[{}] because new mailbox '{}' is being registered at the same blockpos.", new Object[]{((RegisteredMailbox)entry.getValue()).getAddress().id(), ((RegisteredMailbox)entry.getValue()).getPos().method_23854(), address.id()});
                return true;
            }
            return false;
        });
        RegisteredMailbox data = new RegisteredMailbox(address, pos);
        this.getMailboxes().put(address, data);
        if (Envelope.debug()) {
            LOGGER.info("Registered new mailbox '{}'@[{}]", (Object)address.id(), (Object)pos.method_23854());
        }
        this.setDirty();
        return address;
    }

    public void remove(Address.Block address) {
        @Nullable RegisteredMailbox removed = this.getMailboxes().remove(address);
        if (removed != null) {
            MailService.of(this.level).getPlayers().removeDefaultAddress(address);
            this.setDirty();
            if (Envelope.debug()) {
                LOGGER.info("Removed mailbox '{}'@[{}]", (Object)removed.getAddress().id(), (Object)removed.getPos().method_23854());
            }
        }
    }

    public void remove(class_2338 pos) {
        Optional.ofNullable(this.getAtPosition(pos)).ifPresent(data -> this.remove(data.getAddress()));
    }

    @NotNull
    public RegisteredMailbox rename(RegisteredMailbox data, Address.Block suggestedAddress) {
        Address.Block newAddress = this.uniquifyIfKnown(suggestedAddress);
        MailService.of(this.level).getPlayers().renameDefaultAddress(data.getAddress(), newAddress);
        RegisteredMailbox newData = new RegisteredMailbox(newAddress, data.getPos());
        this.getMailboxes().remove(data.getAddress());
        this.getMailboxes().put(newAddress, newData);
        if (Envelope.debug()) {
            LOGGER.info("Renamed mailbox '{}'@[{}] to '{}'", new Object[]{data.getAddress().id(), data.getPos().method_23854(), newAddress.id()});
        }
        this.setDirty();
        return newData;
    }

    public void rename(Address.Block oldAddress, Address.Block suggestedAddress) {
        this.getByAddress(oldAddress).ifPresent(data -> this.rename((RegisteredMailbox)data, suggestedAddress));
    }

    public boolean exists(Address.Block block) {
        return this.getMailboxes().containsKey(block);
    }

    public Optional<RegisteredMailbox> getByAddress(Address.Block address) {
        return Optional.ofNullable(this.getMailboxes().get(address));
    }

    @Nullable
    public RegisteredMailbox getAtPosition(class_2338 pos) {
        for (RegisteredMailbox mailbox : this.getMailboxes().values()) {
            if (!mailbox.getPos().equals((Object)pos)) continue;
            return mailbox;
        }
        return null;
    }

    public Optional<class_2338> getPositionOf(Address.Block address) {
        return this.getByAddress(address).map(RegisteredMailbox::getPos);
    }

    public Optional<MailboxBlockEntity> getBlockEntityOf(Address.Block address) {
        return this.getPositionOf(address).flatMap(pos -> {
            Optional<Object> optional;
            class_2586 patt0$temp;
            if (this.level.method_8477(pos) && (patt0$temp = this.level.method_8321(pos)) instanceof MailboxBlockEntity) {
                MailboxBlockEntity blockEntity = (MailboxBlockEntity)patt0$temp;
                optional = Optional.of(blockEntity);
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
    }

    private boolean inUseAsPlayerOrEntity(Address.Block address) {
        AllAddresses knownAddresses = MailService.of(this.level).getKnownAddresses();
        return knownAddresses.isKnownOfType(address, Address.Type.PLAYER) || knownAddresses.isKnownOfType(address, Address.Type.ENTITY);
    }

    private Address.Block uniquifyIfKnown(Address.Block address) {
        AllAddresses knownAddresses = MailService.of(this.level).getKnownAddresses();
        if (!knownAddresses.isKnown(address)) {
            return address;
        }
        AddressUniquifier uniquifier = new AddressUniquifier(knownAddresses);
        String uniqueId = uniquifier.uniquify(address.id());
        return new Address.Block(uniqueId);
    }
}

