/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.block.occupiable;

import com.mojang.serialization.DynamicOps;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.block.occupiable.Occupant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3922;
import net.minecraft.class_4481;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import org.jetbrains.annotations.Nullable;

public interface Occupiable {
    public static final List<String> IGNORED_OCCUPANT_TAGS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "SleepingX", "SleepingY", "SleepingZ", "Passengers", "UUID", "leash");

    public boolean canBeOccupiedBy(class_1297 var1);

    public List<Occupant.Mutable> getOccupants();

    public class_3414 getOccupantEnterSound(class_1297 var1);

    public class_3414 getOccupantExitSound(class_1297 var1);

    public class_3414 getOccupantWorkSound();

    public void playSound(class_3414 var1, float var2, float var3);

    default public List<Occupant> getImmutableOccupants() {
        return this.getOccupants().stream().map(Occupant.Mutable::toImmutable).toList();
    }

    default public int getMaxOccupantsCount() {
        return 3;
    }

    default public boolean hasSpaceForAnotherOccupant() {
        return this.getOccupants().size() < this.getMaxOccupantsCount();
    }

    default public int getMinimumTicksInsideForOccupant(class_1297 entity) {
        return 600;
    }

    default public void addOccupant(class_2338 pos, class_2680 state, class_1297 entity) {
        if (!this.hasSpaceForAnotherOccupant() || !this.canBeOccupiedBy(entity)) {
            return;
        }
        entity.method_5848();
        entity.method_5772();
        class_2487 tag = new class_2487();
        entity.method_5662(tag);
        this.cleanupOccupantEntityTag(tag);
        this.getOccupants().add(new Occupant(class_9279.method_57456((class_2487)tag), this.getFirstFreeSlotForOccupant(), this.getMinimumTicksInsideForOccupant(entity), 0).toMutable());
        entity.method_37908().method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)state));
        this.playSound(this.getOccupantEnterSound(entity), 1.0f, 1.0f);
        entity.method_31472();
        this.onOccupantsChanged();
    }

    default public Optional<class_1297> releaseOccupant(class_1937 level, class_2338 pos, class_2680 state, Occupant occupant, ReleaseReason reason) {
        boolean isFrontBlockedOff;
        if (!(level instanceof class_3218)) {
            return Optional.empty();
        }
        class_3218 serverLevel = (class_3218)level;
        if ((level.method_23886() || level.method_8546()) && reason != ReleaseReason.EMERGENCY) {
            return Optional.empty();
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)class_4481.field_20419);
        class_2338 releasePos = pos.method_10093(direction);
        boolean bl = isFrontBlockedOff = !level.method_8320(releasePos).method_26220((class_1922)level, releasePos).method_1110();
        if (isFrontBlockedOff && reason != ReleaseReason.EMERGENCY) {
            return Optional.empty();
        }
        @Nullable class_1297 entity = this.createEntityFromOccupant(level, occupant, pos);
        if (entity == null) {
            return Optional.empty();
        }
        double offset = isFrontBlockedOff ? 0.0 : 0.55 + (double)(entity.method_17681() / 2.0f);
        double x = (double)pos.method_10263() + 0.5 + offset * (double)direction.method_10148();
        double y = (double)pos.method_10264() + 0.5 - (double)(entity.method_17682() / 2.0f);
        double z = (double)pos.method_10260() + 0.5 + offset * (double)direction.method_10165();
        entity.method_5808(x, y, z, entity.method_36454(), entity.method_36455());
        this.playSound(this.getOccupantExitSound(entity), 1.0f, 1.0f);
        level.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)state));
        if (level.method_8649(entity)) {
            this.onOccupantReleased((class_1937)serverLevel, entity, reason);
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    @Nullable
    default public class_1297 createEntityFromOccupant(class_1937 level, Occupant occupant, class_2338 pos) {
        class_2487 tag = occupant.entityData().method_57461();
        this.cleanupOccupantEntityTag(tag);
        @Nullable class_1297 entity = class_1299.method_17842((class_2487)tag, (class_1937)level, Function.identity());
        if (entity == null || !this.canBeOccupiedBy(entity)) {
            return null;
        }
        this.updateEntityAfterRelease(entity, occupant.ticksInside());
        return entity;
    }

    default public List<class_1297> releaseAllOccupants(class_1937 level, class_2338 pos, class_2680 state, ReleaseReason reason) {
        ArrayList<class_1297> releasedEntities = new ArrayList<class_1297>();
        this.getOccupants().removeIf(occupant -> this.releaseOccupant(level, pos, state, occupant.toImmutable(), reason).map(entity -> {
            releasedEntities.add((class_1297)entity);
            return true;
        }).orElse(false));
        if (!releasedEntities.isEmpty()) {
            this.onOccupantsChanged();
        }
        return releasedEntities;
    }

    default public void onOccupantReleased(class_1937 level, class_1297 entity, ReleaseReason reason) {
    }

    default public void updateEntityAfterRelease(class_1297 entity, int ticksInside) {
        entity.method_5875(true);
        if (entity instanceof class_1429) {
            class_1429 animal = (class_1429)entity;
            int ageTicks = animal.method_5618();
            if (ageTicks < 0) {
                animal.method_5614(Math.min(0, ageTicks + ticksInside));
            } else if (ageTicks > 0) {
                animal.method_5614(Math.max(0, ageTicks - ticksInside));
            }
            animal.method_6476(Math.max(0, animal.method_29270() - ticksInside));
        }
    }

    default public void onOccupantsChanged() {
    }

    default public void tickOccupants(class_1937 level, class_2338 pos, class_2680 state) {
        if (!this.getOccupants().isEmpty() && (level.method_8510() + (long)pos.hashCode()) % 20L == 0L && class_3922.method_23895((class_1937)level, (class_2338)pos)) {
            this.releaseAllOccupants(level, pos, state, ReleaseReason.EMERGENCY);
        }
        if (this.getOccupants().removeIf(occupant -> occupant.tick() && this.releaseOccupant(level, pos, state, occupant.toImmutable(), ReleaseReason.DEFAULT).isPresent())) {
            this.onOccupantsChanged();
        }
        if (!this.getOccupants().isEmpty() && level.method_8409().method_43058() < 0.004 * (double)this.getOccupants().size()) {
            this.playSound(this.getOccupantWorkSound(), 0.5f, 1.0f);
        }
    }

    default public void cleanupOccupantEntityTag(class_2487 tag) {
        IGNORED_OCCUPANT_TAGS.forEach(arg_0 -> ((class_2487)tag).method_10551(arg_0));
    }

    default public String getSerializedOccupantsName() {
        return "occupants";
    }

    default public void saveOccupiable(class_2487 tag, class_7225.class_7874 registries) {
        tag.method_10566(this.getSerializedOccupantsName(), (class_2520)Occupant.LIST_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.getImmutableOccupants()).getOrThrow());
    }

    default public void loadOccupiable(class_2487 tag, class_7225.class_7874 registries) {
        this.getOccupants().clear();
        Occupant.LIST_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580(this.getSerializedOccupantsName())).resultOrPartial(error -> Envelope.LOGGER.error("Failed to parse occupants: '{}'", error)).map(list -> list.stream().map(Occupant::toMutable).toList()).ifPresent(list -> this.getOccupants().addAll((Collection<Occupant.Mutable>)list));
    }

    default public int getFirstFreeSlotForOccupant() {
        List<Integer> slots = this.getImmutableOccupants().stream().map(Occupant::slot).sorted().toList();
        int slot = 0;
        while (slots.contains(slot)) {
            ++slot;
        }
        return slot;
    }

    public static enum ReleaseReason {
        DEFAULT,
        EMERGENCY;

    }
}

