/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.delivery;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.world.delivery.DeliveryDraft;
import io.github.mortuusars.envelope.world.delivery.phase.DeliveryPhase;
import io.github.mortuusars.envelope.world.delivery.route.DeliveryRoute;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_4844;

public class Delivery {
    public static final Codec<Delivery> CODEC = RecordCodecBuilder.create(i -> i.group((App)Id.CODEC.fieldOf("id").forGetter(Delivery::getId), (App)class_4844.field_25122.optionalFieldOf("owner").forGetter(Delivery::getOwner), (App)Address.CODEC.fieldOf("sender").forGetter(Delivery::getSender), (App)Address.CODEC.fieldOf("recipient").forGetter(Delivery::getRecipient), (App)class_1799.field_49266.optionalFieldOf("mail", (Object)class_1799.field_8037).forGetter(Delivery::getMail), (App)DeliveryRoute.CODEC.optionalFieldOf("route", (Object)DeliveryRoute.EMPTY).forGetter(Delivery::getRoute), (App)DeliveryPhase.CODEC.optionalFieldOf("phase", (Object)DeliveryPhase.STARTED).forGetter(Delivery::getPhase), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("phase_progress", (Object)0).forGetter(Delivery::getPhaseProgress), (App)Codec.BOOL.optionalFieldOf("ended", (Object)false).forGetter(Delivery::isEnded)).apply((Applicative)i, Delivery::new));
    private final Id id;
    private final Optional<UUID> owner;
    private final Address sender;
    private final Address recipient;
    private class_1799 mail;
    private DeliveryRoute route;
    private DeliveryPhase phase;
    private int phaseProgress;
    private boolean ended;

    public Delivery(Id id, Optional<UUID> owner, Address sender, Address recipient, class_1799 mail, DeliveryRoute route, DeliveryPhase phase, int phaseProgress, boolean ended) {
        this.id = id;
        this.owner = owner;
        this.sender = sender;
        this.recipient = recipient;
        this.mail = mail;
        this.route = route;
        this.phase = phase;
        this.phaseProgress = phaseProgress;
        this.ended = ended;
    }

    public static DeliveryDraft draft() {
        return new DeliveryDraft();
    }

    public Id getId() {
        return this.id;
    }

    public Optional<UUID> getOwner() {
        return this.owner;
    }

    public Address getSender() {
        return this.sender;
    }

    public Address getRecipient() {
        return this.recipient;
    }

    public class_1799 getMail() {
        return this.mail;
    }

    public Delivery setMail(class_1799 mail) {
        this.mail = mail;
        return this;
    }

    public DeliveryRoute getRoute() {
        return this.route;
    }

    public void setRoute(DeliveryRoute route) {
        this.route = route;
    }

    public void updateRoute(class_3218 level) {
        this.setRoute(DeliveryRoute.build(level, this.getSender(), this.getRecipient()));
    }

    public DeliveryPhase getPhase() {
        return this.phase;
    }

    public void setPhase(DeliveryPhase phase, int progress) {
        this.phase = phase;
        this.setPhaseProgress(progress);
    }

    public void setPhaseAndResetProgress(DeliveryPhase phase) {
        this.setPhase(phase, 0);
    }

    public int getPhaseProgress() {
        return this.phaseProgress;
    }

    public void setPhaseProgress(int progress) {
        this.phaseProgress = Math.max(0, progress);
    }

    public void incrementCurrentPhaseProgress() {
        ++this.phaseProgress;
    }

    public void end() {
        this.ended = true;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public String toString() {
        return "Delivery{sender=" + String.valueOf(this.sender) + ", recipient=" + String.valueOf(this.recipient) + ", mail=" + String.valueOf(this.mail) + ", phase=" + String.valueOf((Object)this.phase) + ", progress=" + this.phaseProgress + "}";
    }
}

