/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.delivery;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.world.delivery.phase.DeliveryPhase;
import net.minecraft.class_3532;

public class DeliveryProgress {
    public static final Codec<DeliveryProgress> CODEC = RecordCodecBuilder.create(i -> i.group((App)DeliveryPhase.CODEC.fieldOf("phase").forGetter(DeliveryProgress::getPhase), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("duration", (Object)1).forGetter(DeliveryProgress::getDuration), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("progress", (Object)0).forGetter(DeliveryProgress::getTicks)).apply((Applicative)i, DeliveryProgress::new));
    private DeliveryPhase phase;
    private int duration;
    private int ticks;

    public DeliveryProgress(DeliveryPhase phase, int duration, int ticks) {
        Preconditions.checkArgument((duration > 0 ? 1 : 0) != 0, (Object)"Duration must be larger than 0.");
        this.phase = phase;
        this.duration = duration;
        this.ticks = ticks;
    }

    public static DeliveryProgress start() {
        return new DeliveryProgress(DeliveryPhase.STARTED, 1, 0);
    }

    public DeliveryPhase getPhase() {
        return this.phase;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getTicks() {
        return this.ticks;
    }

    public double getCompleteness() {
        return class_3532.method_15350((double)((double)this.ticks / (double)this.duration), (double)0.0, (double)1.0);
    }

    public boolean isDone() {
        return this.ticks >= this.duration;
    }

    public void tick() {
        ++this.ticks;
    }

    public void complete() {
        this.ticks = this.duration;
    }

    public void advance(DeliveryPhase nextPhase, int duration) {
        this.phase = nextPhase;
        this.duration = Math.max(1, duration);
        this.ticks = 0;
    }

    public void update(int duration) {
        if (this.duration != (duration = Math.max(1, duration))) {
            this.duration = duration;
            if (this.ticks > 0) {
                double completeness = this.getCompleteness();
                this.ticks = class_3532.method_15340((int)((int)((double)duration * completeness)), (int)0, (int)duration);
            }
        }
    }
}

