/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.delivery;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.util.Ticks;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record TravelDuration(int ticks) {
    public static final Codec<TravelDuration> CODEC = Codec.intRange((int)1, (int)Integer.MAX_VALUE).xmap(TravelDuration::new, TravelDuration::ticks);
    public static final class_9139<ByteBuf, TravelDuration> STREAM_CODEC = class_9135.field_49675.method_56432(TravelDuration::new, TravelDuration::ticks);
    public static final TravelDuration DEFAULT = new TravelDuration(600);

    public TravelDuration {
        Preconditions.checkArgument((ticks > 0 ? 1 : 0) != 0, (Object)"Duration must be larger than 0.");
    }

    public int seconds() {
        return this.ticks / 20;
    }

    public static TravelDuration basedOnDistance(int distanceInBlocks) {
        distanceInBlocks = Math.min(distanceInBlocks, (Integer)Config.Server.DELIVERY_TRAVEL_DURATION_DISTANCE_CAP.get());
        double seconds = (double)distanceInBlocks / (Double)Config.Server.DELIVERY_COURIER_TRAVEL_SPEED.get();
        return new TravelDuration(Math.max(1, (int)Ticks.fromSeconds(seconds)));
    }
}

