/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.delivery.background;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.delivery.background.BackgroundCourier;
import io.github.mortuusars.envelope.world.delivery.background.FinishedBackgroundCourier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class BackgroundDelivery
extends class_18 {
    public static final Codec<BackgroundDelivery> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(BackgroundCourier.CODEC).optionalFieldOf("couriers", Collections.emptyList()).forGetter(BackgroundDelivery::getCouriers), (App)Codec.list(FinishedBackgroundCourier.CODEC).optionalFieldOf("finished_couriers", Collections.emptyList()).forGetter(BackgroundDelivery::getFinishedCouriers)).apply((Applicative)instance, BackgroundDelivery::new));
    protected final List<BackgroundCourier> couriers;
    protected final List<BackgroundCourier> pendingCouriers = new ArrayList<BackgroundCourier>();
    protected final List<FinishedBackgroundCourier> finishedCouriers;

    public BackgroundDelivery(List<BackgroundCourier> couriers, List<FinishedBackgroundCourier> finishedCouriers) {
        this.couriers = new ArrayList<BackgroundCourier>(couriers);
        this.finishedCouriers = new ArrayList<FinishedBackgroundCourier>(finishedCouriers);
    }

    public BackgroundDelivery() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public List<BackgroundCourier> getCouriers() {
        return this.couriers;
    }

    public List<FinishedBackgroundCourier> getFinishedCouriers() {
        return this.finishedCouriers;
    }

    public void addCourier(BackgroundCourier courier) {
        this.pendingCouriers.add(courier);
        this.method_80();
    }

    public void removeCourier(BackgroundCourier courier) {
        if (this.couriers.remove(courier)) {
            this.method_80();
        }
    }

    public void addFinishedCourier(FinishedBackgroundCourier courier) {
        this.finishedCouriers.add(courier);
        this.method_80();
    }

    public void removeFinishedCourier(FinishedBackgroundCourier courier) {
        if (this.finishedCouriers.remove(courier)) {
            this.method_80();
        }
    }

    public void tick(class_3218 level) {
        this.couriers.removeIf(courier -> {
            courier.tick(level);
            boolean ended = courier.getDelivery().isEnded();
            if (ended && courier.getOrigin().isRegular()) {
                FinishedBackgroundCourier finishedCourier = new FinishedBackgroundCourier(courier.getEntityData(), courier.getOrigin().getPos(), courier.getDelivery().getMail());
                this.addFinishedCourier(finishedCourier);
            }
            return ended;
        });
        this.processPendingCouriers();
    }

    protected void processPendingCouriers() {
        this.couriers.addAll(this.pendingCouriers);
        this.pendingCouriers.clear();
    }

    public static BackgroundDelivery get(class_3218 level, String name) {
        return (BackgroundDelivery)level.method_17983().method_17924(BackgroundDelivery.factory(), name);
    }

    public boolean method_79() {
        return !this.couriers.isEmpty() || super.method_79();
    }

    @NotNull
    public class_2487 method_75(class_2487 tag, class_7225.class_7874 registries) {
        this.processPendingCouriers();
        return CODEC.encode((Object)this, (DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).ifError(e -> Envelope.LOGGER.error("Cannot save BackgroundDelivery: {}", (Object)e.message())).result().filter(t -> t instanceof class_2487).map(t -> (class_2487)t).orElse(tag);
    }

    private static BackgroundDelivery load(class_2487 tag, class_7225.class_7874 registries) {
        return CODEC.decode((DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).ifError(e -> Envelope.LOGGER.error("Cannot load BackgroundDelivery: {}", (Object)e.message())).result().map(Pair::getFirst).orElseGet(BackgroundDelivery::new);
    }

    private static class_18.class_8645<BackgroundDelivery> factory() {
        return new class_18.class_8645(BackgroundDelivery::new, BackgroundDelivery::load, null);
    }
}

