/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.delivery.phase;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.class_3542;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;

public enum DeliveryPhase implements class_3542
{
    STARTED("started"),
    DEPARTING_SENDER("departing_sender"),
    TRAVELING_FROM_SENDER_TO_HUB("traveling_from_sender_to_hub"),
    DISPATCHING_DELIVERY("dispatching_delivery"),
    TRAVELING_FROM_HUB_TO_RECIPIENT("traveling_from_hub_to_recipient"),
    APPROACHING_RECIPIENT("approaching_recipient"),
    HANDLING_DELIVERY("handling_delivery"),
    DEPARTING_RECIPIENT("departing_recipient"),
    TRAVELING_FROM_RECIPIENT_TO_HUB("traveling_from_recipient_to_hub"),
    DISPATCHING_RETURN("dispatching_return"),
    TRAVELING_FROM_HUB_TO_SENDER("traveling_from_hub_to_sender"),
    APPROACHING_SENDER("approaching_sender"),
    HANDLING_RETURN("handling_return"),
    FINISHED("finished");

    public static final Codec<DeliveryPhase> CODEC;
    public static final IntFunction<DeliveryPhase> BY_ID;
    public static final class_9139<ByteBuf, DeliveryPhase> STREAM_CODEC;
    private final String name;

    private DeliveryPhase(String name) {
        this.name = name;
    }

    @NotNull
    public String method_15434() {
        return this.name;
    }

    public boolean isTraveling() {
        return this == TRAVELING_FROM_SENDER_TO_HUB || this == DISPATCHING_DELIVERY || this == TRAVELING_FROM_HUB_TO_RECIPIENT || this == TRAVELING_FROM_RECIPIENT_TO_HUB || this == DISPATCHING_RETURN || this == TRAVELING_FROM_HUB_TO_SENDER;
    }

    public boolean isReturning() {
        return this.ordinal() >= DEPARTING_RECIPIENT.ordinal() && this != FINISHED;
    }

    public boolean isAscending() {
        return this == DEPARTING_SENDER || this == DEPARTING_RECIPIENT;
    }

    public boolean isDescending() {
        return this == APPROACHING_RECIPIENT || this == APPROACHING_SENDER;
    }

    public boolean isOnRecipientSide() {
        return this.ordinal() >= TRAVELING_FROM_HUB_TO_RECIPIENT.ordinal() && this.ordinal() <= DEPARTING_RECIPIENT.ordinal();
    }

    public boolean isSpawnable() {
        return !this.isTraveling() && this != FINISHED;
    }

    public boolean isLast() {
        return this.ordinal() == DeliveryPhase.values().length - 1;
    }

    public boolean hasNext() {
        return !this.isLast();
    }

    public DeliveryPhase next() {
        Preconditions.checkState((!this.isLast() ? 1 : 0) != 0, (Object)"There is no next phase.");
        return DeliveryPhase.values()[this.ordinal() + 1];
    }

    public String toPrettyString() {
        return WordUtils.capitalize((String)this.method_15434().replace('_', ' '));
    }

    static {
        CODEC = class_3542.method_28140(DeliveryPhase::values);
        BY_ID = class_7995.method_47914(Enum::ordinal, (Object[])DeliveryPhase.values(), (class_7995.class_7996)class_7995.class_7996.field_41665);
        STREAM_CODEC = class_9135.method_56375(BY_ID, Enum::ordinal);
    }
}

