/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.delivery.route;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.world.Position;
import io.github.mortuusars.envelope.world.delivery.TravelDuration;
import io.github.mortuusars.envelope.world.delivery.phase.DeliveryPhase;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressLocation;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class DeliveryRoute {
    public static final Codec<DeliveryRoute> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2338.field_25064.optionalFieldOf("sender_pos").forGetter(DeliveryRoute::getSenderPos), (App)class_2338.field_25064.optionalFieldOf("sender_ascend_pos").forGetter(DeliveryRoute::getSenderAscendPos), (App)TravelDuration.CODEC.optionalFieldOf("sender_to_hub_duration", (Object)TravelDuration.DEFAULT).forGetter(DeliveryRoute::getSenderToHubDuration), (App)class_2338.field_25064.optionalFieldOf("hub_pos").forGetter(DeliveryRoute::getHubPos), (App)TravelDuration.CODEC.optionalFieldOf("recipient_to_hub_duration", (Object)TravelDuration.DEFAULT).forGetter(DeliveryRoute::getRecipientToHubDuration), (App)class_2338.field_25064.optionalFieldOf("recipient_ascend_pos").forGetter(DeliveryRoute::getRecipientAscendPos), (App)class_2338.field_25064.optionalFieldOf("recipient_pos").forGetter(DeliveryRoute::getRecipientPos)).apply((Applicative)i, DeliveryRoute::new));
    public static final DeliveryRoute EMPTY = new DeliveryRoute(Optional.empty(), Optional.empty(), TravelDuration.DEFAULT, Optional.empty(), TravelDuration.DEFAULT, Optional.empty(), Optional.empty());
    private final Optional<class_2338> senderPos;
    private final Optional<class_2338> senderAscendPos;
    private final TravelDuration senderToHubDuration;
    private final Optional<class_2338> hubPos;
    private final TravelDuration recipientToHubDuration;
    private final Optional<class_2338> recipientAscendPos;
    private final Optional<class_2338> recipientPos;
    @Nullable
    private Map<DeliveryPhase, Segment> segments;

    public DeliveryRoute(Optional<class_2338> senderPos, Optional<class_2338> senderAscendPos, TravelDuration senderToHubDuration, Optional<class_2338> hubPos, TravelDuration recipientToHubDuration, Optional<class_2338> recipientAscendPos, Optional<class_2338> recipientPos) {
        this.senderPos = senderPos;
        this.senderAscendPos = senderAscendPos;
        this.senderToHubDuration = senderToHubDuration;
        this.hubPos = hubPos;
        this.recipientToHubDuration = recipientToHubDuration;
        this.recipientAscendPos = recipientAscendPos;
        this.recipientPos = recipientPos;
    }

    public static DeliveryRoute build(class_3218 level, Address sender, Address recipient) {
        MailService mailService = MailService.of(level);
        AddressLocation senderLocation = mailService.getLocationOf(sender);
        AddressLocation recipientLocation = mailService.getLocationOf(recipient);
        Optional<class_2338> senderPos = senderLocation.getPosition();
        Optional<class_2338> recipientPos = recipientLocation.getPosition();
        Optional<class_2338> hubPos = DeliveryRoute.getHubPosition(senderLocation, recipientLocation);
        return new DeliveryRoute(senderPos, senderLocation.ascendTowards((class_1937)level, hubPos), senderLocation.getTravelDurationTo(hubPos), hubPos, recipientLocation.getTravelDurationTo(hubPos), recipientLocation.ascendTowards((class_1937)level, hubPos), recipientPos);
    }

    public static Optional<class_2338> getHubPosition(AddressLocation senderLocation, AddressLocation recipientLocation) {
        return senderLocation.getNearestHub().or(recipientLocation::getNearestHub);
    }

    public Optional<class_2338> getSenderPos() {
        return this.senderPos;
    }

    public Optional<class_2338> getSenderAscendPos() {
        return this.senderAscendPos;
    }

    public TravelDuration getSenderToHubDuration() {
        return this.senderToHubDuration;
    }

    public Optional<class_2338> getHubPos() {
        return this.hubPos;
    }

    public TravelDuration getRecipientToHubDuration() {
        return this.recipientToHubDuration;
    }

    public Optional<class_2338> getRecipientAscendPos() {
        return this.recipientAscendPos;
    }

    public Optional<class_2338> getRecipientPos() {
        return this.recipientPos;
    }

    public TravelDuration getFullTravelDuration() {
        return new TravelDuration(this.getSenderToHubDuration().ticks() + this.getRecipientToHubDuration().ticks());
    }

    public Optional<Integer> getDistance() {
        return Optional.of(Position.getDistanceBetween(this.senderAscendPos, this.hubPos).orElse(0) + Position.getDistanceBetween(this.hubPos, this.recipientAscendPos).orElse(0));
    }

    public Segment getSegment(DeliveryPhase phase) {
        if (this.segments == null) {
            this.segments = this.buildSegments();
        }
        return Objects.requireNonNull(this.segments.get((Object)phase));
    }

    protected Map<DeliveryPhase, Segment> buildSegments() {
        HashMap<DeliveryPhase, Segment> map = new HashMap<DeliveryPhase, Segment>();
        map.put(DeliveryPhase.STARTED, new Segment(this.senderPos, this.senderPos));
        map.put(DeliveryPhase.DEPARTING_SENDER, new Segment(this.senderPos, this.senderAscendPos));
        map.put(DeliveryPhase.TRAVELING_FROM_SENDER_TO_HUB, new Segment(this.senderAscendPos, this.hubPos));
        map.put(DeliveryPhase.DISPATCHING_DELIVERY, new Segment(this.hubPos, this.hubPos));
        map.put(DeliveryPhase.TRAVELING_FROM_HUB_TO_RECIPIENT, new Segment(this.hubPos, this.recipientAscendPos));
        map.put(DeliveryPhase.APPROACHING_RECIPIENT, new Segment(this.recipientAscendPos, this.recipientPos));
        map.put(DeliveryPhase.HANDLING_DELIVERY, new Segment(this.recipientPos, this.recipientPos));
        map.put(DeliveryPhase.DEPARTING_RECIPIENT, new Segment(this.recipientPos, this.recipientAscendPos));
        map.put(DeliveryPhase.TRAVELING_FROM_RECIPIENT_TO_HUB, new Segment(this.recipientAscendPos, this.hubPos));
        map.put(DeliveryPhase.DISPATCHING_RETURN, new Segment(this.hubPos, this.hubPos));
        map.put(DeliveryPhase.TRAVELING_FROM_HUB_TO_SENDER, new Segment(this.hubPos, this.senderAscendPos));
        map.put(DeliveryPhase.APPROACHING_SENDER, new Segment(this.senderAscendPos, this.senderPos));
        map.put(DeliveryPhase.HANDLING_RETURN, new Segment(this.senderPos, this.senderPos));
        map.put(DeliveryPhase.FINISHED, new Segment(this.senderPos, this.senderPos));
        Preconditions.checkState((map.size() == DeliveryPhase.values().length ? 1 : 0) != 0, (Object)"Built segments do not cover all delivery phases!");
        return map;
    }

    public record Segment(Optional<class_2338> startPos, Optional<class_2338> endPos) {
        public static final Segment EMPTY = new Segment(Optional.empty(), Optional.empty());

        public Optional<class_2338> getCurrentLocation(float progress) {
            if (this.startPos().isPresent() && this.endPos().isPresent()) {
                class_243 pos = Position.lerp(this.startPos().get(), this.endPos().get(), class_3532.method_15363((float)progress, (float)0.0f, (float)1.0f));
                return Optional.of(class_2338.method_49638((class_2374)pos));
            }
            return Optional.empty();
        }
    }
}

