/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.world.Position;
import io.github.mortuusars.envelope.world.block.occupiable.Occupiable;
import io.github.mortuusars.envelope.world.delivery.Courier;
import io.github.mortuusars.envelope.world.delivery.CourierOrigin;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.DeliveryHandler;
import io.github.mortuusars.envelope.world.delivery.TransitionableCourier;
import io.github.mortuusars.envelope.world.entity.PigeonDeliveryHandler;
import io.github.mortuusars.envelope.world.entity.PigeonVariant;
import io.github.mortuusars.envelope.world.entity.SpawnableEntityData;
import io.github.mortuusars.envelope.world.entity.ai.MailboxHandler;
import io.github.mortuusars.envelope.world.entity.ai.PigeonholeHandler;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonAvoidEntityGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonDeliverMailGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonEnterPigeonholeGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonGoToMailboxGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonGoToPigeonholeGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonLocateMailboxGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonLocatePigeonholeGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonPanicGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonSitGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonStartDeliveryFromMailboxGoal;
import io.github.mortuusars.envelope.world.entity.ai.goal.PigeonWanderGoal;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1391;
import net.minecraft.class_1407;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1451;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3701;
import net.minecraft.class_3730;
import net.minecraft.class_4019;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5531;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7988;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Pigeon
extends class_1429
implements class_7988<PigeonVariant>,
class_1432,
TransitionableCourier {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final List<String> IGNORED_TAGS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "SleepingX", "SleepingY", "SleepingZ", "Passengers", "UUID", "leash", "Sitting", "Delivery");
    public static final Predicate<class_1309> AVOID_SELECTOR = entity -> {
        if (entity instanceof class_1451) {
            return (Boolean)Config.Server.PIGEON_HUNTED_BY_CAT.get();
        }
        if (entity instanceof class_3701) {
            return (Boolean)Config.Server.PIGEON_HUNTED_BY_OCELOT.get();
        }
        if (entity instanceof class_4019) {
            return (Boolean)Config.Server.PIGEON_HUNTED_BY_FOX.get();
        }
        return false;
    };
    private static final class_2940<Integer> DATA_VARIANT_ID = class_2945.method_12791(Pigeon.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_DELIVERING = class_2945.method_12791(Pigeon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_HAS_MAIL = class_2945.method_12791(Pigeon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_SERVICE = class_2945.method_12791(Pigeon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_TIRED = class_2945.method_12791(Pigeon.class, (class_2941)class_2943.field_13323);
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    protected float flapping = 1.0f;
    protected float nextFlap = 1.0f;
    protected int tiredTicks;
    protected PigeonholeHandler pigeonholeHandler;
    protected MailboxHandler mailboxHandler;
    protected PigeonDeliveryHandler deliveryHandler;
    @Nullable
    protected Delivery delivery;
    @Nullable
    protected CourierOrigin origin;

    public Pigeon(class_1299<? extends Pigeon> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new class_1331((class_1308)this, 10, false);
        this.pigeonholeHandler = new PigeonholeHandler();
        this.pigeonholeHandler.setRandomWantCooldownUpToDefault(level.method_8409());
        this.mailboxHandler = new MailboxHandler();
        this.deliveryHandler = new PigeonDeliveryHandler(this);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_3, -1.0f);
    }

    public static boolean checkSpawnRules(class_1299<Pigeon> pigeon, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        return (Boolean)Config.Server.PIGEON_SPAWNS_NATURALLY.get() != false && level.method_8320(pos.method_10074()).method_26164(Envelope.Tags.Blocks.PIGEONS_SPAWNABLE_ON) && Pigeon.method_39448((class_1920)level, (class_2338)pos);
    }

    public static Pigeon createService(class_3218 level) {
        Pigeon pigeon = Objects.requireNonNull((Pigeon)Envelope.EntityTypes.PIGEON.get().method_5883((class_1937)level), "Failed to create an entity. This should not happen.");
        pigeon.setVariant(PigeonVariant.getRandomService(level.method_8409()));
        pigeon.setOrigin(CourierOrigin.service());
        return pigeon;
    }

    public static Courier spawnServiceCourier(class_3218 level, Delivery delivery) {
        Pigeon pigeon = Pigeon.createService(level);
        pigeon.startDelivery(delivery);
        return pigeon.transitionToBackground(level);
    }

    @NotNull
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        class_6880 biome = level.method_23753(this.method_24515());
        if (biome.method_40220(Envelope.Tags.Biomes.HAS_PASSENGER_PIGEONS)) {
            this.setVariant(PigeonVariant.getRandomPassengerPriority(this.method_59922()));
        } else {
            this.setVariant(PigeonVariant.getRandomRegular(this.method_59922()));
        }
        return super.method_5943(level, difficulty, spawnType, spawnGroupData);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23720, 1.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23721, 3.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_VARIANT_ID, (Object)0);
        builder.method_56912(DATA_DELIVERING, (Object)false);
        builder.method_56912(DATA_SERVICE, (Object)false);
        builder.method_56912(DATA_HAS_MAIL, (Object)false);
        builder.method_56912(DATA_TIRED, (Object)false);
    }

    @NotNull
    public PigeonVariant getVariant() {
        return PigeonVariant.byId((Integer)this.field_6011.method_12789(DATA_VARIANT_ID));
    }

    public void setVariant(PigeonVariant variant) {
        this.field_6011.method_12778(DATA_VARIANT_ID, (Object)variant.getId());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new PigeonDeliverMailGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, new PigeonAvoidEntityGoal<class_1429>(this, class_1429.class, 8.0f, 1.5, 3.5, AVOID_SELECTOR));
        this.field_6201.method_6277(2, (class_1352)new PigeonPanicGoal((class_1314)this, 3.5));
        this.field_6201.method_6277(2, (class_1352)new PigeonEnterPigeonholeGoal(this));
        this.field_6201.method_6277(3, (class_1352)new PigeonStartDeliveryFromMailboxGoal(this));
        this.field_6201.method_6277(4, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1391((class_1314)this, 1.25, itemStack -> itemStack.method_31573(Envelope.Tags.Items.PIGEON_FOOD), false));
        this.field_6201.method_6277(6, (class_1352)new class_1353((class_1429)this, 1.25));
        this.field_6201.method_6277(7, (class_1352)new PigeonLocatePigeonholeGoal(this));
        this.field_6201.method_6277(7, (class_1352)new PigeonGoToPigeonholeGoal(this));
        this.field_6201.method_6277(7, (class_1352)new PigeonLocateMailboxGoal(this));
        this.field_6201.method_6277(7, (class_1352)new PigeonSitGoal(this));
        this.field_6201.method_6277(8, (class_1352)new PigeonGoToMailboxGoal(this));
        this.field_6201.method_6277(9, (class_1352)new PigeonWanderGoal(this));
        this.field_6201.method_6277(11, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
    }

    @NotNull
    protected class_1407 createNavigation(class_1937 level) {
        class_1407 navigation = new class_1407((class_1308)this, level);
        navigation.method_6332(false);
        navigation.method_6354(true);
        navigation.method_6331(true);
        return navigation;
    }

    public void method_6007() {
        super.method_6007();
        this.calculateFlapping();
        if (this.tiredTicks > 0) {
            this.setTiredTicks(this.tiredTicks - 1);
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                if ((double)this.method_37908().method_8409().method_43057() < 0.1) {
                    serverLevel.method_14199((class_2394)class_2398.field_11251, this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350, 1, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
        if (this.isSitting() && this.method_5942().method_23966()) {
            this.setSitting(false);
        }
        this.getPigeonholeHandler().tick(this, this.method_37908());
        this.getMailboxHandler().tick(this, this.method_37908());
    }

    public void method_5982() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            if (!this.method_5987() && this.isDelivering() && !Position.isInSimulationDistance(level, (class_1297)this)) {
                this.transitionToBackground(level);
                return;
            }
        }
        super.method_5982();
    }

    protected void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (float)(!this.method_24828() && !this.method_5765() ? 4 : -1) * 0.3f;
        this.flapSpeed = class_3532.method_15363((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.method_24828() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        class_243 vec3 = this.method_18798();
        if (!this.method_24828() && vec3.field_1351 < 0.0) {
            float descendRate = this.getDescendRate();
            this.method_18799(vec3.method_18805(1.0, (double)descendRate, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    protected float getDescendRate() {
        if (this.delivery != null) {
            if (this.delivery.getPhase().isDescending()) {
                return 0.9f;
            }
            if (this.delivery.getPhase().isAscending()) {
                return 0.5f;
            }
        }
        return 0.75f;
    }

    protected boolean method_27071() {
        return super.method_27071() && (this.origin == null || !this.origin.isService());
    }

    protected void method_16080(class_3218 level, class_1282 damageSource) {
        super.method_16080(level, damageSource);
        this.getCurrentDelivery().ifPresent(delivery -> this.diedWhileDelivering(level, damageSource, (Delivery)delivery));
    }

    protected void diedWhileDelivering(class_3218 level, class_1282 damageSource, Delivery delivery) {
        String message = damageSource.method_5506((class_1309)this).getString();
        String carriedItem = !delivery.getMail().method_7960() ? " a " + delivery.getMail().method_7964().getString() : "";
        String addresses = delivery.getSender().getName().getString() + " to " + delivery.getRecipient().getName().getString();
        Envelope.LOGGER.info("{} at [{}] while delivering{} from {}!", new Object[]{message, this.method_24515().method_23854(), carriedItem, addresses});
        if (!this.getOrigin().isService()) {
            MailService.of(level).sendCourierDeathNotice((class_1309)this, delivery, damageSource);
        }
        if (!delivery.getMail().method_7960()) {
            class_1799 mail = delivery.getPhase().isOnRecipientSide() ? Mail.asDelivered(delivery.getMail()) : delivery.getMail();
            this.method_5775(mail);
            delivery.setMail(class_1799.field_8037);
        }
    }

    public boolean isSitting() {
        return this.method_18376() == class_4050.field_40118;
    }

    public void setSitting(boolean sitting) {
        this.method_18380(sitting ? class_4050.field_40118 : class_4050.field_18076);
    }

    @Override
    public boolean isDelivering() {
        return (Boolean)this.field_6011.method_12789(DATA_DELIVERING);
    }

    public void setDelivering(boolean delivering) {
        this.field_6011.method_12778(DATA_DELIVERING, (Object)delivering);
    }

    public boolean hasMail() {
        return (Boolean)this.field_6011.method_12789(DATA_HAS_MAIL);
    }

    public void setHasMail(boolean hasMail) {
        this.field_6011.method_12778(DATA_HAS_MAIL, (Object)hasMail);
    }

    public boolean isService() {
        return (Boolean)this.field_6011.method_12789(DATA_SERVICE);
    }

    public void setService(boolean service) {
        this.field_6011.method_12778(DATA_SERVICE, (Object)service);
    }

    public boolean isTired() {
        if (!this.method_37908().field_9236) {
            return this.tiredTicks > 0;
        }
        return (Boolean)this.field_6011.method_12789(DATA_TIRED);
    }

    public int getTiredTicks() {
        return this.tiredTicks;
    }

    public void setTiredTicks(int ticks) {
        class_1937 class_19372;
        if (ticks <= 0 && this.tiredTicks > 0 && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            level.method_14199((class_2394)class_2398.field_11211, this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350, 7, 0.25, 0.25, 0.25, 0.0);
        }
        this.tiredTicks = ticks;
        this.field_6011.method_12778(DATA_TIRED, (Object)(this.tiredTicks > 0 ? 1 : 0));
    }

    public boolean hasMailmanHat() {
        return this.isService();
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 otherParent) {
        @Nullable Pigeon offspring = (Pigeon)Envelope.EntityTypes.PIGEON.get().method_5883((class_1937)level);
        if (offspring != null && otherParent instanceof Pigeon) {
            Pigeon otherPigeon = (Pigeon)otherParent;
            offspring.setVariant(this.method_59922().method_43056() ? this.getVariant() : otherPigeon.getVariant());
        }
        return offspring;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(Envelope.Tags.Items.PIGEON_FOOD);
    }

    protected void method_5623(double y, boolean onGround, class_2680 state, class_2338 pos) {
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_37908().method_8608()) {
            return false;
        }
        if (this.method_29504()) {
            return false;
        }
        if (this.method_59922().method_43058() < (Double)Config.Server.PIGEON_DAMAGE_EVASION_CHANCE_WHILE_DELIVERING.get() && !source.method_48789(Envelope.Tags.DamageTypes.BYPASSES_PIGEON_DELIVERY_EVASION)) {
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 level = (class_3218)class_19372;
                level.method_14199((class_2394)class_2398.field_11203, this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350, 3, 0.3, 0.3, 0.3, 0.0);
                level.method_43129(null, (class_1297)this, class_3417.field_38923, class_3419.field_15254, 1.0f, this.method_59922().method_43057() * 0.1f + 0.95f);
            }
            return false;
        }
        return super.method_5643(source, amount);
    }

    protected boolean method_5776() {
        return this.field_28627 > this.nextFlap;
    }

    protected void method_5801() {
        this.method_5783(Envelope.SoundEvents.PIGEON_FLY.get(), 0.15f, 1.0f);
        this.nextFlap = this.field_28627 + this.flapSpeed / 2.0f;
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    protected float method_49484() {
        return this.method_52546() ? 0.035f : 0.0275f;
    }

    @NotNull
    public class_243 method_29919() {
        return new class_243(0.0, (double)(this.method_5751() * 0.65f), (double)(this.method_17681() * 0.4f));
    }

    public boolean hasReachedTarget(class_2338 pos) {
        return this.hasReachedTarget(pos, 2);
    }

    protected boolean hasReachedTarget(class_2338 pos, int distance) {
        if (this.closerThan(pos, distance)) {
            return true;
        }
        class_11 path = this.method_5942().method_6345();
        return path != null && path.method_48().equals((Object)pos) && path.method_21655() && path.method_46();
    }

    public boolean closerThan(class_2338 pos, int distance) {
        return pos.method_19771((class_2382)this.method_24515(), (double)distance);
    }

    public boolean pathfindDirectlyTowards(class_2338 pos) {
        this.method_5942().method_23964(10.0f);
        this.method_5942().method_58160((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 2, 1.0);
        return this.method_5942().method_6345() != null && this.method_5942().method_6345().method_21655();
    }

    public void pathfindRandomlyTowards(class_2338 pos) {
        class_243 vec32;
        class_243 vec3 = class_243.method_24955((class_2382)pos);
        int i = 0;
        class_2338 blockPos = this.method_24515();
        int j = (int)vec3.field_1351 - blockPos.method_10264();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int m = blockPos.method_19455((class_2382)pos);
        if (m < 15) {
            k = m / 2;
            l = m / 2;
        }
        if ((vec32 = class_5531.method_31508((class_1314)this, (int)k, (int)l, (int)i, (class_243)vec3, (double)0.3141592741012573)) != null) {
            this.field_6189.method_23964(1.0f);
            this.field_6189.method_6337(vec32.field_1352, vec32.field_1351, vec32.field_1350, 1.0);
        }
    }

    @NotNull
    public PigeonholeHandler getPigeonholeHandler() {
        return this.pigeonholeHandler;
    }

    public void setPigeonholeHandler(PigeonholeHandler handler) {
        this.pigeonholeHandler = handler;
    }

    public void releasedFromPigeonhole(class_2338 pos, class_2680 state, Occupiable.ReleaseReason releaseReason) {
        this.getPigeonholeHandler().setTargetPos(pos);
        this.getPigeonholeHandler().setLastReleasePos(pos);
        this.getPigeonholeHandler().setDefaultWantCooldown();
        if (releaseReason == Occupiable.ReleaseReason.EMERGENCY) {
            this.getPigeonholeHandler().setEnterCooldown(200);
        }
        this.getMailboxHandler().setLocateCooldown(this.method_37908().method_8409().method_43051(20, 100));
        if (this.isTired()) {
            this.setTiredTicks(0);
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 level = (class_3218)class_19372;
                level.method_14199((class_2394)class_2398.field_11211, this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350, 5, 0.25, 0.25, 0.25, 0.0);
            }
        }
    }

    public MailboxHandler getMailboxHandler() {
        return this.mailboxHandler;
    }

    public Pigeon setMailboxHandler(MailboxHandler mailboxHandler) {
        this.mailboxHandler = mailboxHandler;
        return this;
    }

    @Nullable
    public class_3414 method_5994() {
        return Envelope.SoundEvents.PIGEON_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return Envelope.SoundEvents.PIGEON_HURT.get();
    }

    protected class_3414 method_6002() {
        return Envelope.SoundEvents.PIGEON_DEATH.get();
    }

    public void method_5783(class_3414 sound, float volume, float pitch) {
        if (!this.method_5701()) {
            this.method_37908().method_43129(null, (class_1297)this, sound, this.method_5634(), volume, pitch);
        }
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(Envelope.SoundEvents.PIGEON_STEP.get(), 0.15f, 1.0f);
    }

    public float method_6017() {
        return Pigeon.getPitch(this.field_5974) + (this.method_6109() ? 0.3f : 0.0f);
    }

    public static float getPitch(class_5819 random) {
        return (random.method_43057() - random.method_43057()) * 0.2f + 1.0f;
    }

    @NotNull
    public class_3419 method_5634() {
        return class_3419.field_15254;
    }

    public boolean method_5810() {
        return true;
    }

    protected void method_6087(class_1297 entity) {
        if (!(entity instanceof class_1657)) {
            super.method_6087(entity);
        }
    }

    @Override
    public DeliveryHandler getDeliveryHandler() {
        return this.deliveryHandler;
    }

    public boolean canStartDelivery() {
        return !this.isTired() && !this.method_37908().method_23886() && !this.method_37908().method_8419() && !this.method_37908().method_8546();
    }

    public Courier startDelivery(Delivery delivery) {
        if (this.delivery != null && this.delivery != delivery) {
            LOGGER.warn("Starting new delivery when pigeon is already delivering. This might be an error.");
        }
        if (this.origin == null || !this.origin.isService()) {
            this.setOrigin(CourierOrigin.regular(this.method_24515()));
        }
        this.method_5848();
        this.setDelivery(delivery);
        return this;
    }

    @Override
    public Optional<Delivery> getCurrentDelivery() {
        return Optional.ofNullable(this.delivery);
    }

    @Override
    public void setDelivery(@Nullable Delivery delivery) {
        if (delivery == null && this.delivery == null) {
            return;
        }
        this.delivery = delivery;
        this.onDeliveryChanged();
    }

    public void onDeliveryChanged() {
        if (!this.method_37908().method_8608()) {
            this.setDelivering(this.getCurrentDelivery().isPresent());
            this.setHasMail(this.delivery != null && !this.delivery.getMail().method_7960());
            Bugger.PIGEON_DELIVERY.send(this.method_5628(), Optional.ofNullable(this.delivery));
        }
    }

    @Override
    @NotNull
    public CourierOrigin getOrigin() {
        if (this.origin == null) {
            LOGGER.warn("Origin of a Pigeon was not set properly. Current position will be used as origin instead.");
            this.origin = CourierOrigin.regular(this.method_24515());
        }
        return this.origin;
    }

    public void setOrigin(@Nullable CourierOrigin origin) {
        this.origin = origin;
        this.setService(origin != null && origin.isService());
    }

    @Override
    public SpawnableEntityData toSpawnableData() {
        return SpawnableEntityData.of((class_1297)this, IGNORED_TAGS);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10566("PigeonholeHandler", (class_2520)PigeonholeHandler.CODEC.encode((Object)this.getPigeonholeHandler(), (DynamicOps)class_2509.field_11560, (Object)tag).getOrThrow());
        tag.method_10566("MailboxHandler", (class_2520)MailboxHandler.CODEC.encode((Object)this.getMailboxHandler(), (DynamicOps)class_2509.field_11560, (Object)tag).getOrThrow());
        tag.method_10569("Variant", this.getVariant().getId());
        if (this.isSitting()) {
            tag.method_10556("Sitting", true);
        }
        if (this.tiredTicks > 0) {
            tag.method_10569("TiredTicks", this.tiredTicks);
        }
        if (this.delivery != null) {
            Delivery.CODEC.encodeStart((DynamicOps)this.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)this.delivery).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(value -> tag.method_10566("Delivery", value));
        }
        if (this.origin != null) {
            CourierOrigin.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.origin).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(value -> tag.method_10566("Origin", value));
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setPigeonholeHandler((PigeonholeHandler)PigeonholeHandler.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10562("PigeonholeHandler")).getOrThrow());
        this.setMailboxHandler((MailboxHandler)MailboxHandler.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10562("MailboxHandler")).getOrThrow());
        this.setVariant(PigeonVariant.byId(tag.method_10550("Variant")));
        this.setSitting(tag.method_10577("Sitting"));
        this.setTiredTicks(tag.method_10550("TiredTicks"));
        if (tag.method_10545("Delivery")) {
            this.setDelivery(Delivery.CODEC.parse((DynamicOps)this.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)tag.method_10562("Delivery")).resultOrPartial(e -> LOGGER.error("Cannot parse Delivery from tag '{}': {}", (Object)tag.method_10562("Delivery"), e)).orElse(null));
        }
        if (tag.method_10545("Origin")) {
            this.setOrigin(CourierOrigin.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10562("Origin")).resultOrPartial(e -> LOGGER.error("Cannot parse CourierOrigin from tag '{}': {}", (Object)tag.method_10562("Origin"), e)).orElse(null));
        }
        this.setDelivering(this.delivery != null);
        this.setHasMail(this.delivery != null && !this.delivery.getMail().method_7960());
    }
}

