/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.world.delivery.CourierOrigin;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.DeliveryHandler;
import io.github.mortuusars.envelope.world.delivery.phase.DeliveryPhase;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryRecord;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class PigeonDeliveryHandler
implements DeliveryHandler {
    private final Pigeon pigeon;

    public PigeonDeliveryHandler(Pigeon pigeon) {
        this.pigeon = pigeon;
    }

    public Pigeon pigeon() {
        return this.pigeon;
    }

    @Override
    public CourierOrigin getOrigin() {
        return this.pigeon.getOrigin();
    }

    @Override
    public int getPhaseDuration(class_3218 level, Delivery delivery, DeliveryPhase phase) {
        return switch (phase) {
            case DeliveryPhase.DEPARTING_SENDER, DeliveryPhase.APPROACHING_RECIPIENT, DeliveryPhase.DEPARTING_RECIPIENT, DeliveryPhase.APPROACHING_SENDER -> 600;
            default -> DeliveryHandler.super.getPhaseDuration(level, delivery, phase);
        };
    }

    @Override
    public void phaseStarted(class_3218 level, Delivery delivery) {
        DeliveryHandler.super.phaseStarted(level, delivery);
        if (delivery.getPhase().isTraveling()) {
            this.pigeon().transitionToBackground(level);
        }
        this.pigeon().onDeliveryChanged();
    }

    @Override
    public boolean handlePhaseTransition(class_3218 level, Delivery delivery) {
        if (delivery.getPhase() == DeliveryPhase.DEPARTING_SENDER && !this.hasReachedSegmentEndPos(delivery)) {
            Mail.writeToLog(delivery.getMail(), DeliveryRecord.returned(DeliveryRecord.Message.UNABLE_TO_REACH));
            delivery.setPhaseAndResetProgress(DeliveryPhase.APPROACHING_SENDER);
            return true;
        }
        if (delivery.getPhase() == DeliveryPhase.APPROACHING_RECIPIENT && !this.hasReachedSegmentEndPos(delivery)) {
            Mail.writeToLog(delivery.getMail(), DeliveryRecord.returned(DeliveryRecord.Message.UNABLE_TO_REACH));
            delivery.setPhaseAndResetProgress(DeliveryPhase.DEPARTING_RECIPIENT);
            return true;
        }
        return DeliveryHandler.super.handlePhaseTransition(level, delivery);
    }

    @Override
    public void endDelivery(class_3218 level, Delivery delivery) {
        if (!delivery.getMail().method_7960()) {
            this.pigeon().method_5775(delivery.getMail().method_7972());
            Pigeon.LOGGER.info("{} has dropped undelivered mail on the ground.", (Object)this.pigeon().method_5477().getString());
            delivery.setMail(class_1799.field_8037);
        }
        this.pigeon().setDelivery(null);
        if (this.pigeon().getOrigin().isService()) {
            this.pigeon().onVanished(level);
            this.pigeon().method_31472();
        } else {
            this.pigeon().setOrigin(null);
            this.pigeon().getPigeonholeHandler().setTargetPos(this.pigeon().getPigeonholeHandler().getLastReleasePos());
            this.pigeon().getPigeonholeHandler().setWantCooldown(20);
            this.pigeon().setTiredTicks((Integer)Config.Server.PIGEON_TIRED_AFTER_DELIVERY_TICKS.get());
        }
    }

    protected boolean hasReachedSegmentEndPos(Delivery delivery) {
        return delivery.getRoute().getSegment(delivery.getPhase()).endPos().map(pos -> this.pigeon().hasReachedTarget((class_2338)pos)).orElse(true);
    }
}

