/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_9279;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public record SpawnableEntityData(class_9279 data) {
    public static final Codec<SpawnableEntityData> CODEC = class_9279.field_49303.validate(data -> {
        if (data.method_57458()) {
            return DataResult.error(() -> "Entity data cannot be empty.");
        }
        return DataResult.success((Object)data);
    }).xmap(SpawnableEntityData::new, SpawnableEntityData::data);
    private static final Logger LOGGER = LogUtils.getLogger();

    public SpawnableEntityData {
        Preconditions.checkArgument((!data.method_57458() ? 1 : 0) != 0, (Object)"Entity data cannot be empty.");
        Preconditions.checkState((!data.method_57463().method_33133() ? 1 : 0) != 0, (Object)"Entity tag cannot be empty.");
        Preconditions.checkState((boolean)data.method_57463().method_10573("id", 8), (Object)("Entity tag does not contain an 'id': " + String.valueOf(data.getClass())));
    }

    public static SpawnableEntityData of(class_1297 entity, List<String> ignoredTags) {
        Preconditions.checkArgument((!entity.method_5765() && !entity.method_31481() && entity.method_5864().method_5893() ? 1 : 0) != 0, (Object)("Cannot create SpawnableEntityData: entity '" + String.valueOf(entity) + "' is passenger, removed or the type is not serializable."));
        class_2487 tag = new class_2487();
        if (!entity.method_5662(tag)) {
            LOGGER.error("Failed to save entity '{}' to a tag. Entity is passenger, about to be removed or entity type is not serializable.", (Object)entity);
        }
        ignoredTags.forEach(arg_0 -> ((class_2487)tag).method_10551(arg_0));
        return new SpawnableEntityData(class_9279.method_57456((class_2487)tag));
    }

    @Nullable
    public class_1297 createEntity(class_3218 level) {
        return class_1299.method_17842((class_2487)this.data.method_57463(), (class_1937)level, Function.identity());
    }
}

