/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.ai;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlockEntity;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class MailboxHandler {
    public static final int MAX_BLACKLISTED_TARGETS = 3;
    public static final int DEFAULT_LOCATE_COOLDOWN = 100;
    public static final Codec<MailboxHandler> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2338.field_25064.optionalFieldOf("target_pos").forGetter(o -> Optional.ofNullable(o.getTargetPos())), (App)Codec.INT.optionalFieldOf("locate_cooldown", (Object)0).forGetter(MailboxHandler::getLocateCooldown)).apply((Applicative)i, MailboxHandler::new));
    protected final List<class_2338> blacklistedPositions = new ArrayList<class_2338>();
    @Nullable
    protected class_2338 targetPos;
    protected int locateCooldown;

    public MailboxHandler(Optional<class_2338> targetPos, int locateCooldown) {
        this.targetPos = targetPos.orElse(null);
        this.locateCooldown = locateCooldown;
    }

    public MailboxHandler() {
        this(Optional.empty(), 0);
    }

    @Nullable
    public class_2338 getTargetPos() {
        return this.targetPos;
    }

    public void setTargetPos(@Nullable class_2338 targetPos) {
        this.targetPos = targetPos;
    }

    public int getLocateCooldown() {
        return this.locateCooldown;
    }

    public void setLocateCooldown(int cooldown) {
        this.locateCooldown = cooldown;
    }

    public void resetLocateCooldown() {
        this.setLocateCooldown(100);
    }

    public void tick(Pigeon pigeon, class_1937 level) {
        if (this.locateCooldown > 0) {
            --this.locateCooldown;
        }
        if (level instanceof class_3218 && pigeon.field_6012 % 20 == 0) {
            if (!this.isMailboxValid(level, pigeon.method_24515())) {
                this.setTargetPos(null);
            }
            Bugger.PIGEON_MAILBOX_HANDLER.send(pigeon.method_5628(), this);
        }
    }

    public boolean canStartDelivery(Pigeon pigeon) {
        return !pigeon.isTired();
    }

    public Optional<MailboxBlockEntity> getMailboxAtCurrentPos(class_1937 level) {
        class_2586 class_25862;
        @Nullable class_2338 pos = this.getTargetPos();
        if (pos != null && level.method_8477(pos) && (class_25862 = level.method_8321(pos)) instanceof MailboxBlockEntity) {
            MailboxBlockEntity be = (MailboxBlockEntity)class_25862;
            return Optional.of(be);
        }
        return Optional.empty();
    }

    public boolean isMailboxValid(class_1937 level, class_2338 entityPos) {
        MailboxBlockEntity blockEntity;
        @Nullable class_2338 currentPos = this.getTargetPos();
        if (currentPos == null) {
            return false;
        }
        if (!entityPos.method_19771((class_2382)currentPos, 32.0)) {
            return false;
        }
        class_2586 class_25862 = level.method_8321(currentPos);
        return class_25862 instanceof MailboxBlockEntity && (blockEntity = (MailboxBlockEntity)class_25862).isAvailableForPickup();
    }

    public boolean isTargetBlacklisted(class_2338 pos) {
        return this.blacklistedPositions.contains(pos);
    }

    private void blacklistTarget(class_2338 pos) {
        this.blacklistedPositions.add(pos);
        while (this.blacklistedPositions.size() > 3) {
            this.blacklistedPositions.removeFirst();
        }
    }

    public void clearBlacklist() {
        this.blacklistedPositions.clear();
    }

    public void dropAndBlacklistMailbox() {
        if (this.getTargetPos() != null) {
            this.blacklistTarget(this.getTargetPos());
        }
        this.dropMailbox();
    }

    public void dropMailbox() {
        this.setTargetPos(null);
        this.resetLocateCooldown();
    }

    public String toString() {
        return "MailboxHandler{, targetPos=" + String.valueOf(this.targetPos) + ", locateCooldown=" + this.locateCooldown + "}";
    }
}

