/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.ai;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.world.block.PigeonholeBlockEntity;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class PigeonholeHandler {
    public static final int MAX_BLACKLISTED_TARGETS = 3;
    public static final int DEFAULT_LOCATE_COOLDOWN = 200;
    public static final Codec<PigeonholeHandler> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2338.field_25064.optionalFieldOf("current_pos").forGetter(o -> Optional.ofNullable(o.getTargetPos())), (App)class_2338.field_25064.optionalFieldOf("last_release_pos").forGetter(o -> Optional.ofNullable(o.getLastReleasePos())), (App)Codec.INT.optionalFieldOf("locate_cooldown", (Object)0).forGetter(PigeonholeHandler::getLocateCooldown), (App)Codec.INT.optionalFieldOf("want_cooldown", (Object)0).forGetter(PigeonholeHandler::getWantCooldown), (App)Codec.INT.optionalFieldOf("enter_cooldown", (Object)0).forGetter(PigeonholeHandler::getEnterCooldown)).apply((Applicative)i, PigeonholeHandler::new));
    protected final List<class_2338> blacklistedPositions = new ArrayList<class_2338>();
    @Nullable
    protected class_2338 targetPos;
    @Nullable
    protected class_2338 lastReleasePos;
    protected int locateCooldown;
    protected int wantCooldown;
    protected int enterCooldown;

    public PigeonholeHandler(Optional<class_2338> targetPos, Optional<class_2338> lastReleasePos, int locateCooldown, int wantCooldown, int enterCooldown) {
        this.targetPos = targetPos.orElse(null);
        this.lastReleasePos = lastReleasePos.orElse(null);
        this.locateCooldown = locateCooldown;
        this.wantCooldown = wantCooldown;
        this.enterCooldown = enterCooldown;
    }

    public PigeonholeHandler() {
        this(Optional.empty(), Optional.empty(), 0, 0, 0);
    }

    @Nullable
    public class_2338 getTargetPos() {
        return this.targetPos;
    }

    public void setTargetPos(@Nullable class_2338 targetPos) {
        this.targetPos = targetPos;
    }

    @Nullable
    public class_2338 getLastReleasePos() {
        return this.lastReleasePos;
    }

    public PigeonholeHandler setLastReleasePos(@Nullable class_2338 lastReleasePos) {
        this.lastReleasePos = lastReleasePos;
        return this;
    }

    public int getEnterCooldown() {
        return this.enterCooldown;
    }

    public void setEnterCooldown(int cooldown) {
        this.enterCooldown = cooldown;
    }

    public int getWantCooldown() {
        return this.wantCooldown;
    }

    public void setWantCooldown(int cooldown) {
        this.wantCooldown = cooldown;
    }

    public void setDefaultWantCooldown() {
        this.setWantCooldown((Integer)Config.Server.PIGEON_MIN_TICKS_OUTSIDE_PIGEONHOLE.get());
    }

    public void setRandomWantCooldownUpToDefault(class_5819 random) {
        this.setWantCooldown(random.method_43048(((Integer)Config.Server.PIGEON_MIN_TICKS_OUTSIDE_PIGEONHOLE.get()).intValue()));
    }

    public int getLocateCooldown() {
        return this.locateCooldown;
    }

    public void setLocateCooldown(int cooldown) {
        this.locateCooldown = cooldown;
    }

    public void resetLocateCooldown() {
        this.setLocateCooldown(200);
    }

    public void tick(Pigeon pigeon, class_1937 level) {
        if (this.wantCooldown > 0) {
            --this.wantCooldown;
        }
        if (this.locateCooldown > 0) {
            --this.locateCooldown;
        }
        if (level instanceof class_3218 && pigeon.field_6012 % 20 == 0) {
            if (!this.isPigeonholeValid(level, pigeon.method_24515())) {
                this.setTargetPos(null);
            }
            Bugger.PIGEON_PIGEONHOLE_HANDLER.send(pigeon.method_5628(), this);
        }
    }

    public Optional<PigeonholeBlockEntity> getPigeonholeAtCurrentPos(class_1937 level) {
        class_2586 class_25862;
        @Nullable class_2338 pos = this.getTargetPos();
        if (pos != null && level.method_8477(pos) && (class_25862 = level.method_8321(pos)) instanceof PigeonholeBlockEntity) {
            PigeonholeBlockEntity be = (PigeonholeBlockEntity)class_25862;
            return Optional.of(be);
        }
        return Optional.empty();
    }

    public boolean wantsToEnterPigeonhole(Pigeon pigeon) {
        if (this.getEnterCooldown() > 0) {
            return false;
        }
        class_1937 level = pigeon.method_37908();
        boolean wouldPreferInside = level.method_23886() || level.method_8419() || level.method_8546();
        boolean tiredOfOutside = pigeon.isTired() || this.getWantCooldown() <= 0;
        return wouldPreferInside || tiredOfOutside;
    }

    public boolean isPigeonholeValid(class_1937 level, class_2338 entityPos) {
        @Nullable class_2338 currentPos = this.getTargetPos();
        if (currentPos == null) {
            return false;
        }
        if (!entityPos.method_19771((class_2382)currentPos, 32.0)) {
            return false;
        }
        return level.method_8321(currentPos) instanceof PigeonholeBlockEntity;
    }

    public boolean isTargetBlacklisted(class_2338 pos) {
        return this.blacklistedPositions.contains(pos);
    }

    private void blacklistTarget(class_2338 pos) {
        this.blacklistedPositions.add(pos);
        while (this.blacklistedPositions.size() > 3) {
            this.blacklistedPositions.removeFirst();
        }
    }

    public void clearBlacklist() {
        this.blacklistedPositions.clear();
    }

    public void dropAndBlacklistPigeonhole() {
        if (this.getTargetPos() != null) {
            this.blacklistTarget(this.getTargetPos());
        }
        this.dropPigeonhole();
    }

    public void dropPigeonhole() {
        this.setTargetPos(null);
        this.resetLocateCooldown();
    }

    public String toString() {
        return "PigeonholeHandler{currentPos=" + String.valueOf(this.targetPos) + ", lastReleasePos=" + String.valueOf(this.lastReleasePos) + ", locateCooldown=" + this.locateCooldown + ", wantCooldown=" + this.wantCooldown + ", enterCooldown=" + this.enterCooldown + "}";
    }
}

