/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.entity.spawner;

import io.github.mortuusars.envelope.world.Position;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.TransitionableCourier;
import io.github.mortuusars.envelope.world.delivery.background.BackgroundCourier;
import io.github.mortuusars.envelope.world.delivery.background.BackgroundDelivery;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5304;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class BackgroundCourierSpawner
implements class_5304 {
    public int method_6445(class_3218 level, boolean spawnEnemies, boolean spawnFriendlies) {
        BackgroundDelivery backgroundDelivery = MailService.of(level).getBackgroundDelivery();
        List<BackgroundCourier> spawnableCouriers = backgroundDelivery.getCouriers().stream().filter(this::canSpawn).toList();
        if (spawnableCouriers.isEmpty()) {
            return 0;
        }
        BackgroundCourier courier = (BackgroundCourier)class_156.method_32309(spawnableCouriers, (class_5819)level.method_8409());
        this.trySpawn(level, courier);
        return 0;
    }

    private boolean canSpawn(BackgroundCourier courier) {
        if (courier.getOrigin().isService() && courier.getDelivery().getMail().method_7960() && !courier.getDelivery().getPhase().isOnRecipientSide()) {
            return false;
        }
        return courier.getDelivery().getPhase().isSpawnable();
    }

    protected void trySpawn(class_3218 level, BackgroundCourier backgroundCourier) {
        Delivery delivery = backgroundCourier.getDelivery();
        int duration = backgroundCourier.getPhaseDuration(level, delivery, delivery.getPhase());
        int progress = delivery.getPhaseProgress();
        float completeness = class_3532.method_15363((float)((float)progress / (float)duration), (float)0.0f, (float)1.0f);
        delivery.getRoute().getSegment(delivery.getPhase()).getCurrentLocation(completeness).filter(arg_0 -> ((class_3218)level).method_8477(arg_0)).map(pos -> Position.aboveGround((class_1937)level, pos, 2)).filter(pos -> Position.isInSimulationDistance(level, pos)).ifPresent(pos -> {
            @Nullable class_1297 entity = backgroundCourier.getEntityData().createEntity(level);
            if (entity instanceof TransitionableCourier) {
                TransitionableCourier courier = (TransitionableCourier)entity;
                entity.method_5725(pos, entity.method_36454(), entity.method_36455());
                level.method_30771(entity);
                courier.onAppeared(level);
                courier.setDelivery(delivery);
                MailService.of(level).getBackgroundDelivery().removeCourier(backgroundCourier);
            }
        });
    }
}

