/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.inventory;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.clientbound.MailboxMenuMailRemovedS2CP;
import io.github.mortuusars.envelope.network.packet.clientbound.MailboxMenuSetMailS2CP;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlockEntity;
import io.github.mortuusars.envelope.world.inventory.PlayerInventoryUtil;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_7995;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MailboxMenu
extends class_1703 {
    public static final int ADDRESS_BUTTON_ID = 0;
    public static final int REFRESH_MAIL_BUTTON_ID = 1;
    protected final class_3915 hasDefault = class_3915.method_17403();
    protected final class_3915 isDefault = class_3915.method_17403();
    protected final class_1661 playerInventory;
    protected final class_1657 player;
    protected final class_2338 pos;
    protected final Address.Block address;
    protected final MailboxBlockEntity blockEntity;
    protected List<class_1799> mail;
    protected boolean hasNewMail;

    protected MailboxMenu(@Nullable class_3917<?> menuType, int id, class_1661 playerInventory, class_2338 pos, Address.Block address, List<class_1799> mail) {
        super(menuType, id);
        this.playerInventory = playerInventory;
        this.player = playerInventory.field_7546;
        this.pos = pos;
        this.address = address;
        class_2586 class_25862 = playerInventory.field_7546.method_37908().method_8321(pos);
        if (!(class_25862 instanceof MailboxBlockEntity)) {
            throw new IllegalStateException("MailboxBlockEntity is not available at " + String.valueOf(pos));
        }
        final MailboxBlockEntity be = (MailboxBlockEntity)class_25862;
        this.blockEntity = be;
        this.setMail(mail);
        this.method_7621(new class_1735(this, (class_1263)be, 0, 201, 37){

            public boolean method_7680(class_1799 stack) {
                return be.method_5437(0, stack);
            }
        });
        this.method_7621(new class_1735(this, (class_1263)be, 1, 222, 37){

            public boolean method_7680(class_1799 stack) {
                return be.method_5437(1, stack);
            }
        });
        this.addPlayerSlots(playerInventory, 140, 88);
        this.method_17362(this.hasDefault);
        this.method_17362(this.isDefault);
        this.updateHasDefault();
        this.updateIsDefault();
    }

    public MailboxMenu(int id, class_1661 playerInventory, class_2338 pos, Address.Block address, List<class_1799> mail) {
        this(Envelope.MenuTypes.PIGEONHOLE.get(), id, playerInventory, pos, address, mail);
    }

    public static MailboxMenu fromNetwork(int id, class_1661 inventory, class_9129 buffer) {
        class_2338 mailboxPos = buffer.method_10811();
        Address.Block address = (Address.Block)Address.Block.STREAM_CODEC.decode((Object)buffer);
        List mail = (List)class_1799.field_48350.decode((Object)buffer);
        return new MailboxMenu(id, inventory, mailboxPos, address, mail);
    }

    public boolean method_7597(class_1657 player) {
        return this.getBlockEntity().method_5443(player) && this.getBlockEntity().getAddress().equals(this.address);
    }

    public class_2338 getBlockPosition() {
        return this.pos;
    }

    public MailboxBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public Address getAddress() {
        return this.address;
    }

    public boolean hasDefaultAddress() {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            return serverPlayer.method_51469().getEnvelopeMailService().getPlayers().getDefaultAddressOf(this.player).isPresent();
        }
        return this.hasDefault.method_17407() == 1;
    }

    protected void updateHasDefault() {
        if (this.player instanceof class_3222) {
            this.hasDefault.method_17404(this.hasDefaultAddress() ? 1 : 0);
        }
    }

    public boolean isDefaultAddress() {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            return serverPlayer.method_51469().getEnvelopeMailService().getPlayers().getDefaultAddressOf(this.player).map(this.address::equals).orElse(false);
        }
        return this.isDefault.method_17407() == 1;
    }

    protected void updateIsDefault() {
        if (this.player instanceof class_3222) {
            this.isDefault.method_17404(this.isDefaultAddress() ? 1 : 0);
        }
    }

    public List<class_1799> getMail() {
        return this.mail;
    }

    public void setMail(List<class_1799> mail) {
        this.mail = new ArrayList<class_1799>(mail.reversed());
        this.setHasNewMail(false);
    }

    public boolean hasNewMail() {
        return this.hasNewMail;
    }

    public void setHasNewMail(boolean hasNewMail) {
        this.hasNewMail = hasNewMail;
    }

    protected void addPlayerSlots(class_1661 playerInventory, int x, int y) {
        for (int slot = 0; slot < 9; ++slot) {
            this.method_7621(new class_1735((class_1263)playerInventory, slot, x + slot * 18, y + 58));
        }
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.method_7621(new class_1735((class_1263)playerInventory, column + row * 9 + 9, x + column * 18, y + row * 18));
            }
        }
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int index) {
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (!slot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 clickedStack = slot.method_7677();
        class_1799 returnedStack = clickedStack.method_7972();
        if (index < 2 ? !this.method_7616(clickedStack, 2, this.field_7761.size(), true) : index < this.field_7761.size() && !this.method_7616(clickedStack, 0, 2, false)) {
            return class_1799.field_8037;
        }
        if (clickedStack.method_7960()) {
            slot.method_7673(class_1799.field_8037);
        } else {
            slot.method_7668();
        }
        return returnedStack;
    }

    public boolean doMailAction(class_1657 player, int index, MailAction action) {
        if (index < 0 || index >= this.getMail().size()) {
            return false;
        }
        return switch (action.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.pickUpMail(player, index);
            case 1 -> this.moveMailToInventory(player, index);
            case 2 -> this.moveAllMailToInventory(player);
        };
    }

    protected boolean pickUpMail(class_1657 player, int index) {
        if (!this.method_34255().method_7960()) {
            return false;
        }
        class_1937 class_19372 = player.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.method_34254(this.extractMail(serverLevel, index));
        }
        return true;
    }

    protected boolean moveMailToInventory(class_1657 player, int index) {
        class_3218 serverLevel;
        class_1799 taken;
        class_1799 mail = this.getMail().get(index).method_7972();
        if (!PlayerInventoryUtil.canAddWholeStack(player, mail)) {
            return false;
        }
        class_1937 class_19372 = player.method_37908();
        if (class_19372 instanceof class_3218 && !(taken = this.extractMail(serverLevel = (class_3218)class_19372, index)).method_7960()) {
            player.method_31548().method_7394(taken);
        }
        return true;
    }

    protected boolean moveAllMailToInventory(class_1657 player) {
        boolean movedSomething = false;
        while (!this.getMail().isEmpty()) {
            if (!this.moveMailToInventory(player, 0)) {
                return movedSomething;
            }
            movedSomething = true;
        }
        return true;
    }

    protected class_1799 extractMail(class_3218 level, int index) {
        return Optional.ofNullable(Mail.getId(this.getMail().get(index))).map(id -> this.getBlockEntity().removeMail((Id)id)).orElse(class_1799.field_8037);
    }

    public boolean method_7604(class_1657 player, int id) {
        if (id == 0 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.method_51469().getEnvelopeMailService().getPlayers().setDefaultAddress(player, this.address);
            this.updateHasDefault();
            this.updateIsDefault();
            return true;
        }
        if (id == 1 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            List<class_1799> mail = this.getBlockEntity().getAllMail();
            this.setMail(mail);
            Packets.sendToClient(new MailboxMenuSetMailS2CP(mail), serverPlayer);
            return true;
        }
        return false;
    }

    public static List<class_3222> playersWithMenu(class_3218 level, @Nullable Address.Block address) {
        return level.method_18456().stream().filter(pl -> {
            MailboxMenu menu;
            class_1703 patt0$temp = pl.field_7512;
            return patt0$temp instanceof MailboxMenu && (menu = (MailboxMenu)patt0$temp).getAddress().equals(address);
        }).toList();
    }

    public static void executeForPlayersWithMenu(class_3218 level, @Nullable Address.Block address, BiConsumer<class_3222, MailboxMenu> action) {
        MailboxMenu.playersWithMenu(level, address).forEach(pl -> action.accept((class_3222)pl, (MailboxMenu)pl.field_7512));
    }

    public void onMailRemoved(Id id) {
        this.getMail().removeIf(m -> id.equals(Mail.getId(m)));
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            Packets.sendToClient(new MailboxMenuMailRemovedS2CP(id), serverPlayer);
        }
    }

    public static enum MailAction {
        PICK_UP,
        MOVE_TO_INVENTORY,
        MOVE_ALL_TO_INVENTORY;

        public static final class_9139<ByteBuf, MailAction> STREAM_CODEC;

        static {
            STREAM_CODEC = class_9135.method_56375((IntFunction)class_7995.method_47914(Enum::ordinal, (Object[])MailAction.values(), (class_7995.class_7996)class_7995.class_7996.field_41664), Enum::ordinal);
        }
    }
}

