/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.inventory;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.inventory.slot.DisabledSlot;
import io.github.mortuusars.envelope.world.item.PackingBox;
import io.github.mortuusars.envelope.world.item.component.PackageContents;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import java.util.ArrayList;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackingMenu
extends class_1703 {
    public static final int PACK_BUTTON_ID = 0;
    private final class_1657 player;
    private final class_1268 hand;
    private final int packageSlot;
    private final class_1799 packageStack;
    private final PackingBox packingBox;
    private final PackageContents initialPackageContents;
    private final boolean canPack;
    private final class_1277 packageContainer;
    protected boolean packed = false;

    protected PackingMenu(@Nullable class_3917<?> menuType, int containerId, class_1661 playerInventory, class_1268 hand) {
        super(menuType, containerId);
        this.player = playerInventory.field_7546;
        this.hand = hand;
        this.packageSlot = hand == class_1268.field_5810 ? 40 : playerInventory.field_7545;
        this.packageStack = playerInventory.method_5438(this.packageSlot);
        this.packingBox = (PackingBox)this.packageStack.method_7909();
        this.initialPackageContents = PackageContents.from(this.packageStack);
        this.canPack = this.packingBox.canPack(this.packageStack);
        this.packageContainer = this.createPackageContainer();
        this.init();
    }

    public PackingMenu(int containerId, class_1661 playerInventory, class_1268 hand) {
        this(Envelope.MenuTypes.PACKAGE.get(), containerId, playerInventory, hand);
    }

    public static PackingMenu fromNetwork(int id, class_1661 inventory, class_9129 buffer) {
        return new PackingMenu(id, inventory, (class_1268)buffer.method_10818(class_1268.class));
    }

    protected void init() {
        this.addPackageSlots();
        this.addPlayerSlots((class_1263)this.player.method_31548(), 8, 96, this.packageSlot);
    }

    @NotNull
    protected class_1277 createPackageContainer() {
        ArrayList<class_1799> items = new ArrayList<class_1799>(PackageContents.from(this.packageStack).copyItems());
        while (items.size() < 6) {
            items.add(class_1799.field_8037);
        }
        class_1277 packageContainer = new class_1277((class_1799[])items.toArray(class_1799[]::new));
        return packageContainer;
    }

    protected void addPackageSlots() {
        int packageSlotsX = 62;
        int packageSlotsY = 33;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 3; ++column) {
                int index = column + row * 3;
                int x = packageSlotsX + column * 18;
                int y = packageSlotsY + row * 18;
                this.method_7621(new class_1735((class_1263)this.packageContainer, index, x, y){

                    public boolean method_7680(class_1799 stack) {
                        return PackingMenu.this.getPackage().canInsert(stack);
                    }
                });
            }
        }
    }

    protected void addPlayerSlots(class_1263 inventory, int x, int y, int packageSlot) {
        for (int index = 0; index < 9; ++index) {
            int slotX = x + index * 18;
            int slotY = y + 58;
            this.method_7621(index == packageSlot ? new DisabledSlot(inventory, index, slotX, slotY) : new class_1735(inventory, index, slotX, slotY));
        }
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = column + row * 9 + 9;
                int slotX = x + column * 18;
                int slotY = y + row * 18;
                this.method_7621(index == packageSlot ? new DisabledSlot(inventory, index, slotX, slotY) : new class_1735(inventory, index, slotX, slotY));
            }
        }
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    public class_1268 getHand() {
        return this.hand;
    }

    public int getPackageSlot() {
        return this.packageSlot;
    }

    public class_1799 getBoxStack() {
        return this.packageStack;
    }

    public PackingBox getPackage() {
        return this.packingBox;
    }

    public PackageContents getInitialPackageContents() {
        return this.initialPackageContents;
    }

    @NotNull
    protected PackageContents getPackageContentsFromItem() {
        return PackageContents.from(this.getBoxStack());
    }

    public boolean canPack() {
        return this.canPack;
    }

    public class_1277 getPackageContainer() {
        return this.packageContainer;
    }

    public boolean needsPacking() {
        if (this.packed) {
            return false;
        }
        PackageContents contents = PackageContents.createFrom((class_1263)this.packageContainer);
        return !contents.isEmpty();
    }

    public boolean isContainerEmpty() {
        return this.packageContainer.method_5442();
    }

    public boolean isPackageDestroyedOnClose() {
        return !this.canPack && (this.needsPacking() || this.isContainerEmpty());
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int index) {
        class_1735 slot = (class_1735)this.field_7761.get(index);
        class_1799 clickedStack = slot.method_7677();
        if (index < 6 ? !this.method_7616(clickedStack, 6, this.field_7761.size(), true) : index < this.field_7761.size() && !this.method_7616(clickedStack, 0, 6, false)) {
            return class_1799.field_8037;
        }
        this.packageContainer.method_5431();
        return class_1799.field_8037;
    }

    public boolean method_7604(@NotNull class_1657 player, int buttonId) {
        if (buttonId == 0 && this.canPack()) {
            this.pack(player);
            return true;
        }
        return false;
    }

    protected void pack(@NotNull class_1657 player) {
        class_1799 stack = this.createPackingResult();
        stack.method_57379(Envelope.DataComponents.PACKAGE_CONTENTS, (Object)PackageContents.createFrom((class_1263)this.packageContainer));
        stack.method_57379(Envelope.DataComponents.PACKAGE_TIMES_PACKED, (Object)((Integer)stack.method_57825(Envelope.DataComponents.PACKAGE_TIMES_PACKED, (Object)0) + 1));
        player.method_6122(this.getHand(), stack);
        player.method_37908().method_43129(null, (class_1297)player, (class_3414)class_3417.field_14883.comp_349(), class_3419.field_15248, 1.0f, player.method_37908().method_8409().method_43057() * 0.3f + 0.85f);
        this.packed = true;
    }

    protected class_1799 createPackingResult() {
        class_1799 stack = this.getBoxStack().method_60503((class_1935)Envelope.Items.PACKAGE.get());
        Mail.removePreviousDeliveryData(stack);
        return stack;
    }

    public void method_7595(@NotNull class_1657 player) {
        if (!this.packed && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            for (class_1799 stack : PackageContents.createFrom((class_1263)this.packageContainer).copyItems()) {
                player.method_7328(stack, true);
            }
            this.getBoxStack().method_57381(Envelope.DataComponents.PACKAGE_CONTENTS);
            if (this.getPackage().shouldBeDestroyedWhenEmpty(this.getBoxStack())) {
                player.method_5998(this.hand).method_7934(1);
                serverPlayer.method_51469().method_43129(null, (class_1297)serverPlayer, class_3417.field_15075, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
        super.method_7595(player);
    }

    public boolean method_7597(class_1657 player) {
        return player.method_5998(this.hand).method_7909() instanceof PackingBox;
    }
}

