/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.inventory;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.inventory.PackingMenu;
import io.github.mortuusars.envelope.world.inventory.RequestedItem;
import io.github.mortuusars.envelope.world.inventory.slot.DisabledSlot;
import io.github.mortuusars.envelope.world.inventory.slot.PreviewSlot;
import io.github.mortuusars.envelope.world.inventory.slot.RequestedItemSlot;
import io.github.mortuusars.envelope.world.item.component.RequestedPayback;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.mail.entity.mail_service.payback_department.PaybackSubject;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3917;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;

public class PaybackPackingMenu
extends PackingMenu {
    protected RequestedPayback requestedPayback;
    protected class_1799 paybackSubject;

    protected PaybackPackingMenu(@Nullable class_3917<?> menuType, int containerId, class_1661 playerInventory, class_1268 hand) {
        super(menuType, containerId, playerInventory, hand);
    }

    public PaybackPackingMenu(int containerId, class_1661 playerInventory, class_1268 hand) {
        this(Envelope.MenuTypes.PAYBACK_PACKAGE.get(), containerId, playerInventory, hand);
    }

    public static PaybackPackingMenu fromNetwork(int id, class_1661 inventory, class_9129 buffer) {
        return new PaybackPackingMenu(id, inventory, (class_1268)buffer.method_10818(class_1268.class));
    }

    @Override
    protected void init() {
        this.paybackSubject = Optional.ofNullable((PaybackSubject)this.getBoxStack().method_57824(Envelope.DataComponents.PAYBACK_SUBJECT)).map(PaybackSubject::mail).orElse(class_1799.field_8037);
        this.requestedPayback = Objects.requireNonNull((RequestedPayback)this.paybackSubject.method_57824(Envelope.DataComponents.MAIL_REQUESTED_PAYBACK));
        super.init();
        this.method_7621(new PreviewSlot(this.paybackSubject, 0, 21, 42));
    }

    @Override
    protected void addPackageSlots() {
        int packageSlotsX = 62;
        int packageSlotsY = 33;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 3; ++column) {
                int index = column + row * 3;
                int x = packageSlotsX + column * 18;
                int y = packageSlotsY + row * 18;
                class_1735 slot = this.getPayback().getRequestedItem(index).map(requestedItem -> new RequestedItemSlot((class_1263)this.getPackageContainer(), index, x, y, (RequestedItem)requestedItem)).orElseGet(() -> new DisabledSlot((class_1263)this.getPackageContainer(), index, x, y));
                this.method_7621(slot);
            }
        }
    }

    public RequestedPayback getPayback() {
        return this.requestedPayback;
    }

    public class_1799 getPaybackSubject() {
        return this.paybackSubject;
    }

    @Override
    public boolean canPack() {
        return super.canPack() && this.getPayback().matches((class_1263)this.getPackageContainer());
    }

    @Override
    protected class_1799 createPackingResult() {
        class_1799 stack = this.getBoxStack().method_60503((class_1935)Envelope.Items.PAYBACK_PACKAGE.get());
        Mail.setRecipient(stack, Mail.getSenderOrUnknown(this.paybackSubject));
        Mail.setSender(stack, null);
        return stack;
    }
}

