/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.inventory;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.util.ItemAndStack;
import io.github.mortuusars.envelope.world.inventory.slot.DisabledSlot;
import io.github.mortuusars.envelope.world.inventory.slot.FilteredSlot;
import io.github.mortuusars.envelope.world.item.PaybackTagItem;
import io.github.mortuusars.envelope.world.item.component.PaybackTagContents;
import io.github.mortuusars.envelope.world.item.component.RequestedPayback;
import java.util.ArrayList;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaybackTagMenu
extends class_1703 {
    public static final int CONFIRM_BUTTON_ID = 0;
    public static final int COUNT_START_BUTTON_ID = 100;
    public static final int INCREASE_COUNT_START_BUTTON_ID = 100;
    public static final int INCREASE_COUNT_FAST_START_BUTTON_ID = 106;
    public static final int DECREASE_COUNT_START_BUTTON_ID = 112;
    public static final int DECREASE_COUNT_FAST_START_BUTTON_ID = 118;
    private final class_1657 player;
    private final class_1268 hand;
    private final int tagSlot;
    private final ItemAndStack<class_1792> tagStack;
    private final class_1277 paybackContainer;

    protected PaybackTagMenu(@Nullable class_3917<?> menuType, int containerId, class_1661 playerInventory, class_1268 hand) {
        super(menuType, containerId);
        this.player = playerInventory.field_7546;
        this.hand = hand;
        this.tagSlot = hand == class_1268.field_5810 ? 40 : playerInventory.field_7545;
        this.tagStack = new ItemAndStack(playerInventory.method_5438(this.tagSlot));
        this.paybackContainer = this.createPaybackContainer();
        this.addPaybackSlots();
        this.addPlayerSlots((class_1263)playerInventory, 13, 72, this.tagSlot);
    }

    public PaybackTagMenu(int containerId, class_1661 playerInventory, class_1268 hand) {
        this(Envelope.MenuTypes.PAYBACK_TAG.get(), containerId, playerInventory, hand);
    }

    public static PaybackTagMenu fromNetwork(int id, class_1661 inventory, class_9129 buffer) {
        return new PaybackTagMenu(id, inventory, (class_1268)buffer.method_10818(class_1268.class));
    }

    protected class_1277 createPaybackContainer() {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        @Nullable PaybackTagContents paybackTagContents = (PaybackTagContents)this.tagStack.method_57824(Envelope.DataComponents.PAYBACK_TAG_CONTENTS);
        if (paybackTagContents != null) {
            for (int i = 0; i < Math.min(paybackTagContents.size(), 6); ++i) {
                items.add(paybackTagContents.getItemForReading(i));
            }
        }
        while (items.size() < 6) {
            items.add(class_1799.field_8037);
        }
        return new class_1277((class_1799[])items.toArray(class_1799[]::new));
    }

    protected void addPaybackSlots() {
        int slotsX = 67;
        int slotsY = 20;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 3; ++column) {
                int index = column + row * 3;
                int x = slotsX + column * 18;
                int y = slotsY + row * 18;
                this.method_7621(new FilteredSlot((class_1263)this.paybackContainer, index, x, y, RequestedPayback::isValidPaybackItem));
            }
        }
    }

    protected void addPlayerSlots(class_1263 inventory, int x, int y, int tagSlot) {
        for (int index = 0; index < 9; ++index) {
            int slotX = x + index * 18;
            int slotY = y + 58;
            this.method_7621(index == tagSlot ? new DisabledSlot(inventory, index, slotX, slotY) : new class_1735(inventory, index, slotX, slotY));
        }
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = column + row * 9 + 9;
                int slotX = x + column * 18;
                int slotY = y + row * 18;
                this.method_7621(index == tagSlot ? new DisabledSlot(inventory, index, slotX, slotY) : new class_1735(inventory, index, slotX, slotY));
            }
        }
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    public class_1268 getHand() {
        return this.hand;
    }

    public int getTagSlot() {
        return this.tagSlot;
    }

    public ItemAndStack<class_1792> getTag() {
        return this.tagStack;
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int index) {
        class_1735 slot = (class_1735)this.field_7761.get(index);
        class_1799 clickedStack = slot.method_7677();
        if (index < 6) {
            this.paybackContainer.method_5447(index, class_1799.field_8037);
            this.paybackContainer.method_5431();
        } else if (index < this.field_7761.size()) {
            for (int i = 0; i < 6; ++i) {
                class_1735 paybackSlot = (class_1735)this.field_7761.get(i);
                if (!paybackSlot.method_7677().method_7960() || !paybackSlot.method_7680(clickedStack)) continue;
                paybackSlot.method_7673(clickedStack.method_7972());
                paybackSlot.method_7668();
                break;
            }
        }
        return class_1799.field_8037;
    }

    public boolean method_7604(@NotNull class_1657 player, int buttonId) {
        if (buttonId == 0) {
            PaybackTagContents contents = PaybackTagContents.create((class_1263)this.paybackContainer);
            if (contents.isEmpty()) {
                this.getTag().remove(Envelope.DataComponents.PAYBACK_TAG_CONTENTS);
            } else {
                this.getTag().set(Envelope.DataComponents.PAYBACK_TAG_CONTENTS, contents);
            }
            player.method_37908().method_43129(player, (class_1297)player, (class_3414)class_3417.field_14883.comp_349(), class_3419.field_15248, 1.0f, player.method_37908().method_8409().method_43057() * 0.3f + 0.85f);
            player.method_6122(this.getHand(), this.getTag().getItemStack());
            return true;
        }
        if (buttonId >= 100) {
            int change;
            int id = buttonId - 100;
            int slotIndex = id % 6;
            boolean decrease = id >= 12;
            boolean fast = id % 12 >= 6;
            int n = change = fast ? 5 : 1;
            if (decrease) {
                change *= -1;
            }
            class_1799 stack = this.paybackContainer.method_5438(slotIndex);
            stack.method_7939(class_3532.method_15340((int)(stack.method_7947() + change), (int)1, (int)stack.method_7914()));
            this.paybackContainer.method_5431();
        }
        return false;
    }

    public void method_7593(int slotId, int button, class_1713 clickType, class_1657 player) {
        if (slotId < 0 || slotId >= 6) {
            super.method_7593(slotId, button, clickType, player);
            return;
        }
        class_1735 paybackSlot = (class_1735)this.field_7761.get(slotId);
        if (!this.method_34255().method_7960() && paybackSlot.method_7680(this.method_34255())) {
            class_1799 result = this.method_34255().method_7972();
            if (button == 1) {
                if (class_1799.method_31577((class_1799)paybackSlot.method_7677(), (class_1799)result)) {
                    result.method_7939(paybackSlot.method_7677().method_7947() + 1);
                } else {
                    result.method_7939(1);
                }
            }
            paybackSlot.method_7673(result);
        } else {
            paybackSlot.method_7673(class_1799.field_8037);
        }
    }

    public boolean method_7597(class_1657 player) {
        return player.method_5998(this.hand).method_7909() instanceof PaybackTagItem;
    }
}

