/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import io.github.mortuusars.envelope.Envelope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_5632;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public final class PackageContents
implements class_5632 {
    public static final int SLOTS = 6;
    public static final Codec<PackageContents> CODEC = class_1799.field_49266.listOf(0, 6).xmap(PackageContents::new, PackageContents::getItemsForSerialization);
    public static final class_9139<class_9129, PackageContents> STREAM_CODEC = class_1799.field_49268.method_56433(class_9135.method_58000((int)6)).method_56432(PackageContents::new, PackageContents::getItemsForReading);
    public static final PackageContents EMPTY = new PackageContents(Collections.emptyList());
    private final List<class_1799> items = class_2371.method_10213((int)6, (Object)class_1799.field_8037);

    public PackageContents(List<class_1799> items) {
        for (int i = 0; i < Math.min(items.size(), 6); ++i) {
            this.items.set(i, items.get(i));
        }
    }

    public static PackageContents createFrom(class_1263 container) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (int i = 0; i < Math.min(container.method_5439(), 6); ++i) {
            items.add(container.method_5438(i));
        }
        return new PackageContents(items);
    }

    public static PackageContents from(class_1799 stack) {
        return (PackageContents)stack.method_57825(Envelope.DataComponents.PACKAGE_CONTENTS, (Object)EMPTY);
    }

    public int size() {
        return this.items.size();
    }

    public List<class_1799> getItemsForReading() {
        return this.items;
    }

    private List<class_1799> getItemsForSerialization() {
        ArrayList<class_1799> list = new ArrayList<class_1799>(this.items);
        for (int i = list.size() - 1; i >= 0 && ((class_1799)list.get(i)).method_7960(); --i) {
            list.remove(i);
        }
        return list;
    }

    public class_1799 getItemForReading(int index) {
        return index < this.size() ? this.items.get(index) : class_1799.field_8037;
    }

    public List<class_1799> copyItems() {
        return Lists.transform(this.items, class_1799::method_7972);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object another) {
        if (this == another) return true;
        if (!(another instanceof PackageContents)) return false;
        PackageContents packageContents = (PackageContents)another;
        if (!class_1799.method_57362(this.items, packageContents.items)) return false;
        return true;
    }

    public int hashCode() {
        return class_1799.method_57361(this.items);
    }

    public String toString() {
        return "PackageContents" + String.valueOf(this.items);
    }

    public boolean isEmpty() {
        return this.equals(EMPTY) || this.getItemsForReading().isEmpty() || this.getItemsForReading().stream().allMatch(class_1799::method_7960);
    }
}

