/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item.component.mail.log;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.world.GameTime;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3542;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7995;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record DeliveryRecord(Type type, Optional<Address> address, Optional<Long> timestamp, Optional<class_2561> message, MessageType messageType) {
    public static final Codec<DeliveryRecord> CODEC = RecordCodecBuilder.create(i -> i.group((App)Type.CODEC.fieldOf("type").forGetter(DeliveryRecord::type), (App)Address.CODEC.optionalFieldOf("address").forGetter(DeliveryRecord::address), (App)Codec.LONG.optionalFieldOf("timestamp").forGetter(DeliveryRecord::timestamp), (App)class_8824.field_46597.optionalFieldOf("message").forGetter(DeliveryRecord::message), (App)MessageType.CODEC.optionalFieldOf("message_type", (Object)MessageType.NEUTRAL).forGetter(DeliveryRecord::messageType)).apply((Applicative)i, DeliveryRecord::new));
    public static final class_9139<class_9129, DeliveryRecord> STREAM_CODEC = class_9139.method_56906(Type.STREAM_CODEC, DeliveryRecord::type, (class_9139)class_9135.method_56382(Address.STREAM_CODEC), DeliveryRecord::address, (class_9139)class_9135.method_56382((class_9139)class_9135.field_48551), DeliveryRecord::timestamp, (class_9139)class_9135.method_56382((class_9139)class_8824.field_48540), DeliveryRecord::message, MessageType.STREAM_CODEC, DeliveryRecord::messageType, DeliveryRecord::new);

    public static DeliveryRecord sentFrom(@NotNull Address address, long timestamp) {
        Preconditions.checkNotNull((Object)address);
        return new DeliveryRecord(Type.SENT, Optional.of(address), Optional.of(timestamp), Optional.empty(), MessageType.NEUTRAL);
    }

    public static DeliveryRecord arrivedTo(@NotNull Address address, long timestamp) {
        Preconditions.checkNotNull((Object)address);
        return new DeliveryRecord(Type.ARRIVED, Optional.of(address), Optional.of(timestamp), Optional.empty(), MessageType.NEUTRAL);
    }

    public static DeliveryRecord returned(class_2561 reason) {
        Preconditions.checkNotNull((Object)reason);
        return new DeliveryRecord(Type.RETURNED, Optional.of(Address.MAIL_SERVICE), Optional.empty(), Optional.of(reason), MessageType.NEGATIVE);
    }

    public static DeliveryRecord payback(@NotNull class_2561 message, MessageType type) {
        return new DeliveryRecord(Type.PAYBACK, Optional.empty(), Optional.empty(), Optional.of(message), type);
    }

    public class_5250 toComponent(long gameTime) {
        int addressColor = switch (this.type().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> -8735263;
            case 1 -> -1528457;
            case 2, 3, 4 -> -1651816;
        };
        class_2561 addressComponent = (class_2561)this.address.map(a -> a.format().withIcon().withIconColor(addressColor).withColor(addressColor).toComponent()).orElse(class_2561.method_43473());
        class_5250 messageComponent = class_2561.method_43473().method_10852(this.message.orElse(class_5244.field_39003)).method_27696(this.messageType().getStyle());
        class_2561 elapsedTimeComponent = (class_2561)this.timestamp.map(time -> GameTime.formatLargest(gameTime - time, false).method_27692(class_124.field_1063)).orElse(class_2561.method_43473());
        return class_2561.method_43469((String)("gui.envelope.delivery_log.record." + this.type().method_15434()), (Object[])new Object[]{addressComponent, messageComponent, elapsedTimeComponent}).method_27692(class_124.field_1080);
    }

    public static enum Type implements class_3542
    {
        SENT("sent"),
        ARRIVED("arrived"),
        RETURNED("returned"),
        PAYBACK("payback"),
        CUSTOM("custom");

        public static final Codec<Type> CODEC;
        public static final class_9139<ByteBuf, Type> STREAM_CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public class_5250 translate() {
            return class_2561.method_43471((String)("gui.envelope.delivery_log.record." + this.method_15434()));
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
            STREAM_CODEC = class_9135.method_56375((IntFunction)class_7995.method_47914(Enum::ordinal, (Object[])Type.values(), (class_7995.class_7996)class_7995.class_7996.field_41664), Enum::ordinal);
        }
    }

    public static enum MessageType implements class_3542
    {
        NEUTRAL("neutral", class_2583.field_24360.method_10977(class_124.field_1080)),
        POSITIVE("positive", class_2583.field_24360.method_36139(-9053060)),
        NEGATIVE("negative", class_2583.field_24360.method_36139(-1801868));

        public static final Codec<MessageType> CODEC;
        public static final class_9139<ByteBuf, MessageType> STREAM_CODEC;
        private final String name;
        private final class_2583 style;

        private MessageType(String name, class_2583 style) {
            this.name = name;
            this.style = style;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public class_2583 getStyle() {
            return this.style;
        }

        static {
            CODEC = class_3542.method_28140(MessageType::values);
            STREAM_CODEC = class_9135.method_56375((IntFunction)class_7995.method_47914(Enum::ordinal, (Object[])MessageType.values(), (class_7995.class_7996)class_7995.class_7996.field_41664), Enum::ordinal);
        }
    }

    public static interface Message {
        public static final class_2561 RECIPIENT_NOT_FOUND = class_2561.method_43471((String)"gui.envelope.delivery_log.message.returned_recipient_not_found");
        public static final class_2561 RECIPIENT_INBOX_IS_FULL = class_2561.method_43471((String)"gui.envelope.delivery_log.message.returned_recipient_inbox_is_full");
        public static final class_2561 UNABLE_TO_REACH = class_2561.method_43471((String)"gui.envelope.delivery_log.message.returned_unable_to_reach");
        public static final class_2561 REJECTED = class_2561.method_43471((String)"gui.envelope.delivery_log.message.returned_rejected");
        public static final class_2561 PAYBACK_FULFILLED = class_2561.method_43471((String)"gui.envelope.delivery_log.message.payback_fulfilled");
        public static final class_2561 RETURNED_PAYBACK_SUBJECT_NOT_FOUND = class_2561.method_43471((String)"gui.envelope.delivery_log.message.returned_payback_subject_not_found");
        public static final class_2561 RETURNED_PAYBACK_IS_NOT_VALID = class_2561.method_43471((String)"gui.envelope.delivery_log.message.returned_payback_is_not_valid");
        public static final class_2561 RETURNED_PAYBACK_EXPIRED = class_2561.method_43471((String)"gui.envelope.delivery_log.message.returned_payback_expired");
    }

    public static class Builder {
        private final Type type;
        private Optional<Address> address = Optional.empty();
        private Optional<Long> timestamp = Optional.empty();
        private Optional<class_2561> message = Optional.empty();
        private MessageType messageType = MessageType.NEUTRAL;

        public Builder(Type type) {
            this.type = type;
        }

        public Builder address(Address address) {
            this.address = Optional.of(address);
            return this;
        }

        public Builder at(long timestamp) {
            this.timestamp = Optional.of(timestamp);
            return this;
        }

        public Builder message(class_2561 message) {
            this.message = Optional.ofNullable(message);
            return this;
        }

        public Builder messageType(MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public DeliveryRecord build() {
            return new DeliveryRecord(this.type, this.address, this.timestamp, this.message, this.messageType);
        }
    }
}

