/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item.component.seal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.Envelope;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5381;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7891;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public final class SealImpression {
    public static final Codec<SealImpression> DIRECT_CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2960.field_25139.fieldOf("texture").forGetter(SealImpression::textureId)).apply((Applicative)i, SealImpression::new));
    public static final class_9139<class_9129, SealImpression> DIRECT_STREAM_CODEC = class_9139.method_56434((class_9139)class_2960.field_48267, SealImpression::textureId, SealImpression::new);
    public static final Codec<class_6880<SealImpression>> CODEC = class_5381.method_29749(Envelope.Registries.SEAL_IMPRESSION, DIRECT_CODEC);
    public static final class_9139<class_9129, class_6880<SealImpression>> STREAM_CODEC = class_9135.method_56367(Envelope.Registries.SEAL_IMPRESSION, DIRECT_STREAM_CODEC);
    public static final Map<Character, class_5321<SealImpression>> LETTERS = (Map)class_156.method_654(new HashMap(), map -> {
        for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            map.put(Character.valueOf(c), SealImpression.key(String.valueOf(c)));
        }
    });
    public static final Map<Character, class_5321<SealImpression>> NUMBERS = (Map)class_156.method_654(new HashMap(), map -> {
        for (char c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            map.put(Character.valueOf(c), SealImpression.key(String.valueOf(c)));
        }
    });
    public static final Map<String, class_5321<SealImpression>> SYMBOLS = new HashMap<String, class_5321<SealImpression>>();
    public static final class_5321<SealImpression> APPLE = SealImpression.symbolKey("apple");
    public static final class_5321<SealImpression> AXE = SealImpression.symbolKey("axe");
    public static final class_5321<SealImpression> BLOCK = SealImpression.symbolKey("block");
    public static final class_5321<SealImpression> BOOK = SealImpression.symbolKey("book");
    public static final class_5321<SealImpression> CREEPER = SealImpression.symbolKey("creeper");
    public static final class_5321<SealImpression> EMERALD = SealImpression.symbolKey("emerald");
    public static final class_5321<SealImpression> HEART = SealImpression.symbolKey("heart");
    public static final class_5321<SealImpression> HOE = SealImpression.symbolKey("hoe");
    public static final class_5321<SealImpression> LETTER = SealImpression.symbolKey("letter");
    public static final class_5321<SealImpression> PICKAXE = SealImpression.symbolKey("pickaxe");
    public static final class_5321<SealImpression> SHOVEL = SealImpression.symbolKey("shovel");
    public static final class_5321<SealImpression> SKELETON = SealImpression.symbolKey("skeleton");
    public static final class_5321<SealImpression> SKELETON_SMIRK = SealImpression.symbolKey("skeleton_smirk");
    public static final class_5321<SealImpression> SWORD = SealImpression.symbolKey("sword");
    public static final class_5321<SealImpression> SWORDS = SealImpression.symbolKey("swords");
    public static final class_5321<SealImpression> VILLAGER = SealImpression.symbolKey("villager");
    public static final class_5321<SealImpression> DEFAULT = CREEPER;
    private final class_2960 texture;
    private final class_2960 textureFull;

    public SealImpression(class_2960 texture) {
        this.texture = texture;
        this.textureFull = texture.method_45134(path -> "textures/" + path + ".png");
    }

    public class_2960 textureId() {
        return this.texture;
    }

    public class_2960 texture() {
        return this.textureFull;
    }

    public static class_5321<SealImpression> firstCharOrDefault(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = Character.toLowerCase(string.charAt(i));
            if (c >= 'a' && c <= 'z') {
                return LETTERS.getOrDefault(Character.valueOf(c), DEFAULT);
            }
            if (c < '0' || c > '9') continue;
            return NUMBERS.getOrDefault(Character.valueOf(c), DEFAULT);
        }
        return DEFAULT;
    }

    public static class_5321<SealImpression> firstCharOrDefault(@Nullable class_1657 player) {
        if (player == null) {
            return DEFAULT;
        }
        return SealImpression.firstCharOrDefault(player.method_5820());
    }

    public static class_6880<SealImpression> getHolder(class_5455 access, class_5321<SealImpression> key) {
        return access.method_30530(Envelope.Registries.SEAL_IMPRESSION).method_40290(key);
    }

    private static class_5321<SealImpression> key(String path) {
        return class_5321.method_29179(Envelope.Registries.SEAL_IMPRESSION, (class_2960)Envelope.resource(path));
    }

    private static class_5321<SealImpression> symbolKey(String path) {
        class_5321 key = class_5321.method_29179(Envelope.Registries.SEAL_IMPRESSION, (class_2960)Envelope.resource(path));
        SYMBOLS.put(path, (class_5321<SealImpression>)key);
        return key;
    }

    public static void bootstrap(class_7891<SealImpression> context) {
        Function<class_5321, class_2960> keyToTexture = key -> key.method_29177().method_45134(path -> "gui/seal/impression/" + path);
        NUMBERS.values().forEach(key -> context.method_46838(key, (Object)new SealImpression((class_2960)keyToTexture.apply((class_5321)key))));
        LETTERS.values().forEach(key -> context.method_46838(key, (Object)new SealImpression((class_2960)keyToTexture.apply((class_5321)key))));
        SYMBOLS.values().forEach(key -> context.method_46838(key, (Object)new SealImpression((class_2960)keyToTexture.apply((class_5321)key))));
    }
}

