/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item.component.seal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.util.EnvelopeCodecs;
import io.github.mortuusars.envelope.world.item.component.seal.ShadingPalette;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5381;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7891;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public final class SealMaterial {
    public static final Codec<SealMaterial> DIRECT_CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2960.field_25139.fieldOf("texture").forGetter(SealMaterial::textureId), (App)EnvelopeCodecs.HEX_COLOR.fieldOf("model_tint_color").forGetter(SealMaterial::modelTintColor), (App)ShadingPalette.CODEC.fieldOf("impression_palette").forGetter(SealMaterial::impressionPalette)).apply((Applicative)i, SealMaterial::new));
    public static final class_9139<class_9129, SealMaterial> DIRECT_STREAM_CODEC = class_9139.method_56436((class_9139)class_2960.field_48267, SealMaterial::textureId, (class_9139)class_9135.field_49675, SealMaterial::modelTintColor, ShadingPalette.STREAM_CODEC, SealMaterial::impressionPalette, SealMaterial::new);
    public static final Codec<class_6880<SealMaterial>> CODEC = class_5381.method_29749(Envelope.Registries.SEAL_MATERIAL, DIRECT_CODEC);
    public static final class_9139<class_9129, class_6880<SealMaterial>> STREAM_CODEC = class_9135.method_56367(Envelope.Registries.SEAL_MATERIAL, DIRECT_STREAM_CODEC);
    public static final class_5321<SealMaterial> RED_WAX = class_5321.method_29179(Envelope.Registries.SEAL_MATERIAL, (class_2960)Envelope.resource("red_wax"));
    public static final class_5321<SealMaterial> GOLD = class_5321.method_29179(Envelope.Registries.SEAL_MATERIAL, (class_2960)Envelope.resource("gold"));
    private final class_2960 textureId;
    private final class_2960 textureFull;
    private final int modelTintColor;
    private final ShadingPalette impressionPalette;

    public SealMaterial(class_2960 texture, int modelTintColor, ShadingPalette impressionPalette) {
        this.textureId = texture;
        this.textureFull = texture.method_45134(path -> "textures/" + path + ".png");
        this.modelTintColor = modelTintColor;
        this.impressionPalette = impressionPalette;
    }

    public class_2960 textureId() {
        return this.textureId;
    }

    public class_2960 texture() {
        return this.textureFull;
    }

    public int modelTintColor() {
        return this.modelTintColor;
    }

    public ShadingPalette impressionPalette() {
        return this.impressionPalette;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SealMaterial that = (SealMaterial)obj;
        return Objects.equals(this.textureId, that.textureId) && this.modelTintColor == that.modelTintColor && Objects.equals(this.impressionPalette, that.impressionPalette);
    }

    public int hashCode() {
        int i = 1;
        i = 31 * i + this.textureId.hashCode();
        i = 31 * i + this.modelTintColor;
        return 31 * i + this.impressionPalette.hashCode();
    }

    public String toString() {
        return "SealMaterial[texture=" + String.valueOf(this.textureId) + ", modelTintColor=" + this.modelTintColor + ", impressionPalette=" + String.valueOf(this.impressionPalette) + "]";
    }

    public static class_6880<SealMaterial> getHolder(class_5455 access, class_5321<SealMaterial> key) {
        return access.method_30530(Envelope.Registries.SEAL_MATERIAL).method_40290(key);
    }

    public static void bootstrap(class_7891<SealMaterial> context) {
        Function<class_5321, class_2960> keyToTexture = key -> key.method_29177().method_45134(path -> "gui/seal/material/" + path);
        context.method_46838(RED_WAX, (Object)new SealMaterial(keyToTexture.apply(RED_WAX), -3387833, new ShadingPalette(-5817804, -946568, -10089462, -7723486)));
        context.method_46838(GOLD, (Object)new SealMaterial(keyToTexture.apply(GOLD), -19641, new ShadingPalette(-2648266, -5459, -9096181, -4887260)));
    }
}

