/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.item.mail;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.item.component.LetterContent;
import io.github.mortuusars.envelope.world.item.component.PackageContents;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryLog;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryRecord;
import io.github.mortuusars.envelope.world.item.mail.MailBuilder;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.entity.mail_service.payback_department.PaybackSubject;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3902;
import net.minecraft.class_5536;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Mail {
    private Mail() {
    }

    public static Optional<Address> getSender(class_1799 stack) {
        return Optional.ofNullable((Address)stack.method_57824(Envelope.DataComponents.MAIL_SENDER));
    }

    @NotNull
    public static Address getSenderOrElse(class_1799 stack, Address orElse) {
        return (Address)stack.method_57825(Envelope.DataComponents.MAIL_SENDER, (Object)orElse);
    }

    @NotNull
    public static Address getSenderOrUnknown(class_1799 stack) {
        return Mail.getSenderOrElse(stack, Address.UNKNOWN);
    }

    public static void setSender(@NotNull class_1799 stack, @Nullable Address sender) {
        stack.method_57379(Envelope.DataComponents.MAIL_SENDER, (Object)sender);
    }

    public static Optional<Address> getRecipient(class_1799 stack) {
        return Optional.ofNullable((Address)stack.method_57824(Envelope.DataComponents.MAIL_RECIPIENT));
    }

    @NotNull
    public static Address getRecipientOrElse(class_1799 stack, Address orElse) {
        return (Address)stack.method_57825(Envelope.DataComponents.MAIL_RECIPIENT, (Object)orElse);
    }

    @NotNull
    public static Address getRecipientOrUnknown(class_1799 stack) {
        return Mail.getRecipientOrElse(stack, Address.UNKNOWN);
    }

    public static void setRecipient(@NotNull class_1799 stack, @Nullable Address recipient) {
        stack.method_57379(Envelope.DataComponents.MAIL_RECIPIENT, (Object)recipient);
    }

    public static boolean hasId(class_1799 stack) {
        return stack.method_57826(Envelope.DataComponents.MAIL_ID);
    }

    @Nullable
    public static Id getId(class_1799 stack) {
        return (Id)stack.method_57824(Envelope.DataComponents.MAIL_ID);
    }

    public static Id getOrCreateId(class_1799 stack, class_1937 level) {
        return (Id)stack.method_57368(Envelope.DataComponents.MAIL_ID, (Object)Id.create(level), UnaryOperator.identity());
    }

    public static class_1799 setId(class_1799 stack, Id id) {
        stack.method_57379(Envelope.DataComponents.MAIL_ID, (Object)id);
        return stack;
    }

    public static boolean isReturned(class_1799 stack) {
        return stack.method_57826(Envelope.DataComponents.MAIL_RETURNED);
    }

    public static class_1799 setReturned(class_1799 stack, boolean returned) {
        stack.method_57379(Envelope.DataComponents.MAIL_RETURNED, returned ? class_3902.field_17274 : null);
        return stack;
    }

    public static class_1799 setReturned(class_1799 stack) {
        stack.method_57379(Envelope.DataComponents.MAIL_RETURNED, (Object)class_3902.field_17274);
        return stack;
    }

    public static DeliveryLog getLog(class_1799 stack) {
        return (DeliveryLog)stack.method_57825(Envelope.DataComponents.MAIL_DELIVERY_LOG, (Object)DeliveryLog.EMPTY);
    }

    public static class_1799 setLog(class_1799 stack, DeliveryLog log) {
        stack.method_57379(Envelope.DataComponents.MAIL_DELIVERY_LOG, (Object)log);
        return stack;
    }

    public static class_1799 writeToLog(class_1799 stack, DeliveryRecord record) {
        stack.method_57368(Envelope.DataComponents.MAIL_DELIVERY_LOG, (Object)DeliveryLog.EMPTY, log -> log.append(record));
        return stack;
    }

    public static class_1799 writeToLog(class_1799 stack, DeliveryRecord.Builder record) {
        return Mail.writeToLog(stack, record.build());
    }

    public static class_1799 writeToLog(class_1799 stack, DeliveryRecord ... records) {
        stack.method_57368(Envelope.DataComponents.MAIL_DELIVERY_LOG, (Object)DeliveryLog.EMPTY, log -> log.append(records));
        return stack;
    }

    public static class_1799 writeToLog(class_1799 stack, DeliveryRecord.Builder ... records) {
        stack.method_57368(Envelope.DataComponents.MAIL_DELIVERY_LOG, (Object)DeliveryLog.EMPTY, log -> log.append(records));
        return stack;
    }

    public static class_1799 removePreviousDeliveryData(class_1799 mail) {
        if (mail.method_7960()) {
            return class_1799.field_8037;
        }
        mail.method_57381(Envelope.DataComponents.MAIL_ID);
        mail.method_57381(Envelope.DataComponents.MAIL_SENDER);
        mail.method_57381(Envelope.DataComponents.MAIL_DELIVERY_LOG);
        mail.method_57381(Envelope.DataComponents.MAIL_RETURNED);
        return mail;
    }

    public static class_1799 asDelivered(class_1799 mail) {
        if (mail.method_7960()) {
            return class_1799.field_8037;
        }
        if (!Mail.isReturned(mail)) {
            mail.method_57381(Envelope.DataComponents.MAIL_RECIPIENT);
            mail.method_57381(Envelope.DataComponents.MAIL_REQUESTED_PAYBACK);
        }
        return mail;
    }

    public static MailBuilder<?> of(class_1799 stack) {
        return new MailBuilder(stack);
    }

    public static MailBuilder<?> createLetter(class_2561 text) {
        return new MailBuilder(Envelope.Items.LETTER.get()).set(Envelope.DataComponents.LETTER_CONTENT, new LetterContent(text));
    }

    public static MailBuilder<?> createPackage(PackageContents contents) {
        return new MailBuilder((class_1792)Envelope.Items.PACKAGE.get()).set(Envelope.DataComponents.PACKAGE_CONTENTS, contents);
    }

    public static MailBuilder<?> createPaybackPackingBox(PaybackSubject subject) {
        return new MailBuilder(Envelope.Items.PAYBACK_PACKING_BOX.get()).set(Envelope.DataComponents.PAYBACK_SUBJECT, subject);
    }

    public static boolean handleShearsUse(class_1799 stack, class_1735 slot, class_5536 action, class_1657 player) {
        if (action != class_5536.field_27014) {
            return false;
        }
        if (!slot.method_32754(player)) {
            return false;
        }
        if (!slot.method_7677().method_31573(Envelope.Tags.Items.MAILABLE)) {
            return false;
        }
        class_1799 result = Mail.removePreviousDeliveryData(slot.method_7677().method_7972());
        if (!class_1799.method_31577((class_1799)slot.method_7677(), (class_1799)result)) {
            slot.method_53512(result);
            stack.method_7970(1, (class_1309)player, class_1304.field_6173);
            player.method_5783(class_3417.field_14975, 0.75f, 1.0f);
        } else {
            player.method_5783(class_3417.field_14762, 0.75f, 1.0f);
        }
        return true;
    }
}

