/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.mail.address;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.envelope.util.result.Error;
import io.github.mortuusars.envelope.world.mail.address.AddressFormatter;
import io.github.mortuusars.envelope.world.mail.address.AddressValidation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_7995;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public interface Address {
    public static final int MAX_LENGTH = 40;
    public static final Codec<String> ID_CODEC = Codec.STRING.xmap(String::trim, String::trim).validate(Address::validate);
    public static final Codec<Address> CODEC = Type.CODEC.dispatch(Address::type, Type::getCodec);
    public static final class_9139<class_9129, Address> STREAM_CODEC = Type.STREAM_CODEC.method_56440(Address::type, Type::getStreamCodec);
    public static final Entity MAIL_SERVICE = new Entity("Mail Service", (class_2561)class_2561.method_43471((String)"address.envelope.mail_service"));
    public static final Address UNKNOWN = new Entity("Unknown", (class_2561)class_2561.method_43471((String)"address.envelope.unknown"));

    public Type type();

    public String id();

    public String toString();

    default public class_5250 getName() {
        return class_2561.method_43470((String)this.id());
    }

    default public boolean matches(String name) {
        return this.toString().equalsIgnoreCase(name);
    }

    default public boolean matches(Address address) {
        return this.matches(address.toString());
    }

    default public AddressFormatter format() {
        return AddressFormatter.of(this);
    }

    default public <R> R map(Function<Block, R> ifBlock, Function<Player, R> ifPlayer, Function<Entity, R> ifEntity) {
        Address address = this;
        Objects.requireNonNull(address);
        Address address2 = address;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Block.class, Player.class, Entity.class}, (Object)address2, n)) {
            case 0 -> {
                Block block = (Block)address2;
                yield ifBlock.apply(block);
            }
            case 1 -> {
                Player player = (Player)address2;
                yield ifPlayer.apply(player);
            }
            case 2 -> {
                Entity entity = (Entity)address2;
                yield ifEntity.apply(entity);
            }
            default -> throw new IllegalStateException("Unknown type of address. " + String.valueOf(this.getClass()));
        };
    }

    @NotNull
    public static DataResult<String> validate(String id) {
        return AddressValidation.id().test(id).map(DataResult::success, Error::asDataResult);
    }

    public record Block(String id) implements Address
    {
        public static final MapCodec<Block> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ID_CODEC.fieldOf("id").forGetter(Block::id)).apply((Applicative)instance, Block::new));
        public static final Codec<Block> STRING_CODEC = Codec.STRING.xmap(Block::new, Block::id);
        public static final class_9139<class_9129, Block> STREAM_CODEC = class_9135.field_48554.method_56432(Block::new, Block::id).method_56430();

        public Block {
            Address.validate(id).getOrThrow();
        }

        @Override
        public Type type() {
            return Type.BLOCK;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Block that = (Block)o;
            return this.id.equalsIgnoreCase(that.id);
        }

        @Override
        public int hashCode() {
            return ("b" + this.id.toLowerCase(Locale.ROOT)).hashCode();
        }

        @Override
        public String toString() {
            return this.id;
        }
    }

    public record Player(String id) implements Address
    {
        public static final MapCodec<Player> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ID_CODEC.fieldOf("id").forGetter(Player::id)).apply((Applicative)instance, Player::new));
        public static final class_9139<class_9129, Player> STREAM_CODEC = class_9135.field_48554.method_56432(Player::new, Player::id).method_56430();

        public Player {
            Address.validate(id).getOrThrow();
        }

        public Player(class_1657 player) {
            this(player.method_5820());
        }

        @Override
        public Type type() {
            return Type.PLAYER;
        }

        @Override
        public String toString() {
            return this.id;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Player that = (Player)o;
            return this.id.equalsIgnoreCase(that.id);
        }

        @Override
        public int hashCode() {
            return ("p" + this.id.toLowerCase(Locale.ROOT)).hashCode();
        }
    }

    public record Entity(String id, Optional<class_2561> displayName) implements Address
    {
        public static final MapCodec<Entity> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ID_CODEC.fieldOf("id").forGetter(Entity::id), (App)class_8824.field_46597.optionalFieldOf("display_name").forGetter(Entity::displayName)).apply((Applicative)instance, Entity::new));
        public static final class_9139<class_9129, Entity> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, Entity::id, (class_9139)class_9135.method_56382((class_9139)class_8824.field_48540), Entity::displayName, Entity::new);

        public Entity {
            Address.validate(id).getOrThrow();
        }

        public Entity(String id, @NotNull class_2561 displayName) {
            this(id, Optional.of(displayName));
        }

        public Entity(String id) {
            this(id, Optional.empty());
        }

        @Override
        public Type type() {
            return Type.ENTITY;
        }

        @Override
        public class_5250 getName() {
            return this.displayName.map(class_2561::method_27662).orElseGet(() -> Address.super.getName());
        }

        @Override
        public String toString() {
            return this.getName().getString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entity that = (Entity)o;
            return this.id.equalsIgnoreCase(that.id);
        }

        @Override
        public int hashCode() {
            return ("e" + this.id.toLowerCase(Locale.ROOT)).hashCode();
        }
    }

    public static enum Type implements class_3542
    {
        BLOCK(0, "block", Block.CODEC, Block.STREAM_CODEC),
        PLAYER(1, "player", Player.CODEC, Player.STREAM_CODEC),
        ENTITY(2, "entity", Entity.CODEC, Entity.STREAM_CODEC);

        public static final Codec<Type> CODEC;
        public static final IntFunction<Type> BY_ID;
        public static final class_9139<class_9129, Type> STREAM_CODEC;
        private final int id;
        private final String name;
        private final MapCodec<? extends Address> codec;
        private final class_9139<class_9129, ? extends Address> streamCodec;

        private Type(int id, String name, MapCodec<? extends Address> codec, class_9139<class_9129, ? extends Address> streamCodec) {
            this.id = id;
            this.name = name;
            this.codec = codec;
            this.streamCodec = streamCodec;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public MapCodec<? extends Address> getCodec() {
            return this.codec;
        }

        public class_9139<class_9129, ? extends Address> getStreamCodec() {
            return this.streamCodec;
        }

        public class_5250 translate() {
            return class_2561.method_43471((String)("address.envelope.type." + this.method_15434()));
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
            BY_ID = class_7995.method_47914(Type::getId, (Object[])Type.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
            STREAM_CODEC = class_9135.method_56375(BY_ID, Enum::ordinal).method_56430();
        }
    }
}

