/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.mail.address;

import com.mojang.datafixers.util.Either;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3544;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddressFormatter {
    public static final int NEUTRAL_COLOR = -1651816;
    public static final int SENDER_COLOR = -8735263;
    public static final int RECIPIENT_COLOR = -1528457;
    protected final Address address;
    protected boolean icon = false;
    protected String iconSeparator = "\ueeff";
    protected Either<class_124, class_2583> iconStyle = Either.right((Object)class_2583.field_24360);
    protected Either<class_124, class_2583> textStyle = Either.right((Object)class_2583.field_24360);
    protected int maxLength = Integer.MAX_VALUE;

    protected AddressFormatter(Address address) {
        this.address = address;
    }

    public static AddressFormatter of(Address address) {
        return new AddressFormatter(address);
    }

    public AddressFormatter asNeutral() {
        return this.withIcon().withIconColor(-1651816).withColor(-1651816);
    }

    public AddressFormatter asSender() {
        return this.withIcon().withIconColor(-8735263).withColor(-8735263);
    }

    public AddressFormatter asRecipient() {
        return this.withIcon().withIconColor(-1528457).withColor(-1528457);
    }

    public AddressFormatter withIcon() {
        this.icon = true;
        return this;
    }

    public AddressFormatter withIconSeparator(String separator) {
        this.iconSeparator = separator;
        return this;
    }

    public AddressFormatter withIconColor(class_124 formatting) {
        this.iconStyle = Either.left((Object)formatting);
        return this;
    }

    public AddressFormatter withIconStyle(class_2583 style) {
        this.iconStyle = Either.right((Object)style);
        return this;
    }

    public AddressFormatter withIconColor(int color) {
        this.iconStyle = Either.right((Object)class_2583.field_24360.method_36139(color));
        return this;
    }

    public AddressFormatter withColor(class_124 formatting) {
        this.textStyle = Either.left((Object)formatting);
        return this;
    }

    public AddressFormatter withStyle(class_2583 style) {
        this.textStyle = Either.right((Object)style);
        return this;
    }

    public AddressFormatter withColor(int color) {
        this.textStyle = Either.right((Object)class_2583.field_24360.method_36139(color));
        return this;
    }

    public AddressFormatter withMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public class_5250 toComponent() {
        class_5250 addressComponent;
        if (this.maxLength < Integer.MAX_VALUE) {
            String string = class_3544.method_34963((String)this.address.toString(), (int)this.maxLength, (boolean)true);
            addressComponent = class_2561.method_43470((String)string);
        } else {
            addressComponent = this.address.getName();
        }
        addressComponent = addressComponent.method_27696(this.createStyle(this.textStyle));
        if (this.icon) {
            return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)AddressFormatter.getIcon(this.address)).method_27696(this.createStyle(this.iconStyle))).method_27693(this.iconSeparator).method_10852((class_2561)addressComponent);
        }
        return addressComponent;
    }

    public String toString() {
        String addressString = class_3544.method_34963((String)this.address.toString(), (int)this.maxLength, (boolean)true);
        String addressText = this.textStyle.left().map(formatting -> String.valueOf(formatting) + addressString + String.valueOf(class_124.field_1070)).orElse(addressString);
        if (this.icon) {
            String icon = this.iconStyle.left().map(formatting -> String.valueOf(formatting) + AddressFormatter.getIcon(this.address) + String.valueOf(class_124.field_1070)).orElse(AddressFormatter.getIcon(this.address));
            return icon + this.iconSeparator + addressText;
        }
        return addressText;
    }

    protected class_2583 createStyle(Either<class_124, class_2583> style) {
        return (class_2583)style.map(arg_0 -> ((class_2583)class_2583.field_24360).method_27706(arg_0), Function.identity());
    }

    @NotNull
    public static String getIcon(Address address) {
        if (address.equals(Address.UNKNOWN)) {
            return "\uee03";
        }
        if (address.equals(Address.MAIL_SERVICE)) {
            return "\uee04";
        }
        return switch (address.type()) {
            default -> throw new MatchException(null, null);
            case Address.Type.BLOCK -> "\uee00";
            case Address.Type.PLAYER -> "\uee01";
            case Address.Type.ENTITY -> "\uee02";
        };
    }

    @NotNull
    public static class_2561 fullSender(@Nullable Address sender) {
        if (sender == null) {
            return class_5244.field_39003;
        }
        return class_2561.method_43471((String)"gui.envelope.mail.sender").method_27692(class_124.field_1080).method_27693(": ").method_27692(class_124.field_1080).method_10852((class_2561)sender.format().asSender().toComponent());
    }

    @NotNull
    public static class_2561 fullRecipient(@Nullable Address recipient) {
        if (recipient == null) {
            return class_5244.field_39003;
        }
        return class_2561.method_43471((String)"gui.envelope.mail.recipient").method_27692(class_124.field_1080).method_27693(": ").method_27692(class_124.field_1080).method_10852((class_2561)recipient.format().asRecipient().toComponent());
    }

    @NotNull
    public static class_2561 senderToRecipient(@Nullable Address sender, @Nullable Address recipient) {
        if (sender == null && recipient == null) {
            return class_5244.field_39003;
        }
        if (sender != null) {
            if (recipient == null) {
                recipient = Address.UNKNOWN;
            }
            return sender.format().asSender().withMaxLength(25).toComponent().method_10852((class_2561)class_2561.method_43470((String)" \uee21 ").method_27692(class_124.field_1080)).method_10852((class_2561)recipient.format().asRecipient().withMaxLength(25).toComponent());
        }
        return recipient.format().asRecipient().toComponent();
    }
}

