/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.mail.address;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.world.Position;
import io.github.mortuusars.envelope.world.delivery.TravelDuration;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.jetbrains.annotations.NotNull;

public interface AddressLocation {
    public static final int ASCEND_DISTANCE = 16;
    public static final AddressLocation VIRTUAL = new AddressLocation(){

        @Override
        public Optional<class_2338> getPosition() {
            return Optional.empty();
        }

        @Override
        public int getDistanceTo(class_2338 pos) {
            class_2338 virtualPos = Position.snapToGrid(pos, 2048);
            return Position.getDistanceBetween(virtualPos, pos);
        }
    };
    public static final AddressLocation UNKNOWN = new AddressLocation(){

        @Override
        public Optional<class_2338> getPosition() {
            return Optional.empty();
        }

        @Override
        public int getDistanceTo(class_2338 pos) {
            return (Integer)Config.Server.DELIVERY_DEFAULT_DISTANCE.get();
        }
    };

    public Optional<class_2338> getPosition();

    public int getDistanceTo(class_2338 var1);

    default public int getDistanceTo(Optional<class_2338> pos) {
        return pos.map(this::getDistanceTo).orElse((Integer)Config.Server.DELIVERY_DEFAULT_DISTANCE.get());
    }

    default public TravelDuration getTravelDurationTo(class_2338 pos) {
        return TravelDuration.basedOnDistance(this.getDistanceTo(pos));
    }

    default public TravelDuration getTravelDurationTo(Optional<class_2338> pos) {
        return TravelDuration.basedOnDistance(this.getDistanceTo(pos));
    }

    default public Optional<class_2338> getNearestHub() {
        return this.getPosition().map(pos -> Position.snapToGrid(pos, 1024).method_33096(320));
    }

    default public Optional<class_2338> ascendTowards(class_1937 level, Optional<class_2338> targetPos) {
        return this.getPosition().map(pos -> targetPos.map(blockPos -> Position.ascendTowards(pos, blockPos, 16)).orElseGet(() -> Position.towardsRandomHorizontalDirection(pos, 16, this.hashCode()))).map(pos -> Position.aboveGround(level, pos, 5));
    }

    public static AddressLocation exact(class_2338 pos) {
        return new Exact(pos);
    }

    public record Exact(@NotNull class_2338 pos) implements AddressLocation
    {
        @Override
        public Optional<class_2338> getPosition() {
            return Optional.of(this.pos);
        }

        @Override
        public int getDistanceTo(class_2338 pos) {
            return Position.getDistanceBetween(this.pos, pos);
        }
    }
}

