/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.mail.address;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.util.result.Error;
import io.github.mortuusars.envelope.util.validation.Rule;
import io.github.mortuusars.envelope.util.validation.Validator;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import net.minecraft.class_1657;
import net.minecraft.class_3544;

public interface AddressValidation {
    public static final Error CANNOT_BE_EMPTY = new Error("Id cannot be empty", "error.envelope.address.id_cannot_be_empty");
    public static final Error TOO_LONG = new Error("Id is too long", "error.envelope.address.id_too_long");
    public static final Error CONTAINS_INVALID_CHARS = new Error("Id is too long", "error.envelope.address.id_contains_invalid_chars");
    public static final Error TAKEN = new Error("Id is in use", "error.envelope.address.taken");
    public static final Error NOT_ENOUGH_XP = new Error("Not enough xp levels", "error.envelope.address.not_enough_xp_levels");
    public static final Validator<String> ID = Validator.of(Rule.when(class_3544::method_57181, CANNOT_BE_EMPTY), Rule.when(id -> id.length() > 40, TOO_LONG), Rule.when(id -> !class_3544.method_57180((String)id).equals(id), CONTAINS_INVALID_CHARS));

    public static Validator<String> id() {
        return ID;
    }

    public static Validator<String> forMailbox(AllAddresses addresses, class_1657 player) {
        return AddressValidation.id().and(AddressValidation.isNotTaken(addresses)).and(AddressValidation.hasEnoughXp(player, (Integer)Config.Server.MAILBOX_ADDRESS_EXPERIENCE_LEVELS_COST.get()));
    }

    public static Rule<String> isNotTaken(AllAddresses addresses) {
        return Rule.when(addresses::isKnown, TAKEN);
    }

    public static Rule<String> hasEnoughXp(class_1657 player, int xpLevelsRequired) {
        return Rule.when(id -> !player.method_7337() && player.field_7520 < xpLevelsRequired, NOT_ENOUGH_XP);
    }
}

