/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.mail.address;

import io.github.mortuusars.envelope.world.mail.address.Address;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record AllAddresses(Set<Address.Block> blocks, Set<Address.Player> players, Set<Address.Entity> entities) {
    public static final class_9139<class_9129, AllAddresses> STREAM_CODEC = class_9139.method_56436((class_9139)Address.Block.STREAM_CODEC.method_56433(class_9135.method_56374(HashSet::new)), AllAddresses::blocks, (class_9139)Address.Player.STREAM_CODEC.method_56433(class_9135.method_56374(HashSet::new)), AllAddresses::players, (class_9139)Address.Entity.STREAM_CODEC.method_56433(class_9135.method_56374(HashSet::new)), AllAddresses::entities, AllAddresses::new);
    public static final AllAddresses EMPTY = new AllAddresses(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());

    public static AllAddresses blocks(Set<Address.Block> addresses) {
        return new AllAddresses(addresses, Collections.emptySet(), Collections.emptySet());
    }

    public static AllAddresses players(Set<Address.Player> addresses) {
        return new AllAddresses(Collections.emptySet(), addresses, Collections.emptySet());
    }

    public static AllAddresses entities(Set<Address.Entity> addresses) {
        return new AllAddresses(Collections.emptySet(), Collections.emptySet(), addresses);
    }

    public Stream<Address> stream() {
        return Stream.of(this.blocks, this.players, this.entities).flatMap(Collection::stream);
    }

    public Optional<Address> byName(String name) {
        return this.stream().filter(a -> a.matches(name)).findFirst();
    }

    public boolean isKnown(String name) {
        return this.byName(name).isPresent();
    }

    public boolean isKnown(Address address) {
        return this.stream().anyMatch(a -> a.matches(address));
    }

    public boolean isKnownOfType(Address address, Address.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case Address.Type.BLOCK -> this.blocks.stream().anyMatch(a -> a.matches(address));
            case Address.Type.PLAYER -> this.players.stream().anyMatch(a -> a.matches(address));
            case Address.Type.ENTITY -> this.entities.stream().anyMatch(a -> a.matches(address));
        };
    }
}

