/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.mail.address;

import com.google.common.base.Preconditions;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import net.minecraft.class_156;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class SimpleBlockAddressGenerator {
    private final AllAddresses knownAddresses;
    private final int tries;

    public SimpleBlockAddressGenerator(AllAddresses knownAddresses, int tries) {
        Preconditions.checkArgument((tries > 0 ? 1 : 0) != 0, (Object)"Should have at least 1 try.");
        this.knownAddresses = knownAddresses;
        this.tries = tries;
    }

    @NotNull
    public Address.Block generate(class_5819 random) {
        String noun;
        String firstAdjective;
        String secondAdjective;
        Object[] adjectives = this.getAdjectives();
        Object[] nouns = this.getNouns();
        int count = 0;
        Object id = "";
        do {
            if (count > this.tries) {
                return new Address.Block((String)id);
            }
            ++count;
            firstAdjective = (String)class_156.method_27173((Object[])adjectives, (class_5819)random);
            secondAdjective = "";
            if ((double)random.method_43057() > 0.5) {
                while ((secondAdjective = (String)class_156.method_27173((Object[])adjectives, (class_5819)random)).equals(firstAdjective)) {
                }
            }
            noun = (String)class_156.method_27173((Object[])nouns, (class_5819)random);
        } while (this.knownAddresses.isKnown((String)(id = secondAdjective.isEmpty() ? firstAdjective + " " + noun : firstAdjective + " " + secondAdjective + " " + noun)));
        return new Address.Block((String)id);
    }

    private String[] getAdjectives() {
        return new String[]{"Silent", "Old", "Rugged", "Tattered", "Rusty", "Battered", "Tired", "Lost", "Decayed", "Faded", "Fogged", "Missed", "Time-lost", "Marked", "Hidden", "Open", "Dusty", "Lush", "Wet", "Calm", "Wide", "Broad", "Bright", "Light", "Dark", "Majestic", "Wonderful", "Great", "Enchanting", "Mesmerizing", "Dim", "Pale", "Gray", "Wild", "Secluded", "Narrow", "Empty", "Forgotten", "Waiting", "Prime", "Secondary", "Static", "Brisk", "Agile"};
    }

    private String[] getNouns() {
        return new String[]{"Wood", "Stone", "Brick", "Oak", "Ash", "Clay", "Crossroad", "Corner", "Gate", "Yard", "Path", "Field", "Dock", "Lane", "Square", "Post", "Crow", "Bird", "Sparrow", "Fox", "Wolf", "Rabbit", "Pigeon", "Cat", "Frog", "Raven", "Bat", "Sheep", "Stag", "Pine", "Reed", "Moss", "Ember", "Frost", "Grass", "Ice", "Snow", "Air", "Gust", "Storm", "Peace", "Wind", "Brook", "Hill", "Place", "Nook", "Retreat", "Outpost"};
    }
}

