/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.world.mail.entity;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.entity.MailEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;

public class MailEntities {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<Address.Entity, MailEntity> entities = new HashMap<Address.Entity, MailEntity>();

    public Optional<MailEntity> byAddress(Address.Entity address) {
        return Optional.ofNullable(this.entities.get(address));
    }

    public Set<Address.Entity> getAllAddresses() {
        return this.entities.keySet();
    }

    public void register(MailEntity entity) {
        Address.Entity address = entity.getAddress();
        if (this.entities.containsKey(address)) {
            LOGGER.warn("Mail entity with address '{}' is already registered. Old one will be overwritten.", (Object)address);
        }
        this.entities.put(address, entity);
    }
}

